//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// MongoClustersServer is a fake server for instances of the armcosmos.MongoClustersClient type.
type MongoClustersServer struct {
	// CheckNameAvailability is the fake for method MongoClustersClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, parameters armcosmos.CheckNameAvailabilityRequest, options *armcosmos.MongoClustersClientCheckNameAvailabilityOptions) (resp azfake.Responder[armcosmos.MongoClustersClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method MongoClustersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, mongoClusterName string, parameters armcosmos.MongoCluster, options *armcosmos.MongoClustersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armcosmos.MongoClustersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateFirewallRule is the fake for method MongoClustersClient.BeginCreateOrUpdateFirewallRule
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateFirewallRule func(ctx context.Context, resourceGroupName string, mongoClusterName string, firewallRuleName string, parameters armcosmos.FirewallRule, options *armcosmos.MongoClustersClientBeginCreateOrUpdateFirewallRuleOptions) (resp azfake.PollerResponder[armcosmos.MongoClustersClientCreateOrUpdateFirewallRuleResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MongoClustersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, mongoClusterName string, options *armcosmos.MongoClustersClientBeginDeleteOptions) (resp azfake.PollerResponder[armcosmos.MongoClustersClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteFirewallRule is the fake for method MongoClustersClient.BeginDeleteFirewallRule
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteFirewallRule func(ctx context.Context, resourceGroupName string, mongoClusterName string, firewallRuleName string, options *armcosmos.MongoClustersClientBeginDeleteFirewallRuleOptions) (resp azfake.PollerResponder[armcosmos.MongoClustersClientDeleteFirewallRuleResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MongoClustersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, mongoClusterName string, options *armcosmos.MongoClustersClientGetOptions) (resp azfake.Responder[armcosmos.MongoClustersClientGetResponse], errResp azfake.ErrorResponder)

	// GetFirewallRule is the fake for method MongoClustersClient.GetFirewallRule
	// HTTP status codes to indicate success: http.StatusOK
	GetFirewallRule func(ctx context.Context, resourceGroupName string, mongoClusterName string, firewallRuleName string, options *armcosmos.MongoClustersClientGetFirewallRuleOptions) (resp azfake.Responder[armcosmos.MongoClustersClientGetFirewallRuleResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MongoClustersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcosmos.MongoClustersClientListOptions) (resp azfake.PagerResponder[armcosmos.MongoClustersClientListResponse])

	// NewListByResourceGroupPager is the fake for method MongoClustersClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armcosmos.MongoClustersClientListByResourceGroupOptions) (resp azfake.PagerResponder[armcosmos.MongoClustersClientListByResourceGroupResponse])

	// ListConnectionStrings is the fake for method MongoClustersClient.ListConnectionStrings
	// HTTP status codes to indicate success: http.StatusOK
	ListConnectionStrings func(ctx context.Context, resourceGroupName string, mongoClusterName string, options *armcosmos.MongoClustersClientListConnectionStringsOptions) (resp azfake.Responder[armcosmos.MongoClustersClientListConnectionStringsResponse], errResp azfake.ErrorResponder)

	// NewListFirewallRulesPager is the fake for method MongoClustersClient.NewListFirewallRulesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFirewallRulesPager func(resourceGroupName string, mongoClusterName string, options *armcosmos.MongoClustersClientListFirewallRulesOptions) (resp azfake.PagerResponder[armcosmos.MongoClustersClientListFirewallRulesResponse])

	// BeginUpdate is the fake for method MongoClustersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, mongoClusterName string, parameters armcosmos.MongoClusterUpdate, options *armcosmos.MongoClustersClientBeginUpdateOptions) (resp azfake.PollerResponder[armcosmos.MongoClustersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMongoClustersServerTransport creates a new instance of MongoClustersServerTransport with the provided implementation.
// The returned MongoClustersServerTransport instance is connected to an instance of armcosmos.MongoClustersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMongoClustersServerTransport(srv *MongoClustersServer) *MongoClustersServerTransport {
	return &MongoClustersServerTransport{
		srv:                             srv,
		beginCreateOrUpdate:             newTracker[azfake.PollerResponder[armcosmos.MongoClustersClientCreateOrUpdateResponse]](),
		beginCreateOrUpdateFirewallRule: newTracker[azfake.PollerResponder[armcosmos.MongoClustersClientCreateOrUpdateFirewallRuleResponse]](),
		beginDelete:                     newTracker[azfake.PollerResponder[armcosmos.MongoClustersClientDeleteResponse]](),
		beginDeleteFirewallRule:         newTracker[azfake.PollerResponder[armcosmos.MongoClustersClientDeleteFirewallRuleResponse]](),
		newListPager:                    newTracker[azfake.PagerResponder[armcosmos.MongoClustersClientListResponse]](),
		newListByResourceGroupPager:     newTracker[azfake.PagerResponder[armcosmos.MongoClustersClientListByResourceGroupResponse]](),
		newListFirewallRulesPager:       newTracker[azfake.PagerResponder[armcosmos.MongoClustersClientListFirewallRulesResponse]](),
		beginUpdate:                     newTracker[azfake.PollerResponder[armcosmos.MongoClustersClientUpdateResponse]](),
	}
}

// MongoClustersServerTransport connects instances of armcosmos.MongoClustersClient to instances of MongoClustersServer.
// Don't use this type directly, use NewMongoClustersServerTransport instead.
type MongoClustersServerTransport struct {
	srv                             *MongoClustersServer
	beginCreateOrUpdate             *tracker[azfake.PollerResponder[armcosmos.MongoClustersClientCreateOrUpdateResponse]]
	beginCreateOrUpdateFirewallRule *tracker[azfake.PollerResponder[armcosmos.MongoClustersClientCreateOrUpdateFirewallRuleResponse]]
	beginDelete                     *tracker[azfake.PollerResponder[armcosmos.MongoClustersClientDeleteResponse]]
	beginDeleteFirewallRule         *tracker[azfake.PollerResponder[armcosmos.MongoClustersClientDeleteFirewallRuleResponse]]
	newListPager                    *tracker[azfake.PagerResponder[armcosmos.MongoClustersClientListResponse]]
	newListByResourceGroupPager     *tracker[azfake.PagerResponder[armcosmos.MongoClustersClientListByResourceGroupResponse]]
	newListFirewallRulesPager       *tracker[azfake.PagerResponder[armcosmos.MongoClustersClientListFirewallRulesResponse]]
	beginUpdate                     *tracker[azfake.PollerResponder[armcosmos.MongoClustersClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for MongoClustersServerTransport.
func (m *MongoClustersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MongoClustersClient.CheckNameAvailability":
		resp, err = m.dispatchCheckNameAvailability(req)
	case "MongoClustersClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "MongoClustersClient.BeginCreateOrUpdateFirewallRule":
		resp, err = m.dispatchBeginCreateOrUpdateFirewallRule(req)
	case "MongoClustersClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MongoClustersClient.BeginDeleteFirewallRule":
		resp, err = m.dispatchBeginDeleteFirewallRule(req)
	case "MongoClustersClient.Get":
		resp, err = m.dispatchGet(req)
	case "MongoClustersClient.GetFirewallRule":
		resp, err = m.dispatchGetFirewallRule(req)
	case "MongoClustersClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MongoClustersClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "MongoClustersClient.ListConnectionStrings":
		resp, err = m.dispatchListConnectionStrings(req)
	case "MongoClustersClient.NewListFirewallRulesPager":
		resp, err = m.dispatchNewListFirewallRulesPager(req)
	case "MongoClustersClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if m.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkMongoClusterNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcosmos.CheckNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.CheckNameAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MongoCluster](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, mongoClusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchBeginCreateOrUpdateFirewallRule(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdateFirewallRule == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateFirewallRule not implemented")}
	}
	beginCreateOrUpdateFirewallRule := m.beginCreateOrUpdateFirewallRule.get(req)
	if beginCreateOrUpdateFirewallRule == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firewallRules/(?P<firewallRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.FirewallRule](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
		if err != nil {
			return nil, err
		}
		firewallRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("firewallRuleName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdateFirewallRule(req.Context(), resourceGroupNameParam, mongoClusterNameParam, firewallRuleNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateFirewallRule = &respr
		m.beginCreateOrUpdateFirewallRule.add(req, beginCreateOrUpdateFirewallRule)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateFirewallRule, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreateOrUpdateFirewallRule.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateFirewallRule) {
		m.beginCreateOrUpdateFirewallRule.remove(req)
	}

	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, mongoClusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchBeginDeleteFirewallRule(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteFirewallRule == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteFirewallRule not implemented")}
	}
	beginDeleteFirewallRule := m.beginDeleteFirewallRule.get(req)
	if beginDeleteFirewallRule == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firewallRules/(?P<firewallRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
		if err != nil {
			return nil, err
		}
		firewallRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("firewallRuleName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteFirewallRule(req.Context(), resourceGroupNameParam, mongoClusterNameParam, firewallRuleNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteFirewallRule = &respr
		m.beginDeleteFirewallRule.add(req, beginDeleteFirewallRule)
	}

	resp, err := server.PollerResponderNext(beginDeleteFirewallRule, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteFirewallRule.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteFirewallRule) {
		m.beginDeleteFirewallRule.remove(req)
	}

	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, mongoClusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MongoCluster, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchGetFirewallRule(req *http.Request) (*http.Response, error) {
	if m.srv.GetFirewallRule == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFirewallRule not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firewallRules/(?P<firewallRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
	if err != nil {
		return nil, err
	}
	firewallRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("firewallRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetFirewallRule(req.Context(), resourceGroupNameParam, mongoClusterNameParam, firewallRuleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FirewallRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListPager(nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcosmos.MongoClustersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armcosmos.MongoClustersClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchListConnectionStrings(req *http.Request) (*http.Response, error) {
	if m.srv.ListConnectionStrings == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListConnectionStrings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listConnectionStrings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.ListConnectionStrings(req.Context(), resourceGroupNameParam, mongoClusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListConnectionStringsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchNewListFirewallRulesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListFirewallRulesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFirewallRulesPager not implemented")}
	}
	newListFirewallRulesPager := m.newListFirewallRulesPager.get(req)
	if newListFirewallRulesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/firewallRules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListFirewallRulesPager(resourceGroupNameParam, mongoClusterNameParam, nil)
		newListFirewallRulesPager = &resp
		m.newListFirewallRulesPager.add(req, newListFirewallRulesPager)
		server.PagerResponderInjectNextLinks(newListFirewallRulesPager, req, func(page *armcosmos.MongoClustersClientListFirewallRulesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListFirewallRulesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListFirewallRulesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFirewallRulesPager) {
		m.newListFirewallRulesPager.remove(req)
	}
	return resp, nil
}

func (m *MongoClustersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/mongoClusters/(?P<mongoClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MongoClusterUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		mongoClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoClusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, mongoClusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
