//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// UserServer is a fake server for instances of the armapimanagement.UserClient type.
type UserServer struct {
	// CreateOrUpdate is the fake for method UserClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serviceName string, userID string, parameters armapimanagement.UserCreateParameters, options *armapimanagement.UserClientCreateOrUpdateOptions) (resp azfake.Responder[armapimanagement.UserClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method UserClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, serviceName string, userID string, ifMatch string, options *armapimanagement.UserClientDeleteOptions) (resp azfake.Responder[armapimanagement.UserClientDeleteResponse], errResp azfake.ErrorResponder)

	// GenerateSsoURL is the fake for method UserClient.GenerateSsoURL
	// HTTP status codes to indicate success: http.StatusOK
	GenerateSsoURL func(ctx context.Context, resourceGroupName string, serviceName string, userID string, options *armapimanagement.UserClientGenerateSsoURLOptions) (resp azfake.Responder[armapimanagement.UserClientGenerateSsoURLResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method UserClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serviceName string, userID string, options *armapimanagement.UserClientGetOptions) (resp azfake.Responder[armapimanagement.UserClientGetResponse], errResp azfake.ErrorResponder)

	// GetEntityTag is the fake for method UserClient.GetEntityTag
	// HTTP status codes to indicate success: http.StatusOK
	GetEntityTag func(ctx context.Context, resourceGroupName string, serviceName string, userID string, options *armapimanagement.UserClientGetEntityTagOptions) (resp azfake.Responder[armapimanagement.UserClientGetEntityTagResponse], errResp azfake.ErrorResponder)

	// GetSharedAccessToken is the fake for method UserClient.GetSharedAccessToken
	// HTTP status codes to indicate success: http.StatusOK
	GetSharedAccessToken func(ctx context.Context, resourceGroupName string, serviceName string, userID string, parameters armapimanagement.UserTokenParameters, options *armapimanagement.UserClientGetSharedAccessTokenOptions) (resp azfake.Responder[armapimanagement.UserClientGetSharedAccessTokenResponse], errResp azfake.ErrorResponder)

	// NewListByServicePager is the fake for method UserClient.NewListByServicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServicePager func(resourceGroupName string, serviceName string, options *armapimanagement.UserClientListByServiceOptions) (resp azfake.PagerResponder[armapimanagement.UserClientListByServiceResponse])

	// Update is the fake for method UserClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, serviceName string, userID string, ifMatch string, parameters armapimanagement.UserUpdateParameters, options *armapimanagement.UserClientUpdateOptions) (resp azfake.Responder[armapimanagement.UserClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewUserServerTransport creates a new instance of UserServerTransport with the provided implementation.
// The returned UserServerTransport instance is connected to an instance of armapimanagement.UserClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUserServerTransport(srv *UserServer) *UserServerTransport {
	return &UserServerTransport{
		srv:                   srv,
		newListByServicePager: newTracker[azfake.PagerResponder[armapimanagement.UserClientListByServiceResponse]](),
	}
}

// UserServerTransport connects instances of armapimanagement.UserClient to instances of UserServer.
// Don't use this type directly, use NewUserServerTransport instead.
type UserServerTransport struct {
	srv                   *UserServer
	newListByServicePager *tracker[azfake.PagerResponder[armapimanagement.UserClientListByServiceResponse]]
}

// Do implements the policy.Transporter interface for UserServerTransport.
func (u *UserServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UserClient.CreateOrUpdate":
		resp, err = u.dispatchCreateOrUpdate(req)
	case "UserClient.Delete":
		resp, err = u.dispatchDelete(req)
	case "UserClient.GenerateSsoURL":
		resp, err = u.dispatchGenerateSsoURL(req)
	case "UserClient.Get":
		resp, err = u.dispatchGet(req)
	case "UserClient.GetEntityTag":
		resp, err = u.dispatchGetEntityTag(req)
	case "UserClient.GetSharedAccessToken":
		resp, err = u.dispatchGetSharedAccessToken(req)
	case "UserClient.NewListByServicePager":
		resp, err = u.dispatchNewListByServicePager(req)
	case "UserClient.Update":
		resp, err = u.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UserServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if u.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armapimanagement.UserCreateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	notifyUnescaped, err := url.QueryUnescape(qp.Get("notify"))
	if err != nil {
		return nil, err
	}
	notifyParam, err := parseOptional(notifyUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armapimanagement.UserClientCreateOrUpdateOptions
	if notifyParam != nil || ifMatchParam != nil {
		options = &armapimanagement.UserClientCreateOrUpdateOptions{
			Notify:  notifyParam,
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := u.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if u.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	deleteSubscriptionsUnescaped, err := url.QueryUnescape(qp.Get("deleteSubscriptions"))
	if err != nil {
		return nil, err
	}
	deleteSubscriptionsParam, err := parseOptional(deleteSubscriptionsUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	notifyUnescaped, err := url.QueryUnescape(qp.Get("notify"))
	if err != nil {
		return nil, err
	}
	notifyParam, err := parseOptional(notifyUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	appTypeUnescaped, err := url.QueryUnescape(qp.Get("appType"))
	if err != nil {
		return nil, err
	}
	appTypeParam := getOptional(armapimanagement.AppType(appTypeUnescaped))
	var options *armapimanagement.UserClientDeleteOptions
	if deleteSubscriptionsParam != nil || notifyParam != nil || appTypeParam != nil {
		options = &armapimanagement.UserClientDeleteOptions{
			DeleteSubscriptions: deleteSubscriptionsParam,
			Notify:              notifyParam,
			AppType:             appTypeParam,
		}
	}
	respr, errRespr := u.srv.Delete(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, getHeaderValue(req.Header, "If-Match"), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchGenerateSsoURL(req *http.Request) (*http.Response, error) {
	if u.srv.GenerateSsoURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateSsoURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateSsoUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := u.srv.GenerateSsoURL(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GenerateSsoURLResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if u.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := u.srv.Get(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchGetEntityTag(req *http.Request) (*http.Response, error) {
	if u.srv.GetEntityTag == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetEntityTag not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := u.srv.GetEntityTag(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchGetSharedAccessToken(req *http.Request) (*http.Response, error) {
	if u.srv.GetSharedAccessToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSharedAccessToken not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/token`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapimanagement.UserTokenParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := u.srv.GetSharedAccessToken(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserTokenResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchNewListByServicePager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListByServicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServicePager not implemented")}
	}
	newListByServicePager := u.newListByServicePager.get(req)
	if newListByServicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		expandGroupsUnescaped, err := url.QueryUnescape(qp.Get("expandGroups"))
		if err != nil {
			return nil, err
		}
		expandGroupsParam, err := parseOptional(expandGroupsUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.UserClientListByServiceOptions
		if filterParam != nil || topParam != nil || skipParam != nil || expandGroupsParam != nil {
			options = &armapimanagement.UserClientListByServiceOptions{
				Filter:       filterParam,
				Top:          topParam,
				Skip:         skipParam,
				ExpandGroups: expandGroupsParam,
			}
		}
		resp := u.srv.NewListByServicePager(resourceGroupNameParam, serviceNameParam, options)
		newListByServicePager = &resp
		u.newListByServicePager.add(req, newListByServicePager)
		server.PagerResponderInjectNextLinks(newListByServicePager, req, func(page *armapimanagement.UserClientListByServiceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListByServicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServicePager) {
		u.newListByServicePager.remove(req)
	}
	return resp, nil
}

func (u *UserServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if u.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapimanagement.UserUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	userIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("userId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := u.srv.Update(req.Context(), resourceGroupNameParam, serviceNameParam, userIDParam, getHeaderValue(req.Header, "If-Match"), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}
