# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from FrameClasses import FRAME_CLASSES

HEADER = "// THIS IS AUTOGENERATED BY GenerateFrameLists.py.  DO NOT EDIT\n"


# Returns a list of list of FrameClass objects.  The outermost list groups
# the FrameClasses by their frame type, and is sorted from the largest group
# to the smallest, and otherwise sorted by the frame type or class name.
def grouped_frame_classes():
    groups = dict()
    for frame in FRAME_CLASSES:
        if frame.is_concrete:
            groups.setdefault(frame.ty, []).append(frame)
    groups = groups.values()
    return sorted(groups, key=lambda x: (-len(x), x[0].ty if len(x) > 1 else x[0].cls))


def generate_frame_id_list_h(output, *ignore):
    groups = grouped_frame_classes()
    output.write(HEADER)
    for group in groups:
        for frame in group:
            output.write(
                "FRAME_ID(%s, %s, %s)\n"
                % (
                    frame.cls,
                    frame.ty,
                    "|".join("ClassFlags::%s" % flag for flag in sorted(frame.flags)),
                )
            )
    for frame in FRAME_CLASSES:
        if not frame.is_concrete:
            output.write("ABSTRACT_FRAME_ID(%s)\n" % frame.cls)


def generate_frame_type_list_h(output, *ignore):
    groups = grouped_frame_classes()
    output.write(HEADER)
    for group in groups:
        output.write(
            "FRAME_TYPE(%s, %s, %s)\n" % (group[0].ty, group[0].cls, group[-1].cls)
        )
