/*
 * Decompiled with CFR 0.152.
 */
package vtk.rendering;

import java.util.concurrent.locks.ReentrantLock;
import vtk.rendering.vtkComponent;
import vtk.rendering.vtkInteractorForwarder;
import vtk.vtkAxesActor;
import vtk.vtkCamera;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorStyle;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkOrientationMarkerWidget;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;

public abstract class vtkAbstractComponent<T>
implements vtkComponent<T> {
    protected vtkRenderWindow renderWindow;
    protected vtkRenderer renderer;
    protected vtkCamera camera;
    protected vtkGenericRenderWindowInteractor windowInteractor;
    protected vtkInteractorForwarder eventForwarder;
    protected ReentrantLock lock;
    protected boolean inRenderCall = false;

    public vtkAbstractComponent() {
        this(new vtkRenderWindow());
    }

    public vtkAbstractComponent(vtkRenderWindow vtkRenderWindow2) {
        this.renderWindow = vtkRenderWindow2;
        this.renderer = new vtkRenderer();
        this.windowInteractor = new vtkGenericRenderWindowInteractor();
        this.lock = new ReentrantLock();
        this.windowInteractor.SetRenderWindow(this.renderWindow);
        this.windowInteractor.TimerEventResetsTimerOff();
        this.windowInteractor.SetSize(200, 200);
        this.windowInteractor.ConfigureEvent();
        vtkInteractorStyleTrackballCamera vtkInteractorStyleTrackballCamera2 = new vtkInteractorStyleTrackballCamera();
        this.windowInteractor.SetInteractorStyle(vtkInteractorStyleTrackballCamera2);
        this.eventForwarder = new vtkInteractorForwarder(this);
        this.windowInteractor.AddObserver("CreateTimerEvent", this.eventForwarder, "StartTimer");
        this.windowInteractor.AddObserver("DestroyTimerEvent", this.eventForwarder, "DestroyTimer");
        this.renderWindow.AddRenderer(this.renderer);
        this.camera = this.renderer.GetActiveCamera();
    }

    @Override
    public ReentrantLock getVTKLock() {
        return this.lock;
    }

    @Override
    public void resetCamera() {
        if (this.renderer == null) {
            return;
        }
        try {
            this.lock.lockInterruptibly();
            this.renderer.ResetCamera();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetCameraClippingRange() {
        if (this.renderWindow == null) {
            return;
        }
        try {
            this.lock.lockInterruptibly();
            this.renderer.ResetCameraClippingRange();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public vtkCamera getActiveCamera() {
        return this.camera;
    }

    @Override
    public vtkRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public vtkRenderWindow getRenderWindow() {
        return this.renderWindow;
    }

    @Override
    public vtkGenericRenderWindowInteractor getRenderWindowInteractor() {
        return this.windowInteractor;
    }

    @Override
    public void setInteractorStyle(vtkInteractorStyle vtkInteractorStyle2) {
        if (this.windowInteractor != null) {
            this.lock.lock();
            this.windowInteractor.SetInteractorStyle(vtkInteractorStyle2);
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(int n, int n2) {
        if (this.renderWindow == null || this.windowInteractor == null) {
            return;
        }
        try {
            this.lock.lockInterruptibly();
            this.renderWindow.SetSize(n, n2);
            this.windowInteractor.SetSize(n, n2);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void Delete() {
        this.lock.lock();
        this.renderer = null;
        this.camera = null;
        this.windowInteractor = null;
        this.lock.unlock();
    }

    @Override
    public vtkInteractorForwarder getInteractorForwarder() {
        return this.eventForwarder;
    }

    @Override
    public abstract T getComponent();

    public static void attachOrientationAxes(vtkComponent<?> vtkComponent2) {
        vtkAxesActor vtkAxesActor2 = new vtkAxesActor();
        vtkOrientationMarkerWidget vtkOrientationMarkerWidget2 = new vtkOrientationMarkerWidget();
        vtkOrientationMarkerWidget2.SetOutlineColor(0.93, 0.57, 0.13);
        vtkOrientationMarkerWidget2.SetOrientationMarker(vtkAxesActor2);
        vtkOrientationMarkerWidget2.SetInteractor(vtkComponent2.getRenderWindowInteractor());
        vtkOrientationMarkerWidget2.SetDefaultRenderer(vtkComponent2.getRenderer());
        vtkOrientationMarkerWidget2.SetViewport(0.0, 0.0, 0.2, 0.2);
        vtkOrientationMarkerWidget2.EnabledOn();
        vtkOrientationMarkerWidget2.InteractiveOff();
    }
}

