/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import org.apache.tomcat.util.res.StringManager;

public class StoreFileMover {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.storeconfig");
    private String filename = "conf/server.xml";
    private String encoding = "UTF-8";
    private String basename = System.getProperty("catalina.base");
    private File configOld;
    private File configNew;
    private File configSave;

    public File getConfigNew() {
        return this.configNew;
    }

    public File getConfigOld() {
        return this.configOld;
    }

    public File getConfigSave() {
        return this.configSave;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String string) {
        this.basename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public StoreFileMover(String string, String string2, String string3) {
        this.setBasename(string);
        this.setEncoding(string3);
        this.setFilename(string2);
        this.init();
    }

    public StoreFileMover() {
        this.init();
    }

    public void init() {
        String string = this.getFilename();
        this.configOld = new File(string);
        if (!this.configOld.isAbsolute()) {
            this.configOld = new File(this.getBasename(), string);
        }
        this.configNew = new File(string + ".new");
        if (!this.configNew.isAbsolute()) {
            this.configNew = new File(this.getBasename(), string + ".new");
        }
        if (!this.configNew.getParentFile().exists() && !this.configNew.getParentFile().mkdirs()) {
            throw new IllegalStateException(sm.getString("storeFileMover.directoryCreationError", new Object[]{this.configNew}));
        }
        String string2 = this.getTimeTag();
        int n = 0;
        do {
            this.configSave = new File(string + string2 + "-" + String.valueOf(n));
            if (!this.configSave.isAbsolute()) {
                this.configSave = new File(this.getBasename(), string + string2 + "-" + String.valueOf(n));
            }
            ++n;
        } while (this.configSave.exists());
    }

    public void move() throws IOException {
        if (this.configOld.renameTo(this.configSave)) {
            if (!this.configNew.renameTo(this.configOld)) {
                this.configSave.renameTo(this.configOld);
                throw new IOException(sm.getString("storeFileMover.renameError", new Object[]{this.configNew.getAbsolutePath(), this.configOld.getAbsolutePath()}));
            }
        } else if (!this.configOld.exists()) {
            if (!this.configNew.renameTo(this.configOld)) {
                throw new IOException(sm.getString("storeFileMover.renameError", new Object[]{this.configNew.getAbsolutePath(), this.configOld.getAbsolutePath()}));
            }
        } else {
            throw new IOException(sm.getString("storeFileMover.renameError", new Object[]{this.configOld.getAbsolutePath(), this.configSave.getAbsolutePath()}));
        }
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configNew), this.getEncoding()));
    }

    protected String getTimeTag() {
        String string = new Timestamp(System.currentTimeMillis()).toString();
        StringBuilder stringBuilder = new StringBuilder(".");
        stringBuilder.append(string, 0, 10);
        stringBuilder.append('.');
        stringBuilder.append(string, 11, 13);
        stringBuilder.append('-');
        stringBuilder.append(string, 14, 16);
        stringBuilder.append('-');
        stringBuilder.append(string, 17, 19);
        return stringBuilder.toString();
    }
}

