/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageSerializer {
    public static String imageToBytes(Image image) throws IOException {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", baos);
        g.dispose();
        return new String(baos.toByteArray(), StandardCharsets.ISO_8859_1);
    }

    public static String iconToBytesPreview(Icon icon, int maxSize) throws IOException {
        if (icon.getIconHeight() <= maxSize && icon.getIconWidth() <= maxSize) {
            return ImageSerializer.imageToBytes(ImageSerializer.toImage(icon));
        }
        return null;
    }

    public static String iconToBytesPreviewNormal(Icon icon) throws IOException {
        return ImageSerializer.iconToBytesPreview(icon, 16);
    }

    public static String iconToBytesPreviewRetina(Icon icon) throws IOException {
        return ImageSerializer.iconToBytesPreview(icon, 32);
    }

    public static String iconToBytes(Icon icon) throws IOException {
        return ImageSerializer.imageToBytes(ImageSerializer.toImage(icon));
    }

    private static Image toImage(Icon icon) {
        BufferedImage image;
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        try {
            image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        }
        catch (HeadlessException e) {
            image = new BufferedImage(w, h, 2);
        }
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }
}

