/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record NodeRange(Node start, Node end) {
    public NodeRange {
        if (end.isBefore(start)) {
            throw new IllegalArgumentException("End before start: " + start.startOffset() + " vs " + end.startOffset());
        }
        if (start.tree() != end.tree()) {
            throw new IllegalArgumentException("Nodes from different trees!");
        }
    }

    public TextRange textRange() {
        return new TextRange(this.start.startOffset(), this.end.endOffset());
    }

    @Override
    public String toString() {
        return this.start.form() + ".." + this.end.form();
    }

    public static boolean isInRange(@NotNull Node node, @Nullable Node start, @Nullable Node end) {
        return start != null && end != null && !start.isAfter(node) && !end.isBefore(node);
    }
}

