/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.config.TaskRepositoriesConfigurable;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TaskSearchSupport {
    static final String TASKS_NOTIFICATION_GROUP = "Task Group";

    private TaskSearchSupport() {
    }

    public static List<Task> getLocalAndCachedTasks(TaskManager myManager, String pattern, boolean withClosed) {
        ArrayList tasks = new ArrayList();
        tasks.addAll(myManager.getLocalTasks(withClosed));
        tasks.addAll(ContainerUtil.filter((Collection)myManager.getCachedIssues(withClosed), task -> myManager.findTask(task.getId()) == null));
        List filteredTasks = ContainerUtil.sorted((Collection)TaskUtil.filterTasks((String)pattern, tasks), (Comparator)TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        return filteredTasks;
    }

    public static List<Task> getRepositoriesTasks(Project project, String pattern, int offset, int limit, boolean forceRequest, boolean withClosed, @NotNull ProgressIndicator cancelled) {
        if (cancelled == null) {
            TaskSearchSupport.$$$reportNull$$$0(0);
        }
        try {
            TaskManager manager = TaskManager.getManager((Project)project);
            List tasks = manager.getIssues(pattern, offset, limit, withClosed, cancelled, forceRequest);
            return ContainerUtil.sorted((Collection)tasks, (Comparator)TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        }
        catch (RequestFailedException e) {
            TaskSearchSupport.notifyAboutConnectionFailure(e, project);
            return Collections.emptyList();
        }
    }

    public static List<Task> getItems(TaskManager myManager, String pattern, boolean cached, boolean autopopup) {
        return TaskUtil.filterTasks((String)pattern, TaskSearchSupport.getTasks(pattern, cached, autopopup, myManager));
    }

    private static List<Task> getTasks(String pattern, boolean cached, boolean autopopup, TaskManager myManager) {
        return cached ? myManager.getCachedIssues() : myManager.getIssues(pattern, !autopopup);
    }

    private static void notifyAboutConnectionFailure(RequestFailedException e, Project project) {
        String details = e.getMessage();
        TaskRepository repository = e.getRepository();
        Object content = TaskBundle.message((String)"notification.content.p.href.configure.server.p", (Object[])new Object[0]);
        if (!StringUtil.isEmpty((String)details)) {
            content = "<p>" + details + "</p>" + (String)content;
        }
        new Notification(TASKS_NOTIFICATION_GROUP, TaskBundle.message((String)"notification.title.cannot.connect.to", (Object[])new Object[]{repository.getUrl()}), (String)content, NotificationType.WARNING).setListener((notification, event) -> {
            TaskRepositoriesConfigurable configurable = new TaskRepositoriesConfigurable(project);
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
            if (!ArrayUtil.contains((Object)repository, (Object[])TaskManager.getManager((Project)project).getAllRepositories())) {
                notification.expire();
            }
        }).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelled", "com/intellij/tasks/actions/TaskSearchSupport", "getRepositoriesTasks"));
    }
}

