/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.ignore.FileGroupInfo;
import org.jetbrains.idea.svn.ignore.IgnoreGroupHelperAction;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class RemoveFromIgnoreListAction
extends BasicAction {
    private final boolean myUseCommonExtension;

    public RemoveFromIgnoreListAction(boolean useCommonExtension) {
        this.myUseCommonExtension = useCommonExtension;
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("action.name.undo.ignore.files", new Object[0]);
        if (string == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        IgnoreGroupHelperAction helper = IgnoreGroupHelperAction.createFor(e);
        if (helper == null || !helper.allAreIgnored()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        FileGroupInfo fileGroupInfo = helper.getFileGroupInfo();
        if (this.myUseCommonExtension) {
            presentation.setEnabledAndVisible(helper.areIgnoreExtensionOk());
            presentation.setText(fileGroupInfo.getExtensionMask(), false);
            presentation.setDescription(SvnBundle.messagePointer("action.Subversion.UndoIgnore.description", new Object[0]));
        } else {
            presentation.setEnabledAndVisible(helper.areIgnoreFilesOk());
            if (fileGroupInfo.oneFileSelected()) {
                presentation.setText(fileGroupInfo.getFileName(), false);
            } else {
                presentation.setText(SvnBundle.messagePointer("action.Subversion.UndoIgnore.text", new Object[0]));
            }
            presentation.setDescription(SvnBundle.messagePointer("action.Subversion.UndoIgnore.description", new Object[0]));
        }
    }

    @Override
    protected VirtualFile @Nullable [] getSelectedFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(2);
        }
        return IgnoreGroupHelperAction.getSelectedFiles(e);
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(4);
        }
        return IgnoreGroupHelperAction.isIgnored(vcs, file);
    }

    @Override
    protected void doVcsRefresh(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(6);
        }
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)vcs.getProject());
        if (file.getParent() != null) {
            vcsDirtyScopeManager.fileDirty(file.getParent());
        }
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) {
        if (vcs == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(8);
        }
        if (context == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(9);
        }
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(10);
        }
        if (context == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(11);
        }
        if (files == null) {
            RemoveFromIgnoreListAction.$$$reportNull$$$0(12);
        }
        FileGroupInfo groupInfo = new FileGroupInfo();
        for (VirtualFile file : files) {
            groupInfo.onFileEnabled(file);
        }
        SvnPropertyService.doRemoveFromIgnoreProperty(vcs, this.myUseCommonExtension, files, groupInfo);
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/RemoveFromIgnoreListAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/RemoveFromIgnoreListAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doVcsRefresh";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

