/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.pyi;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassMembersProviderBase;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingAncestorsClassMembersProvider;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyiClassMembersProvider
extends PyClassMembersProviderBase
implements PyOverridingAncestorsClassMembersProvider {
    @Override
    @NotNull
    public Collection<PyCustomMember> getMembers(@NotNull PyClassType classType, PsiElement location, @NotNull TypeEvalContext context) {
        PyClass cls;
        PsiElement pythonStub;
        if (classType == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(1);
        }
        if ((pythonStub = PyiUtil.getPythonStub(cls = classType.getPyClass())) instanceof PyClass) {
            Collection<PyCustomMember> collection = PyiClassMembersProvider.getClassMembers((PyClass)pythonStub, classType.isDefinition());
            if (collection == null) {
                PyiClassMembersProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        List<PyCustomMember> list = Collections.emptyList();
        if (list == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement resolveMember(@NotNull PyClassType type2, @NotNull String name2, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        PyClass cls;
        PsiElement pythonStub;
        if (type2 == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(6);
        }
        if ((pythonStub = PyiUtil.getPythonStub(cls = type2.getPyClass())) instanceof PyClass) {
            return PyiClassMembersProvider.findClassMember((PyClass)pythonStub, name2, type2.isDefinition());
        }
        return null;
    }

    public static PsiElement findClassMember(@NotNull PyClass cls, @NotNull String name2, boolean isDefinition) {
        PyTargetExpression instanceAttribute;
        PyFunction function;
        if (cls == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(8);
        }
        if ((function = cls.findMethodByName(name2, false, null)) != null) {
            boolean instanceMethod;
            PyUtil.MethodFlags methodFlags = PyUtil.MethodFlags.of(function);
            boolean bl = instanceMethod = methodFlags == null || methodFlags.isInstanceMethod();
            if (isDefinition ^ instanceMethod) {
                return function;
            }
        }
        if (!isDefinition && (instanceAttribute = cls.findInstanceAttribute(name2, false)) != null) {
            return instanceAttribute;
        }
        PyTargetExpression classAttribute = cls.findClassAttribute(name2, false, null);
        if (classAttribute != null) {
            return classAttribute;
        }
        return null;
    }

    public static Collection<PyCustomMember> getClassMembers(@NotNull PyClass cls, boolean isDefinition) {
        if (cls == null) {
            PyiClassMembersProvider.$$$reportNull$$$0(9);
        }
        ArrayList<PyCustomMember> result2 = new ArrayList<PyCustomMember>();
        for (PyFunction function : cls.getMethods()) {
            boolean instanceMethod;
            String name2 = function.getName();
            PyUtil.MethodFlags methodFlags = PyUtil.MethodFlags.of(function);
            boolean bl = instanceMethod = methodFlags == null || methodFlags.isInstanceMethod();
            if (name2 == null || !(isDefinition ^ instanceMethod)) continue;
            result2.add(new PyCustomMember(name2, function));
        }
        if (!isDefinition) {
            for (PyTargetExpression attribute : cls.getInstanceAttributes()) {
                String name3 = attribute.getName();
                if (name3 == null) continue;
                result2.add(new PyCustomMember(name3, attribute));
            }
        }
        for (PyTargetExpression attribute : cls.getClassAttributes()) {
            String name4 = attribute.getName();
            if (name4 == null) continue;
            result2.add(new PyCustomMember(name4, attribute));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/pyi/PyiClassMembersProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/pyi/PyiClassMembersProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassMember";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

