/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.CheckList;
import com.selectivem.collections.IndexedImmutableSetImpl;
import com.selectivem.collections.UnmodifiableSetImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;

class CheckListImpl {
    CheckListImpl() {
    }

    static <E> CheckList<E> create(Set<E> elements) {
        return CheckListImpl.create(elements, "element");
    }

    static <E> CheckList<E> create(Set<E> elements, String elementName) {
        int size = elements.size();
        if (size == 2) {
            Iterator<E> iter = elements.iterator();
            return new TwoElementCheckList<E>(iter.next(), iter.next(), elementName);
        }
        if (size >= 800) {
            return new HashMapCheckList<E>(elements, elementName);
        }
        return new ArrayCheckList<E>(elements, elementName);
    }

    static final class TwoElementCheckList<E>
    implements CheckList<E> {
        private final E e1;
        private final E e2;
        private final String elementName;
        private Set<E> elements;
        private boolean e1checked;
        private boolean e2checked;

        TwoElementCheckList(E e1, E e2, String elementName) {
            this.e1 = e1;
            this.e2 = e2;
            this.elementName = elementName;
        }

        @Override
        public boolean check(E element) {
            if (element.equals(this.e1)) {
                this.e1checked = true;
            } else if (element.equals(this.e2)) {
                this.e2checked = true;
            } else {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            return this.e1checked && this.e2checked;
        }

        @Override
        public void uncheck(E element) {
            if (element.equals(this.e1)) {
                this.e1checked = false;
            } else if (element.equals(this.e2)) {
                this.e2checked = false;
            } else {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
        }

        @Override
        public void uncheckIfPresent(E element) {
            if (element.equals(this.e1)) {
                this.e1checked = false;
            } else if (element.equals(this.e2)) {
                this.e2checked = false;
            }
        }

        @Override
        public boolean checkIf(Predicate<E> checkPredicate) {
            if (!this.e1checked && checkPredicate.test(this.e1)) {
                this.e1checked = true;
            }
            if (!this.e2checked && checkPredicate.test(this.e2)) {
                this.e2checked = true;
            }
            return this.e1checked && this.e2checked;
        }

        @Override
        public void uncheckIf(Predicate<E> checkPredicate) {
            if (this.e1checked && checkPredicate.test(this.e1)) {
                this.e1checked = false;
            }
            if (this.e2checked && checkPredicate.test(this.e2)) {
                this.e2checked = false;
            }
        }

        @Override
        public void checkAll() {
            this.e1checked = true;
            this.e2checked = true;
        }

        @Override
        public void uncheckAll() {
            this.e1checked = false;
            this.e2checked = false;
        }

        @Override
        public boolean isChecked(E element) {
            if (element.equals(this.e1)) {
                return this.e1checked;
            }
            if (element.equals(this.e2)) {
                return this.e2checked;
            }
            throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
        }

        @Override
        public boolean isComplete() {
            return this.e1checked && this.e2checked;
        }

        @Override
        public boolean isBlank() {
            return !this.e1checked && !this.e2checked;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Set<E> getElements() {
            if (this.elements == null) {
                this.elements = new IndexedImmutableSetImpl.TwoElementSet<E>(this.e1, this.e2);
            }
            return this.elements;
        }

        @Override
        public Set<E> getCheckedElements() {
            if (this.e1checked) {
                if (this.e2checked) {
                    return this.getElements();
                }
                return IndexedImmutableSetImpl.of(this.e1);
            }
            if (this.e2checked) {
                return IndexedImmutableSetImpl.of(this.e2);
            }
            return IndexedImmutableSetImpl.empty();
        }

        @Override
        public Set<E> getUncheckedElements() {
            if (this.e1checked) {
                if (this.e2checked) {
                    return IndexedImmutableSetImpl.empty();
                }
                return IndexedImmutableSetImpl.of(this.e2);
            }
            if (this.e2checked) {
                return IndexedImmutableSetImpl.of(this.e1);
            }
            return this.getElements();
        }

        @Override
        public Iterable<E> iterateCheckedElements() {
            return this.getCheckedElements();
        }

        @Override
        public Iterable<E> iterateUncheckedElements() {
            return this.getUncheckedElements();
        }
    }

    static final class HashMapCheckList<E>
    implements CheckList<E> {
        private final Set<E> elements;
        private final Map<E, Boolean> checked;
        private final String elementName;
        private int uncheckedCount;
        private final int size;

        HashMapCheckList(Set<E> elements, String elementName) {
            this.checked = HashMapCheckList.createCheckedMap(elements);
            this.elements = Collections.unmodifiableSet(this.checked.keySet());
            this.uncheckedCount = this.size = this.elements.size();
            this.elementName = elementName;
        }

        @Override
        public boolean check(E element) {
            this.doCheck(element);
            return this.uncheckedCount == 0;
        }

        private void doCheck(E element) {
            Boolean current = this.checked.get(element);
            if (current == null) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            if (!current.booleanValue()) {
                this.checked.put(element, Boolean.TRUE);
                --this.uncheckedCount;
            }
        }

        @Override
        public void uncheck(E element) {
            Boolean current = this.checked.get(element);
            if (current == null) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            if (current.booleanValue()) {
                this.checked.put(element, Boolean.FALSE);
                ++this.uncheckedCount;
            }
        }

        @Override
        public void uncheckIfPresent(E element) {
            Boolean current = this.checked.get(element);
            if (current == null) {
                return;
            }
            if (current.booleanValue()) {
                this.checked.put(element, Boolean.FALSE);
                ++this.uncheckedCount;
            }
        }

        @Override
        public boolean checkIf(Predicate<E> checkPredicate) {
            if (this.isComplete()) {
                return true;
            }
            this.checked.forEach((e, v) -> {
                if (!v.booleanValue() && checkPredicate.test(e)) {
                    this.checked.put(e, Boolean.TRUE);
                    --this.uncheckedCount;
                }
            });
            return this.uncheckedCount == 0;
        }

        @Override
        public void uncheckIf(Predicate<E> checkPredicate) {
            if (this.isBlank()) {
                return;
            }
            this.checked.forEach((e, v) -> {
                if (v.booleanValue() && checkPredicate.test(e)) {
                    this.checked.put(e, Boolean.FALSE);
                    ++this.uncheckedCount;
                }
            });
        }

        @Override
        public void checkAll() {
            if (this.isComplete()) {
                return;
            }
            for (E element : this.elements) {
                this.checked.put(element, Boolean.TRUE);
            }
            this.uncheckedCount = 0;
        }

        @Override
        public void uncheckAll() {
            if (this.isBlank()) {
                return;
            }
            for (E element : this.elements) {
                this.checked.put(element, Boolean.FALSE);
            }
            this.uncheckedCount = this.size;
        }

        @Override
        public boolean isChecked(E element) {
            Boolean current = this.checked.get(element);
            if (current == null) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            return current;
        }

        @Override
        public boolean isComplete() {
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean isBlank() {
            return this.uncheckedCount == this.size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Set<E> getElements() {
            return this.elements;
        }

        @Override
        public Set<E> getCheckedElements() {
            if (this.isComplete()) {
                return this.elements;
            }
            if (this.isBlank()) {
                return IndexedImmutableSetImpl.empty();
            }
            return new UnmodifiableSetImpl<E>(){

                @Override
                public boolean contains(Object o) {
                    Boolean checked = (Boolean)checked.get(o);
                    if (checked == null) {
                        return false;
                    }
                    return checked;
                }

                @Override
                public Iterator<E> iterator() {
                    final Iterator delegate = elements.iterator();
                    return new Iterator<E>(){
                        private E next = this.findNext();

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public E next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object result = this.next;
                            this.next = this.findNext();
                            return result;
                        }

                        E findNext() {
                            while (delegate.hasNext()) {
                                Object e = delegate.next();
                                if (!((Boolean)checked.get(e)).booleanValue()) continue;
                                return e;
                            }
                            return null;
                        }
                    };
                }

                @Override
                public int size() {
                    return size - uncheckedCount;
                }
            };
        }

        @Override
        public Set<E> getUncheckedElements() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isBlank()) {
                return this.elements;
            }
            return new UnmodifiableSetImpl<E>(){

                @Override
                public boolean contains(Object o) {
                    Boolean checked = (Boolean)checked.get(o);
                    if (checked == null) {
                        return false;
                    }
                    return checked == false;
                }

                @Override
                public Iterator<E> iterator() {
                    final Iterator delegate = elements.iterator();
                    return new Iterator<E>(){
                        private E next = this.findNext();

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public E next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object result = this.next;
                            this.next = this.findNext();
                            return result;
                        }

                        E findNext() {
                            while (delegate.hasNext()) {
                                Object e = delegate.next();
                                if (((Boolean)checked.get(e)).booleanValue()) continue;
                                return e;
                            }
                            return null;
                        }
                    };
                }

                @Override
                public int size() {
                    return uncheckedCount;
                }
            };
        }

        @Override
        public Iterable<E> iterateCheckedElements() {
            return this.getCheckedElements();
        }

        @Override
        public Iterable<E> iterateUncheckedElements() {
            return this.getUncheckedElements();
        }

        static <E> Map<E, Boolean> createCheckedMap(Set<E> elements) {
            HashMap<E, Boolean> result = new HashMap<E, Boolean>(elements.size());
            for (E e : elements) {
                result.put(e, Boolean.FALSE);
            }
            return result;
        }
    }

    static final class ArrayCheckList<E>
    implements CheckList<E> {
        private final IndexedImmutableSetImpl<E> elements;
        private final boolean[] checked;
        private final String elementName;
        private int uncheckedCount;
        private final int size;

        ArrayCheckList(Set<E> elements, String elementName) {
            this.elements = IndexedImmutableSetImpl.of(elements);
            this.size = this.elements.size();
            this.checked = new boolean[this.size];
            this.uncheckedCount = this.size;
            this.elementName = elementName;
        }

        @Override
        public boolean check(E element) {
            this.doCheck(element);
            return this.uncheckedCount == 0;
        }

        private void doCheck(E element) {
            int tablePos = this.elements.elementToIndex((Object)element);
            if (tablePos == -1) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            if (!this.checked[tablePos]) {
                this.checked[tablePos] = true;
                --this.uncheckedCount;
            }
        }

        @Override
        public void uncheck(E element) {
            int tablePos = this.elements.elementToIndex((Object)element);
            if (tablePos == -1) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            if (this.checked[tablePos]) {
                this.checked[tablePos] = false;
                ++this.uncheckedCount;
            }
        }

        @Override
        public void uncheckIfPresent(E element) {
            int tablePos = this.elements.elementToIndex((Object)element);
            if (tablePos == -1) {
                return;
            }
            if (this.checked[tablePos]) {
                this.checked[tablePos] = false;
                ++this.uncheckedCount;
            }
        }

        @Override
        public boolean checkIf(Predicate<E> checkPredicate) {
            for (int i = 0; i < this.size; ++i) {
                if (this.checked[i] || !checkPredicate.test(this.elements.indexToElement(i))) continue;
                this.checked[i] = true;
                --this.uncheckedCount;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public void uncheckIf(Predicate<E> checkPredicate) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.checked[i] || !checkPredicate.test(this.elements.indexToElement(i))) continue;
                this.checked[i] = false;
                ++this.uncheckedCount;
            }
        }

        @Override
        public void checkAll() {
            Arrays.fill(this.checked, true);
            this.uncheckedCount = 0;
        }

        @Override
        public void uncheckAll() {
            Arrays.fill(this.checked, false);
            this.uncheckedCount = this.size;
        }

        @Override
        public boolean isChecked(E element) {
            int tablePos = this.elements.elementToIndex((Object)element);
            if (tablePos == -1) {
                throw new IllegalArgumentException("Invalid " + this.elementName + ": " + element);
            }
            return this.checked[tablePos];
        }

        @Override
        public boolean isComplete() {
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean isBlank() {
            return this.uncheckedCount == this.size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Set<E> getElements() {
            return this.elements;
        }

        @Override
        public Set<E> getCheckedElements() {
            if (this.isComplete()) {
                return this.elements;
            }
            if (this.isBlank()) {
                return IndexedImmutableSetImpl.empty();
            }
            return new UnmodifiableSetImpl<E>(){

                @Override
                public boolean contains(Object o) {
                    int tablePos = elements.elementToIndex(o);
                    if (tablePos == -1) {
                        return false;
                    }
                    return checked[tablePos];
                }

                @Override
                public Iterator<E> iterator() {
                    final int tableSize = elements.size();
                    return new Iterator<E>(){
                        private int pos = this.findNext(0);
                        private boolean ready = true;

                        @Override
                        public boolean hasNext() {
                            if (this.ready) {
                                return this.pos != -1;
                            }
                            if (this.pos != -1) {
                                this.pos = this.findNext(this.pos + 1);
                                this.ready = true;
                            }
                            return this.pos != -1;
                        }

                        @Override
                        public E next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object element = elements.indexToElement(this.pos);
                            this.ready = false;
                            return element;
                        }

                        int findNext(int start) {
                            for (int i = start; i < tableSize; ++i) {
                                if (!checked[i]) continue;
                                return i;
                            }
                            return -1;
                        }
                    };
                }

                @Override
                public int size() {
                    return size - uncheckedCount;
                }
            };
        }

        @Override
        public Set<E> getUncheckedElements() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isBlank()) {
                return this.elements;
            }
            return new UnmodifiableSetImpl<E>(){

                @Override
                public boolean contains(Object o) {
                    int tablePos = elements.elementToIndex(o);
                    if (tablePos == -1) {
                        return false;
                    }
                    return !checked[tablePos];
                }

                @Override
                public Iterator<E> iterator() {
                    final int tableSize = elements.size();
                    return new Iterator<E>(){
                        private int pos = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.pos != -1;
                        }

                        @Override
                        public E next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object element = elements.indexToElement(this.pos);
                            this.pos = this.findNext(this.pos + 1);
                            return element;
                        }

                        int findNext(int start) {
                            for (int i = start; i < tableSize; ++i) {
                                if (checked[i]) continue;
                                return i;
                            }
                            return -1;
                        }
                    };
                }

                @Override
                public int size() {
                    return uncheckedCount;
                }
            };
        }

        @Override
        public Iterable<E> iterateCheckedElements() {
            if (this.isComplete()) {
                return this.elements;
            }
            if (this.isBlank()) {
                return IndexedImmutableSetImpl.empty();
            }
            return new Iterable<E>(){

                @Override
                public Iterator<E> iterator() {
                    final int tableSize = elements.size();
                    return new Iterator<E>(){
                        private int pos = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.pos != -1;
                        }

                        @Override
                        public E next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object element = elements.indexToElement(this.pos);
                            this.pos = this.findNext(this.pos + 1);
                            return element;
                        }

                        int findNext(int start) {
                            for (int i = start; i < tableSize; ++i) {
                                if (!checked[i]) continue;
                                return i;
                            }
                            return -1;
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<E> iterateUncheckedElements() {
            if (this.isComplete()) {
                return IndexedImmutableSetImpl.empty();
            }
            if (this.isBlank()) {
                return this.elements;
            }
            return new Iterable<E>(){

                @Override
                public Iterator<E> iterator() {
                    final int tableSize = elements.size();
                    return new Iterator<E>(){
                        private int pos = this.findNext(0);

                        @Override
                        public boolean hasNext() {
                            return this.pos != -1;
                        }

                        @Override
                        public E next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object element = elements.indexToElement(this.pos);
                            this.pos = this.findNext(this.pos + 1);
                            return element;
                        }

                        int findNext(int start) {
                            for (int i = start; i < tableSize; ++i) {
                                if (checked[i]) continue;
                                return i;
                            }
                            return -1;
                        }
                    };
                }
            };
        }
    }
}

