/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class EntityRoleFilter
extends AbstractMetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityRoleFilter.class);
    @Nonnull
    private List<QName> retainedRoles;
    private boolean removeRolelessEntityDescriptors;
    private boolean removeEmptyEntitiesDescriptors;
    @Nonnull
    private final QName extRoleDescriptor;

    public EntityRoleFilter(@Nullable @ParameterName(name="keptRoles") List<QName> keptRoles) {
        this.retainedRoles = keptRoles != null ? CollectionSupport.copyToList(keptRoles) : CollectionSupport.emptyList();
        this.removeRolelessEntityDescriptors = true;
        this.removeEmptyEntitiesDescriptors = true;
        this.extRoleDescriptor = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<QName> getRetainedRoles() {
        return this.retainedRoles;
    }

    public boolean getRemoveRolelessEntityDescriptors() {
        return this.removeRolelessEntityDescriptors;
    }

    public void setRemoveRolelessEntityDescriptors(boolean remove) {
        this.checkSetterPreconditions();
        this.removeRolelessEntityDescriptors = remove;
    }

    public boolean getRemoveEmptyEntitiesDescriptors() {
        return this.removeEmptyEntitiesDescriptors;
    }

    public void setRemoveEmptyEntitiesDescriptors(boolean remove) {
        this.checkSetterPreconditions();
        this.removeEmptyEntitiesDescriptors = remove;
    }

    @Override
    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) throws FilterException {
        List<EntitiesDescriptor> entitiesDescriptors;
        List<EntityDescriptor> entityDescriptors = descriptor.getEntityDescriptors();
        if (entityDescriptors != null && !entityDescriptors.isEmpty()) {
            ArrayList<EntityDescriptor> emptyEntityDescriptors = new ArrayList<EntityDescriptor>();
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                List<RoleDescriptor> entityRoles;
                assert (entityDescriptor != null);
                this.filterEntityDescriptor(entityDescriptor);
                if (!this.getRemoveRolelessEntityDescriptors() || entityDescriptor.getAffiliationDescriptor() != null || (entityRoles = entityDescriptor.getRoleDescriptors()) != null && !entityRoles.isEmpty()) continue;
                this.log.trace("Filtering out empty entity descriptor {} from entity group {}", (Object)entityDescriptor.getEntityID(), (Object)descriptor.getName());
                emptyEntityDescriptors.add(entityDescriptor);
            }
            entityDescriptors.removeAll(emptyEntityDescriptors);
        }
        if ((entitiesDescriptors = descriptor.getEntitiesDescriptors()) != null && !entitiesDescriptors.isEmpty()) {
            ArrayList<EntitiesDescriptor> emptyEntitiesDescriptors = new ArrayList<EntitiesDescriptor>();
            for (EntitiesDescriptor entitiesDescriptor : entitiesDescriptors) {
                assert (entitiesDescriptor != null);
                this.filterEntitiesDescriptor(entitiesDescriptor);
                if (!this.getRemoveEmptyEntitiesDescriptors() || entitiesDescriptor.getEntityDescriptors() != null && !entitiesDescriptor.getEntityDescriptors().isEmpty() || entitiesDescriptor.getEntitiesDescriptors() != null && !entitiesDescriptor.getEntitiesDescriptors().isEmpty()) continue;
                this.log.trace("Filtering out entity descriptor {} from entity group {}", (Object)entitiesDescriptor.getName(), (Object)descriptor.getName());
                emptyEntitiesDescriptors.add(entitiesDescriptor);
            }
            entitiesDescriptors.removeAll(emptyEntitiesDescriptors);
        }
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) throws FilterException {
        List<RoleDescriptor> roles = descriptor.getRoleDescriptors();
        if (roles != null && !roles.isEmpty()) {
            Iterator<RoleDescriptor> rolesItr = roles.iterator();
            while (rolesItr.hasNext()) {
                QName roleName = this.getRoleName(rolesItr.next());
                if (this.retainedRoles.contains(roleName)) continue;
                this.log.trace("Filtering out role {} from entity {}", (Object)roleName, (Object)descriptor.getEntityID());
                rolesItr.remove();
            }
        }
    }

    @Nonnull
    protected QName getRoleName(@Nonnull RoleDescriptor role) throws FilterException {
        QName roleName = role.getElementQName();
        if (this.extRoleDescriptor.equals(roleName) && (roleName = role.getSchemaType()) == null) {
            throw new FilterException("Role descriptor element was " + String.valueOf(this.extRoleDescriptor) + " but did not contain a schema type.  This is illegal.");
        }
        return roleName;
    }
}

