/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._helpers.bulk;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

class FnCondition {
    private final Lock lock;
    public final Condition condition;
    private final BooleanSupplier ready;
    private long invocations;
    private long contentions;

    FnCondition(Lock lock, BooleanSupplier ready) {
        this.lock = lock;
        this.condition = lock.newCondition();
        this.ready = ready;
    }

    public void whenReady(Runnable fn) {
        this.whenReadyIf(null, () -> {
            fn.run();
            return null;
        });
    }

    public <T> T whenReady(Supplier<T> fn) {
        return this.whenReadyIf(null, fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T whenReadyIf(BooleanSupplier canRun, Supplier<T> fn) {
        this.lock.lock();
        try {
            if (canRun != null && !canRun.getAsBoolean()) {
                T t = null;
                return t;
            }
            ++this.invocations;
            boolean firstLoop = true;
            while (!this.ready.getAsBoolean()) {
                if (firstLoop) {
                    ++this.contentions;
                    firstLoop = false;
                }
                this.condition.awaitUninterruptibly();
            }
            if (canRun != null && !canRun.getAsBoolean()) {
                T t = null;
                return t;
            }
            T t = fn.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalIfReady() {
        this.lock.lock();
        try {
            if (this.ready.getAsBoolean()) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalAllIfReady() {
        this.lock.lock();
        try {
            if (this.ready.getAsBoolean()) {
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signalIfReadyAfter(Runnable r) {
        this.lock.lock();
        try {
            r.run();
            if (this.ready.getAsBoolean()) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long invocations() {
        return this.invocations;
    }

    public long contentions() {
        return this.contentions;
    }
}

