/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class HMacOutput {
    private final ByteBuffer digest;

    protected HMacOutput(BuilderImpl builder) {
        this.digest = builder.digest();
    }

    public ByteBuffer digest() {
        return this.digest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer digest;

        protected BuilderImpl() {
        }

        protected BuilderImpl(HMacOutput model) {
            this.digest = model.digest();
        }

        @Override
        public Builder digest(ByteBuffer digest) {
            this.digest = digest;
            return this;
        }

        @Override
        public ByteBuffer digest() {
            return this.digest;
        }

        @Override
        public HMacOutput build() {
            if (Objects.isNull(this.digest())) {
                throw new IllegalArgumentException("Missing value for required field `digest`");
            }
            return new HMacOutput(this);
        }
    }

    public static interface Builder {
        public Builder digest(ByteBuffer var1);

        public ByteBuffer digest();

        public HMacOutput build();
    }
}

