/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.transport;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.core.transport.DestinationTransport;
import org.opensearch.notifications.core.transport.SesDestinationTransport;
import org.opensearch.notifications.core.transport.SmtpDestinationTransport;
import org.opensearch.notifications.core.transport.SnsDestinationTransport;
import org.opensearch.notifications.core.transport.WebhookDestinationTransport;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.spi.model.destination.BaseDestination;
import org.opensearch.notifications.spi.model.destination.DestinationType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0017\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/notifications/core/transport/DestinationTransportProvider;", "", "<init>", "()V", "webhookDestinationTransport", "Lorg/opensearch/notifications/core/transport/WebhookDestinationTransport;", "smtpDestinationTransport", "Lorg/opensearch/notifications/core/transport/SmtpDestinationTransport;", "snsDestinationTransport", "Lorg/opensearch/notifications/core/transport/SnsDestinationTransport;", "sesDestinationTransport", "Lorg/opensearch/notifications/core/transport/SesDestinationTransport;", "destinationTransportMap", "", "Lorg/opensearch/notifications/spi/model/destination/DestinationType;", "Lorg/opensearch/notifications/core/transport/DestinationTransport;", "Lorg/opensearch/notifications/spi/model/destination/BaseDestination;", "getDestinationTransportMap$annotations", "getDestinationTransportMap", "()Ljava/util/Map;", "setDestinationTransportMap", "(Ljava/util/Map;)V", "getTransport", "destinationType", "opensearch-notifications-core"})
public final class DestinationTransportProvider {
    @NotNull
    public static final DestinationTransportProvider INSTANCE = new DestinationTransportProvider();
    @NotNull
    private static final WebhookDestinationTransport webhookDestinationTransport = new WebhookDestinationTransport();
    @NotNull
    private static final SmtpDestinationTransport smtpDestinationTransport = new SmtpDestinationTransport();
    @NotNull
    private static final SnsDestinationTransport snsDestinationTransport = new SnsDestinationTransport();
    @NotNull
    private static final SesDestinationTransport sesDestinationTransport = new SesDestinationTransport();
    @NotNull
    private static Map<DestinationType, ? extends DestinationTransport<? extends BaseDestination>> destinationTransportMap;

    private DestinationTransportProvider() {
    }

    @NotNull
    public final Map<DestinationType, DestinationTransport<? extends BaseDestination>> getDestinationTransportMap() {
        return destinationTransportMap;
    }

    public final void setDestinationTransportMap(@NotNull Map<DestinationType, ? extends DestinationTransport<? extends BaseDestination>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        destinationTransportMap = map;
    }

    @OpenForTesting
    public static /* synthetic */ void getDestinationTransportMap$annotations() {
    }

    @NotNull
    public final DestinationTransport<BaseDestination> getTransport(@NotNull DestinationType destinationType) {
        Intrinsics.checkNotNullParameter((Object)destinationType, (String)"destinationType");
        DestinationTransport<BaseDestination> destinationTransport = destinationTransportMap.get(destinationType);
        if (destinationTransport == null) {
            throw new IllegalArgumentException("Invalid channel type");
        }
        DestinationTransport<BaseDestination> retVal = destinationTransport;
        return retVal;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DestinationType.SLACK, (Object)webhookDestinationTransport), TuplesKt.to((Object)DestinationType.CHIME, (Object)webhookDestinationTransport), TuplesKt.to((Object)DestinationType.MICROSOFT_TEAMS, (Object)webhookDestinationTransport), TuplesKt.to((Object)DestinationType.CUSTOM_WEBHOOK, (Object)webhookDestinationTransport), TuplesKt.to((Object)DestinationType.SMTP, (Object)smtpDestinationTransport), TuplesKt.to((Object)DestinationType.SNS, (Object)snsDestinationTransport), TuplesKt.to((Object)DestinationType.SES, (Object)sesDestinationTransport)};
        destinationTransportMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

