/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.transport.TransportChannel;

public interface Predictable {
    public static final String METHOD_NOT_IMPLEMENTED_ERROR_MSG = "Method is not implemented";

    public MLOutput predict(MLInput var1, MLModel var2);

    default public MLOutput predict(MLInput mlInput) {
        throw new IllegalStateException(METHOD_NOT_IMPLEMENTED_ERROR_MSG);
    }

    default public void asyncPredict(MLInput mlInput, ActionListener<MLTaskResponse> actionListener) {
        this.asyncPredict(mlInput, actionListener, null);
    }

    default public void asyncPredict(MLInput mlInput, ActionListener<MLTaskResponse> actionListener, TransportChannel channel) {
        actionListener.onFailure((Exception)new IllegalStateException(METHOD_NOT_IMPLEMENTED_ERROR_MSG));
    }

    default public void initModel(MLModel model, Map<String, Object> params, Encryptor encryptor) {
        throw new IllegalStateException(METHOD_NOT_IMPLEMENTED_ERROR_MSG);
    }

    default public CompletionStage<Boolean> initModelAsync(MLModel model, Map<String, Object> params, Encryptor encryptor) {
        throw new IllegalStateException(METHOD_NOT_IMPLEMENTED_ERROR_MSG);
    }

    public void close();

    public boolean isModelReady();
}

