/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.logging.Logger;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.text.DocumentPreprocessor;
import org.tribuo.data.text.TextFeatureExtractor;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;

public class DirectoryFileSource<T extends Output<T>>
implements ConfigurableDataSource<T> {
    private static final Logger logger = Logger.getLogger(DirectoryFileSource.class.getName());
    private static final Charset enc = StandardCharsets.UTF_8;
    @Config(description="The top-level directory containing the data set.")
    private Path dataDir = Paths.get(".", new String[0]);
    @Config(description="The preprocessors to apply to the input documents.")
    protected List<DocumentPreprocessor> preprocessors = new ArrayList<DocumentPreprocessor>();
    @Config(mandatory=true, description="The output factory to use.")
    protected OutputFactory<T> outputFactory;
    @Config(mandatory=true, description="The feature extractor that converts text into examples.")
    protected TextFeatureExtractor<T> extractor;

    protected DirectoryFileSource() {
    }

    public DirectoryFileSource(Path dataDir, OutputFactory<T> outputFactory, TextFeatureExtractor<T> extractor, DocumentPreprocessor ... preprocessors) {
        this.dataDir = dataDir;
        this.outputFactory = outputFactory;
        this.extractor = extractor;
        this.preprocessors.addAll(Arrays.asList(preprocessors));
    }

    public String toString() {
        return "DirectoryDataSource(directory=" + this.dataDir.toString() + ",extractor=" + this.extractor.toString() + ",preprocessors=" + this.preprocessors.toString() + ")";
    }

    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    public Iterator<Example<T>> iterator() {
        return new DirectoryIterator();
    }

    public ConfiguredDataSourceProvenance getProvenance() {
        return new DirectoryFileSourceProvenance(this);
    }

    public static class DirectoryFileSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance fileModifiedTime;
        private final DateTimeProvenance dataSourceCreationTime;

        <T extends Output<T>> DirectoryFileSourceProvenance(DirectoryFileSource<T> host) {
            super(host, "DataSource");
            this.fileModifiedTime = new DateTimeProvenance("file-modified-time", OffsetDateTime.ofInstant(Instant.ofEpochMilli(((DirectoryFileSource)host).dataDir.toFile().lastModified()), ZoneId.systemDefault()));
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
        }

        public DirectoryFileSourceProvenance(Map<String, Provenance> map) {
            this(DirectoryFileSourceProvenance.extractProvenanceInfo(map));
        }

        private DirectoryFileSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.fileModifiedTime = (DateTimeProvenance)info.instanceValues.get("file-modified-time");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)DirectoryFileSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)DirectoryFileSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, Provenance> instanceParameters = new HashMap<String, Provenance>();
            instanceParameters.put("datasource-creation-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)DirectoryFileSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            HashMap map = new HashMap();
            map.put("file-modified-time", (PrimitiveProvenance<?>)this.fileModifiedTime);
            map.put("datasource-creation-time", (PrimitiveProvenance<?>)this.dataSourceCreationTime);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DirectoryFileSourceProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DirectoryFileSourceProvenance pairs = (DirectoryFileSourceProvenance)((Object)o);
            return this.fileModifiedTime.equals((Object)pairs.fileModifiedTime) && this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fileModifiedTime, this.dataSourceCreationTime);
        }
    }

    private class DirectoryIterator
    implements Iterator<Example<T>> {
        private final Queue<Path> labelDirs = new ArrayDeque<Path>();
        private Path labelPath;
        private String label;
        private final Queue<Path> labelPaths = new ArrayDeque<Path>();
        private final StringBuilder db = new StringBuilder();

        public DirectoryIterator() {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(DirectoryFileSource.this.dataDir);){
                for (Path entry : stream) {
                    this.labelDirs.offer(entry);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Can't open directory " + DirectoryFileSource.this.dataDir, ex);
            }
            logger.info(String.format("Got %d output directories in %s", this.labelDirs.size(), DirectoryFileSource.this.dataDir));
        }

        @Override
        public boolean hasNext() {
            if (this.labelPaths.isEmpty()) {
                return !this.labelDirs.isEmpty();
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Example<T> next() {
            if (this.labelPaths.isEmpty()) {
                if (this.labelDirs.isEmpty()) {
                    throw new NoSuchElementException("No more files");
                }
                this.labelPath = this.labelDirs.poll();
                this.label = this.labelPath.getFileName().toString();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.labelPath);){
                    for (Path entry : stream) {
                        this.labelPaths.offer(entry);
                    }
                    logger.info(String.format("Got %d paths in %s", this.labelPaths.size(), this.labelPath));
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Can't open directory " + this.labelPath, ex);
                }
            }
            Path p = this.labelPaths.poll();
            this.db.delete(0, this.db.length());
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(p.toFile()), enc));
                Object object = null;
                try {
                    DocumentPreprocessor preproc;
                    String line;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) {
                            this.db.append('\n');
                        } else {
                            this.db.append(line);
                        }
                        this.db.append('\n');
                    }
                    String postproc = this.db.toString();
                    Iterator<DocumentPreprocessor> iterator = DirectoryFileSource.this.preprocessors.iterator();
                    while (iterator.hasNext() && (postproc = (preproc = iterator.next()).processDoc(postproc)) != null) {
                    }
                    if (postproc != null) {
                        Example<Output> ret;
                        Example<Output> example = ret = DirectoryFileSource.this.extractor.extract(DirectoryFileSource.this.outputFactory.generateOutput((Object)this.label), postproc);
                        return example;
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("No more files");
                    }
                    iterator = this.next();
                    return iterator;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        if (object != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Error reading path " + p, ex);
            }
        }
    }
}

