/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Util {
    private static final boolean TRACKING_OBJECTS = false;
    private static String mainClassName = null;
    private static long maxMemoryUsed = 0L;
    private static final String OLCUT_DIR = "OLCUT_HOME";

    public static void objectTracker(String name, int count) {
    }

    public static String dumpMemoryInfo(String msg) {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        rt.gc();
        long reclaimedMemory = (rt.freeMemory() - free) / 0x100000L;
        long freeMemory = rt.freeMemory() / 0x100000L;
        long totalMemory = rt.totalMemory() / 0x100000L;
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        if (usedMemory > maxMemoryUsed) {
            maxMemoryUsed = usedMemory;
        }
        return "Memory (mb)  total: " + totalMemory + " reclaimed: " + reclaimedMemory + " free: " + freeMemory + " Max Used: " + maxMemoryUsed / 0x100000L + " -- " + msg;
    }

    public static String doubleToScientificString(double number, int fractionDigits) {
        DecimalFormat format = new DecimalFormat();
        StringBuilder buffer = new StringBuilder();
        buffer.append("0.");
        for (int i = 0; i < fractionDigits; ++i) {
            buffer.append("0");
        }
        buffer.append("E00");
        String formatter = buffer.toString();
        format.applyPattern(formatter);
        String formatted = format.format(number);
        int index = formatted.indexOf(69);
        if (formatted.charAt(index + 1) != '-') {
            return formatted.substring(0, index + 1) + "+" + formatted.substring(index + 1);
        }
        return formatted;
    }

    public static boolean doubleEquals(double x, double y, double epsilon) {
        return Math.abs(x - y) <= Math.max(x, y) * epsilon;
    }

    public static boolean doubleEquals(double x, double y) {
        return Util.doubleEquals(x, y, Math.ulp(1.0));
    }

    public static <T> boolean bagEquality(Collection<T> as, Collection<T> bs) {
        Map aCounts = as.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map bCounts = bs.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return aCounts.equals(bCounts);
    }

    public static float readLittleEndianFloat(DataInputStream dataStream) throws IOException {
        return Float.intBitsToFloat(Util.readLittleEndianInt(dataStream));
    }

    public static int readLittleEndianInt(DataInputStream dataStream) throws IOException {
        int bits = 0;
        for (int shift = 0; shift < 32; shift += 8) {
            int byteRead = 0xFF & dataStream.readByte();
            bits |= byteRead << shift;
        }
        return bits;
    }

    public static int swapInteger(int integer) {
        return (0xFF & integer) << 24 | (0xFF00 & integer) << 8 | (0xFF0000 & integer) >> 8 | (0xFF000000 & integer) >> 24;
    }

    public static float swapFloat(float floatValue) {
        return Float.intBitsToFloat(Util.swapInteger(Float.floatToRawIntBits(floatValue)));
    }

    public static String getMainClassName() {
        if (mainClassName != null) {
            return mainClassName;
        }
        Collection<StackTraceElement[]> stacks = Thread.getAllStackTraces().values();
        for (StackTraceElement[] stack : stacks) {
            StackTraceElement last;
            if (stack.length == 0 || !(last = stack[stack.length - 1]).getMethodName().equals("main")) continue;
            String name = last.getClassName();
            String[] comps = name.split("\\.");
            mainClassName = comps[comps.length - 1];
        }
        if (mainClassName == null) {
            mainClassName = "";
        }
        return mainClassName;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static Path getOlcutRoot() {
        return Optional.ofNullable(System.getenv(OLCUT_DIR)).map(x$0 -> Paths.get(x$0, new String[0])).orElse(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".olcut"));
    }
}

