/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.yasson.internal.InstanceCreator;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;

class CollectionDeserializer<T extends Collection<?>>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    private final Type collectionValueType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[0]) : Object.class;
    private T instance;

    protected CollectionDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.instance = this.createInstance(builder);
    }

    private T createInstance(DeserializerBuilder builder) {
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        if (rawType.isInterface()) {
            T x = this.createInterfaceInstance(rawType);
            if (x != null) {
                return x;
            }
        } else if (EnumSet.class.isAssignableFrom(rawType)) {
            return (T)EnumSet.noneOf((Class)this.collectionValueType);
        }
        builder.getJsonbContext().getInstanceCreator();
        return (T)((Collection)InstanceCreator.createInstance(rawType));
    }

    private T createInterfaceInstance(Class<?> ifcType) {
        if (List.class.isAssignableFrom(ifcType)) {
            if (LinkedList.class == ifcType) {
                return (T)new LinkedList();
            }
            return (T)new ArrayList();
        }
        if (Set.class.isAssignableFrom(ifcType)) {
            if (SortedSet.class.isAssignableFrom(ifcType)) {
                return (T)new TreeSet();
            }
            return (T)new HashSet();
        }
        if (Queue.class.isAssignableFrom(ifcType)) {
            return (T)new ArrayDeque();
        }
        if (Collection.class == ifcType) {
            return (T)new ArrayList();
        }
        return null;
    }

    @Override
    public T getInstance(Unmarshaller unmarshaller) {
        return this.instance;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.convertNullToOptionalEmpty(this.collectionValueType, result));
    }

    private <T> void appendCaptor(T object) {
        this.instance.add(object);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = this.newCollectionOrMapItem(this.collectionValueType, context.getJsonbContext());
        this.appendResult(deserializer.deserialize(parser, (DeserializationContext)context, this.collectionValueType));
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_ARRAY);
        return parser.getCurrentLevel();
    }
}

