/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingestion;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingestion.ResetMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ResetSettings
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResetSettings> {
    @Nonnull
    private final ResetMode mode;
    private final int shard;
    @Nonnull
    private final String value;
    public static final JsonpDeserializer<ResetSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResetSettings::setupResetSettingsDeserializer);

    private ResetSettings(Builder builder) {
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, this, "shard");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static ResetSettings of(Function<Builder, ObjectBuilder<ResetSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final ResetMode mode() {
        return this.mode;
    }

    public final int shard() {
        return this.shard;
    }

    @Nonnull
    public final String value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("shard");
        generator.write(this.shard);
        generator.writeKey("value");
        generator.write(this.value);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResetSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, ResetMode._DESERIALIZER, "mode");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + Integer.hashCode(this.shard);
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResetSettings other = (ResetSettings)o;
        return this.mode.equals(other.mode) && this.shard == other.shard && this.value.equals(other.value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ResetSettings> {
        private ResetMode mode;
        private Integer shard;
        private String value;

        public Builder() {
        }

        private Builder(ResetSettings o) {
            this.mode = o.mode;
            this.shard = o.shard;
            this.value = o.value;
        }

        private Builder(Builder o) {
            this.mode = o.mode;
            this.shard = o.shard;
            this.value = o.value;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder mode(ResetMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        @Nonnull
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        @Nonnull
        public ResetSettings build() {
            this._checkSingleUse();
            return new ResetSettings(this);
        }
    }
}

