/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public abstract class SubjectCredentialManagerCacheAdapter
extends UserCredentialManager {
    public SubjectCredentialManagerCacheAdapter(KeycloakSession session, RealmModel realm, UserModel user) {
        super(session, realm, user);
    }

    public abstract void invalidateCacheForEntity();

    public boolean updateCredential(CredentialInput input) {
        this.invalidateCacheForEntity();
        return super.updateCredential(input);
    }

    public void updateStoredCredential(CredentialModel cred) {
        this.invalidateCacheForEntity();
        super.updateStoredCredential(cred);
    }

    public CredentialModel createStoredCredential(CredentialModel cred) {
        this.invalidateCacheForEntity();
        return super.createStoredCredential(cred);
    }

    public boolean removeStoredCredentialById(String id) {
        this.invalidateCacheForEntity();
        return super.removeStoredCredentialById(id);
    }

    public boolean moveStoredCredentialTo(String id, String newPreviousCredentialId) {
        this.invalidateCacheForEntity();
        return super.moveStoredCredentialTo(id, newPreviousCredentialId);
    }

    public void updateCredentialLabel(String credentialId, String userLabel) {
        this.invalidateCacheForEntity();
        super.updateCredentialLabel(credentialId, userLabel);
    }

    public void disableCredentialType(String credentialType) {
        this.invalidateCacheForEntity();
        super.disableCredentialType(credentialType);
    }

    public CredentialModel createCredentialThroughProvider(CredentialModel model) {
        this.invalidateCacheForEntity();
        return super.createCredentialThroughProvider(model);
    }
}

