/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import org.infinispan.configuration.global.JGroupsConfiguration;
import org.infinispan.remoting.transport.jgroups.AbstractJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.NamedSocketFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteNamedCache;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.protocols.JDBC_PING;
import org.jgroups.protocols.JDBC_PING2;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;

public class EmbeddedJGroupsChannelConfigurator
extends AbstractJGroupsChannelConfigurator {
    private final String name;
    private final String parent;
    private JGroupsConfiguration jgroupsConfiguration;
    private final List<ProtocolConfiguration> stack;
    private final RemoteSites remoteSites;
    @GuardedBy(value="this")
    private List<ProtocolConfiguration> combinedStack;

    public EmbeddedJGroupsChannelConfigurator(String name, List<ProtocolConfiguration> stack, RemoteSites remoteSites) {
        this(name, stack, remoteSites, null);
    }

    public EmbeddedJGroupsChannelConfigurator(String name, List<ProtocolConfiguration> stack, RemoteSites remoteSites, String parent) {
        this.name = name;
        this.stack = stack;
        this.remoteSites = remoteSites;
        this.parent = parent;
    }

    public void setConfiguration(JGroupsConfiguration configuration) {
        this.jgroupsConfiguration = configuration;
    }

    public String getProtocolStackString() {
        return this.getProtocolStack().toString();
    }

    public synchronized List<ProtocolConfiguration> getProtocolStack() {
        if (this.combinedStack == null) {
            this.combinedStack = EmbeddedJGroupsChannelConfigurator.combineStack(this.jgroupsConfiguration.configurator(this.parent), this.stack);
        }
        return this.combinedStack;
    }

    public List<ProtocolConfiguration> getUncombinedProtocolStack() {
        return this.stack;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JChannel createChannel(String name) throws Exception {
        if (this.hasSites() && this.getProtocolStack().stream().noneMatch(EmbeddedJGroupsChannelConfigurator::isRelay2)) {
            throw Log.CONFIG.jgroupsRemoteSitesWithoutRelay(name);
        }
        return this.amendChannel(new JChannel((ProtocolStackConfigurator)this));
    }

    public void afterCreation(Protocol protocol) {
        if (protocol instanceof RELAY2) {
            RELAY2 relay = (RELAY2)protocol;
            this.setupRELAY2(relay);
        } else if (protocol instanceof JDBC_PING) {
            JDBC_PING jdbc_ping = (JDBC_PING)protocol;
            this.setupJDBC_PING(jdbc_ping);
        } else if (protocol instanceof JDBC_PING2) {
            JDBC_PING2 jdbc_ping = (JDBC_PING2)protocol;
            this.setupJDBC_PING2(jdbc_ping);
        }
    }

    private void setupJDBC_PING(JDBC_PING jdbc_ping) {
        if (this.dataSource != null) {
            jdbc_ping.setDataSource(this.dataSource);
        }
    }

    private void setupJDBC_PING2(JDBC_PING2 jdbc_ping) {
        if (this.dataSource != null) {
            jdbc_ping.setDataSource(this.dataSource);
        }
    }

    private void setupRELAY2(RELAY2 relay2) {
        RemoteSites actualSites = this.getRemoteSites();
        if (actualSites.remoteSites.isEmpty()) {
            throw Log.CONFIG.jgroupsRelayWithoutRemoteSites(this.name);
        }
        for (Map.Entry<String, RemoteSite> remoteSite : actualSites.remoteSites.entrySet()) {
            final JGroupsChannelConfigurator configurator = this.jgroupsConfiguration.configurator(remoteSite.getValue().stack);
            SocketFactory socketFactory = this.getSocketFactory();
            String remoteCluster = remoteSite.getValue().cluster;
            if (remoteCluster == null) {
                remoteCluster = actualSites.defaultCluster;
            }
            if (socketFactory instanceof NamedSocketFactory) {
                socketFactory = new NamedSocketFactory((NamedSocketFactory)socketFactory, remoteCluster);
            }
            configurator.setSocketFactory(socketFactory);
            for (ChannelListener listener : this.channelListeners) {
                configurator.addChannelListener(listener);
            }
            RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(remoteSite.getKey());
            siteConfig.addBridge(new RelayConfig.BridgeConfig(this, remoteCluster){
                final /* synthetic */ EmbeddedJGroupsChannelConfigurator this$0;
                {
                    this.this$0 = this$0;
                    super(cluster_name);
                }

                public JChannel createChannel() throws Exception {
                    return configurator.createChannel(this.getClusterName());
                }
            });
            relay2.addSite(remoteSite.getKey(), siteConfig);
        }
    }

    private static List<ProtocolConfiguration> combineStack(JGroupsChannelConfigurator baseStack, List<ProtocolConfiguration> stack) {
        ArrayList<Object> actualStack = null;
        if (baseStack != null) {
            List combinedBaseStack = baseStack.getProtocolStack();
            actualStack = new ArrayList(combinedBaseStack.size() + stack.size());
            for (ProtocolConfiguration originalProtocol : combinedBaseStack) {
                ProtocolConfiguration protocol = new ProtocolConfiguration(originalProtocol.getProtocolName(), new HashMap(originalProtocol.getProperties()));
                actualStack.add(protocol);
            }
        }
        if (actualStack == null) {
            actualStack = new ArrayList<ProtocolConfiguration>(stack.size());
        }
        for (ProtocolConfiguration protocol : stack) {
            String protocolName = protocol.getProtocolName();
            int position = EmbeddedJGroupsChannelConfigurator.findProtocol(protocolName, actualStack);
            StackCombine mode = position < 0 ? StackCombine.APPEND : StackCombine.COMBINE;
            String stackCombine = (String)protocol.getProperties().remove("stack.combine");
            if (stackCombine != null) {
                mode = StackCombine.valueOf(stackCombine);
            }
            String stackPosition = (String)protocol.getProperties().remove("stack.position");
            switch (mode.ordinal()) {
                case 7: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    actualStack.add(protocol);
                    break;
                }
                case 0: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    ((ProtocolConfiguration)actualStack.get(position)).getProperties().putAll(protocol.getProperties());
                    break;
                }
                case 6: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    actualStack.remove(position);
                    break;
                }
                case 5: {
                    if (stackPosition != null) {
                        position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                        EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    } else {
                        EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    }
                    actualStack.set(position, protocol);
                    break;
                }
                case 3: 
                case 4: {
                    if (stackPosition == null) {
                        throw Log.CONFIG.jgroupsInsertRequiresPosition(protocolName);
                    }
                    position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    actualStack.add(position, protocol);
                    break;
                }
                case 1: 
                case 2: {
                    if (stackPosition == null) {
                        throw Log.CONFIG.jgroupsInsertRequiresPosition(protocolName);
                    }
                    position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    actualStack.add(position + 1, protocol);
                }
            }
        }
        return actualStack;
    }

    private void combineSites(Map<String, RemoteSite> sites) {
        JGroupsChannelConfigurator parentConfigurator = this.jgroupsConfiguration.configurator(this.parent);
        if (parentConfigurator instanceof EmbeddedJGroupsChannelConfigurator) {
            ((EmbeddedJGroupsChannelConfigurator)parentConfigurator).combineSites(sites);
        }
        if (this.remoteSites != null) {
            sites.putAll(this.remoteSites.remoteSites);
        }
    }

    private boolean hasSites() {
        if (this.remoteSites != null && !this.remoteSites.remoteSites.isEmpty()) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        HashMap<String, RemoteSite> sites = new HashMap<String, RemoteSite>(4);
        JGroupsChannelConfigurator parentConfigurator = this.jgroupsConfiguration.configurator(this.parent);
        if (parentConfigurator instanceof EmbeddedJGroupsChannelConfigurator) {
            ((EmbeddedJGroupsChannelConfigurator)parentConfigurator).combineSites(sites);
        }
        return !sites.isEmpty();
    }

    private static void assertNoStackPosition(StackCombine mode, String stackAfter) {
        if (stackAfter != null) {
            throw Log.CONFIG.jgroupsNoStackPosition(mode.name());
        }
    }

    private static void assertExisting(StackCombine mode, String protocolName, int position) {
        if (position < 0) {
            throw Log.CONFIG.jgroupsNoSuchProtocol(protocolName, mode.name());
        }
    }

    private static int findProtocol(String protocol, List<ProtocolConfiguration> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!protocol.equals(stack.get(i).getProtocolName())) continue;
            return i;
        }
        return -1;
    }

    public RemoteSites getRemoteSites() {
        RemoteSites combinedSites = new RemoteSites(this.remoteSites.defaultStack, this.remoteSites.defaultCluster);
        this.combineSites(combinedSites.remoteSites);
        return combinedSites;
    }

    public RemoteSites getUncombinedRemoteSites() {
        return this.remoteSites;
    }

    public String toString() {
        return "EmbeddedJGroupsChannelConfigurator{name='" + this.name + "', parent='" + this.parent + "', stack=" + String.valueOf(this.stack) + ", remoteSites=" + String.valueOf(this.remoteSites) + "}";
    }

    private static boolean isRelay2(ProtocolConfiguration configuration) {
        try {
            return configuration.isAssignableProtocol(RELAY2.class, EmbeddedJGroupsChannelConfigurator.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class RemoteSites {
        final String defaultCluster;
        final String defaultStack;
        final Map<String, RemoteSite> remoteSites;

        public RemoteSites(String defaultStack, String defaultCluster) {
            this.defaultStack = defaultStack;
            this.defaultCluster = defaultCluster;
            this.remoteSites = new LinkedHashMap<String, RemoteSite>(4);
        }

        public String getDefaultCluster() {
            return this.defaultCluster;
        }

        public String getDefaultStack() {
            return this.defaultStack;
        }

        public Map<String, RemoteSite> getRemoteSites() {
            return this.remoteSites;
        }

        public void addRemoteSite(String stackName, String remoteSite, String cluster, String stack) {
            if (this.remoteSites.containsKey(remoteSite = XSiteNamedCache.cachedString(remoteSite))) {
                throw Log.CONFIG.duplicateRemoteSite(remoteSite, stackName);
            }
            this.remoteSites.put(remoteSite, new RemoteSite(cluster, stack));
        }

        public String toString() {
            return "RemoteSites{defaultCluster='" + this.defaultCluster + "', defaultStack='" + this.defaultStack + "', remoteSites=" + String.valueOf(this.remoteSites) + "}";
        }
    }

    public static class RemoteSite {
        final String cluster;
        final String stack;

        RemoteSite(String cluster, String stack) {
            this.cluster = cluster;
            this.stack = stack;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getStack() {
            return this.stack;
        }

        public String toString() {
            return "RemoteSite{cluster='" + this.cluster + "', stack='" + this.stack + "'}";
        }
    }

    public static enum StackCombine {
        COMBINE,
        INSERT_AFTER,
        INSERT_ABOVE,
        INSERT_BEFORE,
        INSERT_BELOW,
        REPLACE,
        REMOVE,
        APPEND;

    }
}

