/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Topology;

public interface Platform {
    public String name();

    public Node curNode();

    public Topology topology();

    public Scheduler scheduler();

    public String runCommand(String[] var1) throws IOException;

    public static class Config {
        public static final String TROGDOR_AGENT_PORT = "trogdor.agent.port";
        public static final String TROGDOR_COORDINATOR_PORT = "trogdor.coordinator.port";
        public static final String TROGDOR_COORDINATOR_HEARTBEAT_MS = "trogdor.coordinator.heartbeat.ms";
        public static final int TROGDOR_COORDINATOR_HEARTBEAT_MS_DEFAULT = 60000;

        public static Platform parse(String curNodeName, String path) throws Exception {
            JsonNode root = JsonUtil.JSON_SERDE.readTree(new File(path));
            JsonNode platformNode = root.get("platform");
            if (platformNode == null) {
                throw new RuntimeException("Expected to find a 'platform' field in the root JSON configuration object");
            }
            String platformName = platformNode.textValue();
            return (Platform)Utils.newParameterizedInstance((String)platformName, (Object[])new Object[]{String.class, curNodeName, Scheduler.class, Scheduler.SYSTEM, JsonNode.class, root});
        }
    }
}

