/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class MsmsReader
extends PmeshReader {
    private String fileName;

    MsmsReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PFR(sg, br);
        this.fileName = (String)((Object[])sg.getReaderData())[0];
        if (this.fileName == null) {
            return;
        }
        this.type = "msms";
        this.onePerLine = true;
        this.fixedCount = 3;
        this.vertexBase = 1;
        this.setHeader();
    }

    @Override
    protected boolean readVertices() throws Exception {
        this.skipHeader();
        return this.readVerticesPM();
    }

    @Override
    protected boolean readPolygons() throws Exception {
        this.br.close();
        this.fileName = PT.rep(this.fileName, ".vert", ".face");
        Logger.info("reading from file " + this.fileName);
        try {
            this.br = Rdr.getBufferedReader(this.sg.atomDataServer.getBufferedInputStream(this.fileName), null);
        }
        catch (Exception e) {
            Logger.info("Note: file " + this.fileName + " was not found");
            this.br = null;
            return true;
        }
        this.sg.addRequiredFile(this.fileName);
        this.skipHeader();
        return this.readPolygonsPM();
    }

    private void skipHeader() throws Exception {
        while (this.rd() != null && this.line.indexOf("#") >= 0) {
        }
        this.tokens = this.getTokens();
        this.iToken = 0;
    }
}

