/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import javajs.util.Lst;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.JSVTreePath;
import jspecview.api.ScriptInterface;
import jspecview.application.AwtTreeNode;
import jspecview.application.AwtTreePath;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.source.JDXSource;

public class AwtTree
extends JTree
implements JSVTree {
    private static final long serialVersionUID = 1L;
    protected ScriptInterface si;
    private JSVTreeNode rootNode;
    private DefaultTreeModel spectraTreeModel;
    protected JSViewer vwr;

    @Override
    public JSVTreeNode getRootNode() {
        return this.rootNode;
    }

    public AwtTree(JSViewer jSViewer) {
        final JSViewer jSViewer2 = this.vwr = jSViewer;
        this.rootNode = new AwtTreeNode("Spectra", null);
        this.spectraTreeModel = new DefaultTreeModel((TreeNode)((Object)this.rootNode));
        this.setModel(this.spectraTreeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                jSViewer2.selectedTreeNode((JSVTreeNode)AwtTree.this.getLastSelectedPathComponent());
            }
        });
        this.setRootVisible(false);
    }

    @Override
    public void setSelectedPanel(ScriptInterface scriptInterface, JSVPanel jSVPanel) {
        if (jSVPanel != null) {
            JSVTreeNode jSVTreeNode = PanelNode.findNode((JSVPanel)jSVPanel, this.vwr.panelNodes).treeNode;
            this.scrollPathToVisible((TreePath)((Object)this.vwr.spectraTree.newTreePath(jSVTreeNode.getPath())));
            this.setSelectionPath((TreePath)((Object)this.vwr.spectraTree.newTreePath(jSVTreeNode.getPath())));
        }
    }

    @Override
    public JSVTreeNode createTree(int n, JDXSource jDXSource, JSVPanel[] jSVPanelArray) {
        AwtTree awtTree = (AwtTree)this.vwr.spectraTree;
        JSVTreeNode jSVTreeNode = awtTree.getRootNode();
        Lst<PanelNode> lst = this.vwr.panelNodes;
        String string = JSVFileManager.getTagName(jDXSource.getFilePath());
        PanelNode panelNode = new PanelNode(null, string, jDXSource, null);
        AwtTreeNode awtTreeNode = new AwtTreeNode(string, panelNode);
        panelNode.setTreeNode(awtTreeNode);
        awtTree.spectraTreeModel.insertNodeInto(awtTreeNode, (MutableTreeNode)((Object)jSVTreeNode), jSVTreeNode.getChildCount());
        awtTree.scrollPathToVisible(new TreePath(awtTreeNode.getPath()));
        int n2 = 0;
        while (n2 < jSVPanelArray.length) {
            JSVPanel jSVPanel = jSVPanelArray[n2];
            String string2 = String.valueOf(n) + "." + (n2 + 1);
            panelNode = new PanelNode(string2, string, jDXSource, jSVPanel);
            AwtTreeNode awtTreeNode2 = new AwtTreeNode(panelNode.toString(), panelNode);
            panelNode.setTreeNode(awtTreeNode2);
            lst.addLast(panelNode);
            awtTree.spectraTreeModel.insertNodeInto(awtTreeNode2, awtTreeNode, awtTreeNode.getChildCount());
            awtTree.scrollPathToVisible(new TreePath(awtTreeNode2.getPath()));
            ++n2;
        }
        this.vwr.selectFrameNode(jSVPanelArray[0]);
        return awtTreeNode;
    }

    @Override
    public void setPath(JSVTreePath jSVTreePath) {
        this.setSelectionPath((TreePath)((Object)jSVTreePath));
    }

    @Override
    public JSVTreePath newTreePath(Object[] objectArray) {
        return new AwtTreePath(objectArray);
    }

    @Override
    public void deleteNodes(Lst<JSVTreeNode> lst) {
        int n = 0;
        while (n < lst.size()) {
            this.spectraTreeModel.removeNodeFromParent((MutableTreeNode)lst.get(n));
            ++n;
        }
    }
}

