/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.HierarchicalAwareSelectionColorLayer;
import com.intellij.database.datagrid.color.MarkupColorLayer;
import com.intellij.database.datagrid.color.MutationsColorLayer;
import com.intellij.database.datagrid.color.SearchSessionColorLayer;
import com.intellij.database.datagrid.color.SelectionColorLayer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridColorModelImpl
implements GridColorModel {
    private ColorLayer[] myLayers;
    private final DataGrid myGrid;

    public GridColorModelImpl(@NotNull DataGrid grid, @Nullable GridMutator.DatabaseMutator<GridRow, GridColumn> mutator, boolean transparentRowHeaderBg, boolean transparentColumnHeaderBg) {
        if (grid == null) {
            GridColorModelImpl.$$$reportNull$$$0(0);
        }
        this(grid, GridColorModelImpl.createLayers(grid, mutator, transparentRowHeaderBg, transparentColumnHeaderBg));
    }

    public GridColorModelImpl(@NotNull DataGrid grid, ColorLayer ... layers) {
        if (grid == null) {
            GridColorModelImpl.$$$reportNull$$$0(1);
        }
        if (layers == null) {
            GridColorModelImpl.$$$reportNull$$$0(2);
        }
        this.myGrid = grid;
        this.myLayers = layers;
        Arrays.sort(this.myLayers);
    }

    private static ColorLayer[] createLayers(@NotNull DataGrid grid, @Nullable GridMutator.DatabaseMutator<GridRow, GridColumn> mutator, boolean transparentRowHeaderBg, boolean transparentColumnHeaderBg) {
        if (grid == null) {
            GridColorModelImpl.$$$reportNull$$$0(3);
        }
        return (ColorLayer[])ContainerUtil.ar((Object[])new ColorLayer[]{new MarkupColorLayer(), new MutationsColorLayer(mutator), new HierarchicalAwareSelectionColorLayer(new SelectionColorLayer(grid, transparentRowHeaderBg, transparentColumnHeaderBg)), new SearchSessionColorLayer()});
    }

    @Nullable
    public ColorLayer getLayer(@NotNull Class<? extends ColorLayer> clazz) {
        if (clazz == null) {
            GridColorModelImpl.$$$reportNull$$$0(4);
        }
        return (ColorLayer)ContainerUtil.find((Object[])this.myLayers, layer -> layer.getClass().isAssignableFrom(clazz));
    }

    public void removeLayer(@NotNull Class<? extends ColorLayer> clazz) {
        if (clazz == null) {
            GridColorModelImpl.$$$reportNull$$$0(5);
        }
        List<ColorLayer> layers = Arrays.asList(this.myLayers);
        layers.removeIf(layer -> layer.getClass().isAssignableFrom(clazz));
        this.myLayers = (ColorLayer[])layers.toArray(ColorLayer[]::new);
    }

    public void removeLayer(@NotNull ColorLayer layer) {
        if (layer == null) {
            GridColorModelImpl.$$$reportNull$$$0(6);
        }
        List<ColorLayer> layers = Arrays.asList(this.myLayers);
        layers.remove(layer);
        this.myLayers = (ColorLayer[])layers.toArray(ColorLayer[]::new);
    }

    public void addLayer(@NotNull ColorLayer layer) {
        if (layer == null) {
            GridColorModelImpl.$$$reportNull$$$0(7);
        }
        ArrayList<ColorLayer> layers = new ArrayList<ColorLayer>(Arrays.asList(this.myLayers));
        layers.add(layer);
        this.myLayers = (ColorLayer[])layers.toArray(ColorLayer[]::new);
        Arrays.sort(this.myLayers);
    }

    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            GridColorModelImpl.$$$reportNull$$$0(8);
        }
        if (column == null) {
            GridColorModelImpl.$$$reportNull$$$0(9);
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getCellBackground(row, column, this.myGrid, color);
        }
        return color;
    }

    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            GridColorModelImpl.$$$reportNull$$$0(10);
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getRowHeaderBackground(row, this.myGrid, color);
        }
        return color;
    }

    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            GridColorModelImpl.$$$reportNull$$$0(11);
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getColumnHeaderBackground(column, this.myGrid, color);
        }
        return color;
    }

    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<GridColumn> column, int headerLine) {
        if (column == null) {
            GridColorModelImpl.$$$reportNull$$$0(12);
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getColumnHeaderBackground(column, headerLine, this.myGrid, color);
        }
        return color;
    }

    @NotNull
    public Color getRowHeaderForeground(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            GridColorModelImpl.$$$reportNull$$$0(13);
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getRowHeaderForeground(row, this.myGrid, color);
        }
        Color color2 = Objects.requireNonNull(color);
        if (color2 == null) {
            GridColorModelImpl.$$$reportNull$$$0(14);
        }
        return color2;
    }

    @NotNull
    public Color getColumnHeaderForeground(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            GridColorModelImpl.$$$reportNull$$$0(15);
        }
        Color color = null;
        for (ColorLayer layer : this.myLayers) {
            color = layer.getColumnHeaderForeground(column, this.myGrid, color);
        }
        Color color2 = Objects.requireNonNull(color);
        if (color2 == null) {
            GridColorModelImpl.$$$reportNull$$$0(16);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/color/GridColorModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/color/GridColorModelImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowHeaderForeground";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnHeaderForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLayers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLayer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeLayer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLayer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCellBackground";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderBackground";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderBackground";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRowHeaderForeground";
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getColumnHeaderForeground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16 -> new IllegalStateException(string);
        };
    }
}

