/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.blockingCallsDetection.AnnotationBasedBlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.AnnotationBasedNonBlockingContextChecker;
import com.intellij.codeInspection.blockingCallsDetection.BlockingCallInspectionSettings;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.ContextType;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.lang.Language;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public final class BlockingMethodInNonBlockingContextInspection
extends AbstractBaseUastLocalInspectionTool {
    public static final List<String> DEFAULT_BLOCKING_ANNOTATIONS = List.of("org.jetbrains.annotations.Blocking", "io.micronaut.core.annotation.Blocking", "io.smallrye.common.annotation.Blocking");
    public static final List<String> DEFAULT_NONBLOCKING_ANNOTATIONS = List.of("org.jetbrains.annotations.NonBlocking", "io.micronaut.core.annotation.NonBlocking", "io.smallrye.common.annotation.NonBlocking");
    public List<String> myBlockingAnnotations = new ArrayList<String>(DEFAULT_BLOCKING_ANNOTATIONS);
    public List<String> myNonBlockingAnnotations = new ArrayList<String>(DEFAULT_NONBLOCKING_ANNOTATIONS);
    public boolean myConsiderUnknownContextBlocking;
    public boolean myConsiderSuspendContextNonBlocking;
    private final Class<? extends UElement>[] hints = new Class[]{UMethod.class, UCallExpression.class};

    public BlockingMethodInNonBlockingContextInspection() {
        this.myConsiderUnknownContextBlocking = true;
        this.myConsiderSuspendContextNonBlocking = true;
    }

    public BlockingMethodInNonBlockingContextInspection(boolean considerUnknownContextBlocking, boolean considerSuspendContextNonBlocking) {
        this.myConsiderUnknownContextBlocking = considerUnknownContextBlocking;
        this.myConsiderSuspendContextNonBlocking = considerSuspendContextNonBlocking;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myConsiderUnknownContextBlocking", (String)JvmAnalysisBundle.message("jvm.inspections.blocking.method.consider.unknown.context.blocking", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myConsiderSuspendContextNonBlocking", (String)JvmAnalysisBundle.message("jvm.inspections.blocking.method.consider.suspend.context.non.blocking", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.stringList((String)"myBlockingAnnotations", (String)JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.blocking", new Object[0]), (StringValidator)new JavaClassValidator().withTitle(JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.configure.add.blocking.title", new Object[0])).annotationsOnly()), OptPane.stringList((String)"myNonBlockingAnnotations", (String)JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.non-blocking", new Object[0]), (StringValidator)new JavaClassValidator().withTitle(JvmAnalysisBundle.message("jvm.inspections.blocking.method.annotation.configure.add.non-blocking.title", new Object[0])).annotationsOnly())});
        if (optPane == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(1);
        }
        Collection<String> nonBlockingAnnotations = BlockingMethodInNonBlockingContextInspection.union(this.myNonBlockingAnnotations, DEFAULT_NONBLOCKING_ANNOTATIONS);
        Collection<String> blockingAnnotations = BlockingMethodInNonBlockingContextInspection.union(this.myBlockingAnnotations, DEFAULT_BLOCKING_ANNOTATIONS);
        List<NonBlockingContextChecker> nonBlockingContextCheckers = BlockingMethodInNonBlockingContextInspection.getNonBlockingContextCheckers(holder.getFile(), blockingAnnotations, nonBlockingAnnotations);
        if (nonBlockingContextCheckers.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        List<BlockingMethodChecker> blockingMethodCheckers = BlockingMethodInNonBlockingContextInspection.getBlockingMethodCheckers(holder.getFile(), blockingAnnotations, nonBlockingAnnotations);
        if (blockingMethodCheckers.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        final BlockingMethodInNonBlockingContextVisitor visitor2 = new BlockingMethodInNonBlockingContextVisitor(holder, blockingMethodCheckers, nonBlockingContextCheckers, this.getSettings());
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this){

            public boolean visitMethod(@NotNull UMethod node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                visitor2.visitMethod(node);
                return super.visitMethod(node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                visitor2.visitCall(node);
                return super.visitCallExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])this.hints);
        if (psiElementVisitor == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    public BlockingCallInspectionSettings getSettings() {
        return new BlockingCallInspectionSettings(this.myConsiderUnknownContextBlocking, this.myConsiderSuspendContextNonBlocking);
    }

    @NotNull
    private static List<NonBlockingContextChecker> getNonBlockingContextCheckers(@NotNull PsiFile file, @NotNull Collection<String> blockingAnnotations, @NotNull Collection<String> nonBlockingAnnotations) {
        if (file == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(5);
        }
        if (blockingAnnotations == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(6);
        }
        if (nonBlockingAnnotations == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(7);
        }
        ArrayList<NonBlockingContextChecker> nonBlockingContextCheckers = new ArrayList<NonBlockingContextChecker>(NonBlockingContextChecker.EP_NAME.getExtensionList());
        nonBlockingContextCheckers.add(new AnnotationBasedNonBlockingContextChecker(blockingAnnotations, nonBlockingAnnotations));
        nonBlockingContextCheckers.removeIf(checker -> !checker.isApplicable(file));
        ArrayList<NonBlockingContextChecker> arrayList = nonBlockingContextCheckers;
        if (arrayList == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<BlockingMethodChecker> getBlockingMethodCheckers(@NotNull PsiFile file, @NotNull Collection<String> blockingAnnotations, @NotNull Collection<String> nonBlockingAnnotations) {
        if (file == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(9);
        }
        if (blockingAnnotations == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(10);
        }
        if (nonBlockingAnnotations == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(11);
        }
        ArrayList<BlockingMethodChecker> blockingMethodCheckers = new ArrayList<BlockingMethodChecker>(BlockingMethodChecker.EP_NAME.getExtensionList());
        blockingMethodCheckers.add(new AnnotationBasedBlockingMethodChecker(blockingAnnotations, nonBlockingAnnotations));
        blockingMethodCheckers.removeIf(checker -> !checker.isApplicable(file));
        ArrayList<BlockingMethodChecker> arrayList = blockingMethodCheckers;
        if (arrayList == null) {
            BlockingMethodInNonBlockingContextInspection.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static Collection<String> union(Collection<String> annotations, Collection<String> defaultAnnotations) {
        HashSet<String> result = new HashSet<String>(defaultAnnotations);
        result.addAll(annotations != null ? annotations : Collections.emptyList());
        return result;
    }

    private static boolean isMethodOrSupersBlocking(PsiMethod referencedMethod, List<BlockingMethodChecker> checkers, BlockingCallInspectionSettings settings) {
        return StreamEx.of((Object)referencedMethod).append((Object[])referencedMethod.findDeepestSuperMethods()).anyMatch(method -> BlockingMethodInNonBlockingContextInspection.isMethodBlocking(referencedMethod, checkers, settings));
    }

    private static boolean isMethodBlocking(PsiMethod referencedMethod, List<BlockingMethodChecker> checkers, BlockingCallInspectionSettings settings) {
        for (BlockingMethodChecker extension : checkers) {
            ProgressManager.checkCanceled();
            MethodContext methodContext = new MethodContext(referencedMethod, extension, checkers, settings);
            if (!extension.isMethodBlocking(methodContext)) continue;
            return true;
        }
        return false;
    }

    private static ContextType isContextNonBlockingFor(PsiElement element, List<? extends NonBlockingContextChecker> nonBlockingContextCheckers, BlockingCallInspectionSettings settings) {
        ContextType.Unsure effectiveContextType = ContextType.Unsure.INSTANCE;
        ElementContext elementContext = new ElementContext(element, settings);
        for (NonBlockingContextChecker nonBlockingContextChecker : nonBlockingContextCheckers) {
            ProgressIndicatorProvider.checkCanceled();
            ContextType checkResult = nonBlockingContextChecker.computeContextType(elementContext);
            if (!((effectiveContextType = BlockingMethodInNonBlockingContextInspection.chooseType((ContextType)effectiveContextType, checkResult)) instanceof ContextType.NonBlocking)) continue;
            return effectiveContextType;
        }
        return effectiveContextType;
    }

    private static ContextType chooseType(ContextType first, ContextType second) {
        return first.getPriority() > second.getPriority() ? first : second;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 7, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockingAnnotations";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonBlockingAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonBlockingContextCheckers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockingMethodCheckers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNonBlockingContextCheckers";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBlockingMethodCheckers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6, 7, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private class BlockingMethodInNonBlockingContextVisitor {
        private final ProblemsHolder myHolder;
        private final List<BlockingMethodChecker> myBlockingMethodCheckers;
        private final List<NonBlockingContextChecker> myNonBlockingContextCheckers;
        private final BlockingCallInspectionSettings mySettings;

        BlockingMethodInNonBlockingContextVisitor(ProblemsHolder holder, List<BlockingMethodChecker> blockingMethodCheckers, List<NonBlockingContextChecker> nonBlockingContextCheckers, BlockingCallInspectionSettings settings) {
            if (holder == null) {
                BlockingMethodInNonBlockingContextVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myBlockingMethodCheckers = blockingMethodCheckers;
            this.myNonBlockingContextCheckers = nonBlockingContextCheckers;
            this.mySettings = settings;
        }

        public void visitCall(UCallExpression callExpression) {
            String message;
            if (callExpression == null) {
                return;
            }
            PsiElement element = callExpression.getSourcePsi();
            if (element == null) {
                return;
            }
            PsiElement elementToHighLight = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
            if (elementToHighLight == null) {
                return;
            }
            if (callExpression.getKind() == UastCallKind.CONSTRUCTOR_CALL && elementToHighLight.getTextRange().isEmpty()) {
                return;
            }
            ContextType contextType = BlockingMethodInNonBlockingContextInspection.isContextNonBlockingFor(element, this.myNonBlockingContextCheckers, this.mySettings);
            if (contextType instanceof ContextType.Blocking) {
                return;
            }
            ProgressIndicatorProvider.checkCanceled();
            PsiMethod referencedMethod = callExpression.resolve();
            if (referencedMethod == null) {
                return;
            }
            if (!BlockingMethodInNonBlockingContextInspection.isMethodOrSupersBlocking(referencedMethod, this.myBlockingMethodCheckers, this.mySettings)) {
                return;
            }
            if (contextType instanceof ContextType.Unsure && BlockingMethodInNonBlockingContextInspection.this.myConsiderUnknownContextBlocking) {
                if (this.myHolder.isOnTheFly()) {
                    this.myHolder.problem(elementToHighLight, JvmAnalysisBundle.message("jvm.inspections.blocking.method.consider.unknown.context.nonblocking", new Object[0])).highlight(ProblemHighlightType.INFORMATION).fix((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)BlockingMethodInNonBlockingContextInspection.this, "myConsiderUnknownContextBlocking", JvmAnalysisBundle.message("jvm.inspections.blocking.method.consider.unknown.context.nonblocking", new Object[0]), false)).register();
                }
                return;
            }
            ElementContext elementContext = new ElementContext(element, this.mySettings);
            StreamEx fixesStream = StreamEx.of(this.myBlockingMethodCheckers).flatArray(checker -> checker.getQuickFixesFor(elementContext));
            if (contextType instanceof ContextType.Unsure && !BlockingMethodInNonBlockingContextInspection.this.myConsiderUnknownContextBlocking) {
                fixesStream = fixesStream.append((Object)LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)BlockingMethodInNonBlockingContextInspection.this, "myConsiderUnknownContextBlocking", JvmAnalysisBundle.message("jvm.inspections.blocking.method.consider.unknown.context.blocking", new Object[0]), true)));
            }
            if (contextType instanceof ContextType.NonBlocking && StringUtil.isNotEmpty((String)((ContextType.NonBlocking)contextType).getDescription())) {
                String contextDescription = ((ContextType.NonBlocking)contextType).getDescription();
                message = JvmAnalysisBundle.message("jvm.inspections.blocking.method.problem.wildcard.descriptor", contextDescription);
            } else {
                message = JvmAnalysisBundle.message("jvm.inspections.blocking.method.problem.descriptor", new Object[0]);
            }
            this.myHolder.registerProblem(elementToHighLight, message, (LocalQuickFix[])fixesStream.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
        }

        public void visitMethod(UMethod method) {
            String message;
            if (method == null || !method.isConstructor()) {
                return;
            }
            PsiElement element = method.getSourcePsi();
            if (element == null) {
                return;
            }
            UElement anchor = method.getUastAnchor();
            if (anchor == null) {
                return;
            }
            PsiElement elementToHighlight = anchor.getSourcePsi();
            if (elementToHighlight == null) {
                return;
            }
            UElement uElement = method.getUastParent();
            if (!(uElement instanceof UClass)) {
                return;
            }
            UClass containingClass = (UClass)uElement;
            if (containingClass.getJavaPsi().getSuperClass() == null) {
                return;
            }
            UExpression uExpression = method.getUastBody();
            if (!(uExpression instanceof UBlockExpression)) {
                return;
            }
            UBlockExpression body = (UBlockExpression)uExpression;
            UExpression firstExpression = (UExpression)ContainerUtil.getFirstItem((List)body.getExpressions());
            if (firstExpression != null && BlockingMethodInNonBlockingContextVisitor.isExplicitSuperCall(firstExpression)) {
                return;
            }
            ContextType contextType = BlockingMethodInNonBlockingContextInspection.isContextNonBlockingFor(element, this.myNonBlockingContextCheckers, this.mySettings);
            if (contextType instanceof ContextType.Blocking) {
                return;
            }
            if (!(contextType instanceof ContextType.NonBlocking)) {
                return;
            }
            ContextType.NonBlocking nonBlockingContext = (ContextType.NonBlocking)contextType;
            PsiMethod implicitlyCalledCtr = BlockingMethodInNonBlockingContextVisitor.findFirstExplicitNoArgConstructor(containingClass.getJavaPsi().getSuperClass());
            if (implicitlyCalledCtr == null) {
                return;
            }
            if (!BlockingMethodInNonBlockingContextInspection.isMethodBlocking(implicitlyCalledCtr, this.myBlockingMethodCheckers, this.mySettings)) {
                return;
            }
            if (StringUtil.isNotEmpty((String)nonBlockingContext.getDescription())) {
                String contextDescription = nonBlockingContext.getDescription();
                message = JvmAnalysisBundle.message("jvm.inspections.blocking.method.in.implicit.ctr.problem.wildcard.descriptor", contextDescription);
            } else {
                message = JvmAnalysisBundle.message("jvm.inspections.blocking.method.in.implicit.ctr.problem.descriptor", new Object[0]);
            }
            this.myHolder.registerProblem(elementToHighlight, message, new LocalQuickFix[0]);
        }

        @Nullable
        private static PsiMethod findFirstExplicitNoArgConstructor(@NotNull PsiClass currentClass) {
            if (currentClass == null) {
                BlockingMethodInNonBlockingContextVisitor.$$$reportNull$$$0(1);
            }
            while (currentClass != null) {
                PsiMethod explicitEmptyArgCtr = (PsiMethod)ContainerUtil.find((Object[])currentClass.getConstructors(), ctr -> !ctr.hasParameters());
                if (explicitEmptyArgCtr != null) {
                    return explicitEmptyArgCtr;
                }
                currentClass = currentClass.getSuperClass();
            }
            return null;
        }

        private static boolean isExplicitSuperCall(@NotNull UExpression expression) {
            UCallExpression call;
            if (expression == null) {
                BlockingMethodInNonBlockingContextVisitor.$$$reportNull$$$0(2);
            }
            if (!(expression instanceof USuperExpression || expression instanceof UCallExpression && (call = (UCallExpression)expression).getKind() == UastCallKind.CONSTRUCTOR_CALL)) {
                return true;
            }
            PsiElement sourcePsi = expression.getSourcePsi();
            if (sourcePsi == null) {
                return false;
            }
            return !sourcePsi.getTextRange().isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/BlockingMethodInNonBlockingContextInspection$BlockingMethodInNonBlockingContextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findFirstExplicitNoArgConstructor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExplicitSuperCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

