/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0014J\b\u0010\b\u001a\u00020\u0003H\u0014J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J4\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/GradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/GradleKotlinFrameworkSupportProvider;", "frameworkTypeId", "", "displayName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPluginId", "getPluginExpression", "getDependencies", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "addSupport", "", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "specifyPluginVersionIfNeeded", "", "explicitPluginVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getDescription", "kotlin.gradle.gradle-java"})
public class GradleKotlinJavaFrameworkSupportProvider
extends GradleKotlinFrameworkSupportProvider {
    public GradleKotlinJavaFrameworkSupportProvider(@NotNull String frameworkTypeId, @Nls @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)frameworkTypeId, (String)"frameworkTypeId");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Icon icon2 = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SMALL_LOGO");
        super(frameworkTypeId, displayName, icon2);
    }

    public /* synthetic */ GradleKotlinJavaFrameworkSupportProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "KOTLIN";
        }
        if ((n & 2) != 0) {
            string2 = KotlinIdeaGradleBundle.message("framework.support.provider.kotlin.jvm.display.name", new Object[0]);
        }
        this(string, string2);
    }

    @Override
    @NotNull
    protected String getPluginId() {
        return "kotlin";
    }

    @Override
    @NotNull
    protected String getPluginExpression() {
        return "id 'org.jetbrains.kotlin.jvm'";
    }

    @Override
    @NotNull
    protected List<String> getDependencies(@Nullable Sdk sdk2) {
        return CollectionsKt.listOf((Object)KotlinProjectConfigurationUtils.getJvmStdlibArtifactId(sdk2, KotlinPluginLayout.getStandaloneCompilerVersion()));
    }

    @Override
    public void addSupport(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull Module module, @Nullable Sdk sdk2, boolean specifyPluginVersionIfNeeded, @Nullable IdeKotlinVersion explicitPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super.addSupport(buildScriptData, module, sdk2, specifyPluginVersionIfNeeded, explicitPluginVersion);
        JvmTarget jvmTarget = KotlinProjectConfigurationUtils.getDefaultJvmTarget(sdk2, KotlinPluginLayout.getStandaloneCompilerVersion());
        if (jvmTarget != null) {
            String description = jvmTarget.getDescription();
            buildScriptData.addOther("compileKotlin {\n    kotlinOptions.jvmTarget = \"" + description + "\"\n}\n\n");
            buildScriptData.addOther("compileTestKotlin {\n    kotlinOptions.jvmTarget = \"" + description + "\"\n}\n");
        }
    }

    @Override
    @NotNull
    protected String getDescription() {
        return KotlinIdeaGradleBundle.message("description.text.a.single.platform.kotlin.library.or.application.targeting.the.jvm", new Object[0]);
    }

    public GradleKotlinJavaFrameworkSupportProvider() {
        this(null, null, 3, null);
    }
}

