/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.InlineStatus;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlinedLambdaNonSourceAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnonymousFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlinedLambdaNonSourceAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlinedLambdaNonSourceAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlinedLambdaNonSourceAnnotationsChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,51:1\n71#2,4:52\n*S KotlinDebug\n*F\n+ 1 FirInlinedLambdaNonSourceAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlinedLambdaNonSourceAnnotationsChecker\n*L\n33#1:52,4\n*E\n"})
public final class FirInlinedLambdaNonSourceAnnotationsChecker
extends FirDeclarationChecker<FirAnonymousFunction> {
    @NotNull
    public static final FirInlinedLambdaNonSourceAnnotationsChecker INSTANCE = new FirInlinedLambdaNonSourceAnnotationsChecker();

    private FirInlinedLambdaNonSourceAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirAnonymousFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.getInlineStatus() != InlineStatus.Inline && declaration.getInlineStatus() != InlineStatus.CrossInline) {
            return;
        }
        for (FirStatement call2 : context2.getCallsOrAssignments()) {
            LinkedHashMap<FirExpression, FirValueParameter> mapping2;
            if (!(call2 instanceof FirFunctionCall) || !FirReferenceUtilsKt.isError(((FirFunctionCall)call2).getCalleeReference())) continue;
            FirCall $this$resolvedArgumentMapping$iv = (FirCall)call2;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            if ((argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null) == null) continue;
            mapping2 = mapping2;
            for (Map.Entry entry : ((Map)mapping2).entrySet()) {
                FirExpression argument2 = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                FirExpression firExpression = FirExpressionUtilKt.unwrapArgument(argument2);
                FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression : null;
                if ((firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null) != declaration) continue;
                return;
            }
        }
        for (FirAnnotation it : declaration.getAnnotations()) {
            FirClassLikeSymbol<?> annotationSymbol;
            if (FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(it, context2.getSession()) == null || FirRetentionAnnotationHelpersKt.getAnnotationRetention(annotationSymbol, context2.getSession()) == AnnotationRetention.SOURCE) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getNON_SOURCE_ANNOTATION_ON_INLINED_LAMBDA_EXPRESSION(), null, (int)8, null);
        }
    }
}

