/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.openapi.util.Ref;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.BfsWalk;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntHashSetFlags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0000\u001a,\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0000\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0007\u001a$\u0010\r\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007\u001a\u0012\u0010\u0016\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002\u001a*\u0010\u0019\u001a\u00020\u0013*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00052\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u001cH\u0007\u001a*\u0010\u0019\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00052\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u001cH\u0007\u00a8\u0006\u001d"}, d2={"getReachableNodes", "Lcom/intellij/vcs/log/graph/utils/UnsignedBitSet;", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "startNodes", "", "", "getReachableMatchingNodes", "matchedNodes", "isAncestor", "", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "lowerNode", "upperNode", "getCorrespondingParent", "startNode", "endNode", "visited", "Lcom/intellij/vcs/log/graph/utils/Flags;", "subgraphDifference", "Lit/unimi/dsi/fastutil/ints/IntSet;", "node1", "node2", "minOrDefault", "", "maxOrDefault", "exclusiveNodes", "headNode", "isHead", "Lkotlin/Function1;", "intellij.platform.vcs.log.graph.impl"})
@SourceDebugExtension(value={"SMAP\nGraphUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphUtil.kt\ncom/intellij/vcs/log/graph/utils/GraphUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1634#2,3:165\n1740#2,3:168\n*S KotlinDebug\n*F\n+ 1 GraphUtil.kt\ncom/intellij/vcs/log/graph/utils/GraphUtilKt\n*L\n83#1:165,3\n146#1:168,3\n*E\n"})
public final class GraphUtilKt {
    @NotNull
    public static final UnsignedBitSet getReachableNodes(@NotNull LinearGraph $this$getReachableNodes, @Nullable Set<Integer> startNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$getReachableNodes, (String)"<this>");
        return GraphUtilKt.getReachableMatchingNodes($this$getReachableNodes, startNodes, null);
    }

    @NotNull
    public static final UnsignedBitSet getReachableMatchingNodes(@NotNull LinearGraph $this$getReachableMatchingNodes, @Nullable Set<Integer> startNodes, @Nullable Set<Integer> matchedNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$getReachableMatchingNodes, (String)"<this>");
        UnsignedBitSet visibility = new UnsignedBitSet();
        if (startNodes == null) {
            if (matchedNodes == null) {
                visibility.set(0, $this$getReachableMatchingNodes.nodesCount() - 1, true);
            } else {
                Iterator<Integer> iterator = matchedNodes.iterator();
                while (iterator.hasNext()) {
                    int matchedId = ((Number)iterator.next()).intValue();
                    visibility.set(matchedId, true);
                }
            }
            return visibility;
        }
        new DfsWalk((Collection<Integer>)startNodes, $this$getReachableMatchingNodes).walk(true, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> GraphUtilKt.getReachableMatchingNodes$lambda$0(matchedNodes, visibility, arg_0)));
        return visibility;
    }

    @ApiStatus.Internal
    public static final boolean isAncestor(@NotNull LiteLinearGraph $this$isAncestor, int lowerNode, int upperNode) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestor, (String)"<this>");
        BitSetFlags visited = new BitSetFlags($this$isAncestor.nodesCount(), false);
        Ref result = Ref.create((Object)false);
        DfsUtilKt.walk(lowerNode, (Function1<? super Integer, Integer>)((Function1)arg_0 -> GraphUtilKt.isAncestor$lambda$0(visited, upperNode, result, $this$isAncestor, arg_0)));
        Object object = result.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final int getCorrespondingParent(@NotNull LiteLinearGraph $this$getCorrespondingParent, int startNode, int endNode, @NotNull Flags visited) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getCorrespondingParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visited, (String)"visited");
        List<Integer> list = $this$getCorrespondingParent.getNodes(startNode, LiteLinearGraph.NodeFilter.DOWN);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNodes(...)");
        List<Integer> candidates = list;
        if (candidates.size() == 1) {
            Integer n = candidates.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            return ((Number)n).intValue();
        }
        if (candidates.contains(endNode)) {
            return endNode;
        }
        Iterable iterable = candidates;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Integer n = (Integer)item$iv;
            void var13_12 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            var13_12.add(new BfsWalk(it.intValue(), $this$getCorrespondingParent, visited, false, 8, null));
        }
        List bfsWalks = (List)destination$iv;
        visited.setAll(false);
        do {
            for (BfsWalk walk : bfsWalks) {
                if (!BfsWalk.step$default(walk, null, 1, null).contains(endNode)) continue;
                return walk.getStart();
            }
            bfsWalks.removeIf(arg_0 -> GraphUtilKt.getCorrespondingParent$lambda$2(GraphUtilKt::getCorrespondingParent$lambda$1, arg_0));
        } while (!((Collection)bfsWalks).isEmpty());
        Integer n = candidates.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        return ((Number)n).intValue();
    }

    @ApiStatus.Internal
    @NotNull
    public static final IntSet subgraphDifference(@NotNull LinearGraph $this$subgraphDifference, int node1, int node2) {
        Intrinsics.checkNotNullParameter((Object)$this$subgraphDifference, (String)"<this>");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph($this$subgraphDifference);
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph liteLinearGraph2 = liteLinearGraph;
        BitSetFlags visited2 = new BitSetFlags($this$subgraphDifference.nodesCount());
        BfsWalk bfsWalk2 = new BfsWalk(node2, liteLinearGraph2, visited2, false, 8, null);
        int n = $this$subgraphDifference.nodesCount();
        IntHashSetFlags visited12 = new IntHashSetFlags(visited2, bfsWalk2, n){
            final /* synthetic */ BitSetFlags $visited2;
            final /* synthetic */ BfsWalk $bfsWalk2;
            {
                this.$visited2 = $visited2;
                this.$bfsWalk2 = $bfsWalk2;
                super($super_call_param$1);
            }

            public boolean get(int index) {
                return super.get(index) || this.$visited2.get(index) || this.$bfsWalk2.currentNodes().contains(index);
            }
        };
        BfsWalk bfsWalk1 = new BfsWalk(node1, liteLinearGraph2, visited12, false, 8, null);
        int max1 = GraphUtilKt.maxOrDefault((Iterable<Integer>)bfsWalk1.currentNodes());
        int min2 = GraphUtilKt.minOrDefault((Iterable<Integer>)bfsWalk2.currentNodes());
        while (!bfsWalk1.isFinished()) {
            if (max1 < min2) {
                max1 = Math.max(max1, GraphUtilKt.maxOrDefault(BfsWalk.step$default(bfsWalk1, null, 1, null)));
                continue;
            }
            BfsWalk.step$default(bfsWalk2, null, 1, null);
            min2 = GraphUtilKt.minOrDefault((Iterable<Integer>)bfsWalk2.currentNodes());
        }
        return (IntSet)visited12.getData();
    }

    private static final int minOrDefault(Iterable<Integer> $this$minOrDefault) {
        Integer n = (Integer)CollectionsKt.minOrNull($this$minOrDefault);
        return n != null ? n : Integer.MAX_VALUE;
    }

    private static final int maxOrDefault(Iterable<Integer> $this$maxOrDefault) {
        Integer n = (Integer)CollectionsKt.maxOrNull($this$maxOrDefault);
        return n != null ? n : Integer.MIN_VALUE;
    }

    @ApiStatus.Internal
    @NotNull
    public static final IntSet exclusiveNodes(@NotNull LiteLinearGraph $this$exclusiveNodes, int headNode, @NotNull Function1<? super Integer, Boolean> isHead) {
        Intrinsics.checkNotNullParameter((Object)$this$exclusiveNodes, (String)"<this>");
        Intrinsics.checkNotNullParameter(isHead, (String)"isHead");
        IntOpenHashSet result = new IntOpenHashSet();
        new BfsWalk(headNode, $this$exclusiveNodes).walk((Function1<? super Integer, Boolean>)((Function1)arg_0 -> GraphUtilKt.exclusiveNodes$lambda$1($this$exclusiveNodes, headNode, isHead, result, arg_0)));
        return (IntSet)result;
    }

    public static /* synthetic */ IntSet exclusiveNodes$default(LiteLinearGraph liteLinearGraph, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = GraphUtilKt::exclusiveNodes$lambda$0;
        }
        return GraphUtilKt.exclusiveNodes(liteLinearGraph, n, (Function1<? super Integer, Boolean>)function1);
    }

    @ApiStatus.Internal
    @NotNull
    public static final IntSet exclusiveNodes(@NotNull LinearGraph $this$exclusiveNodes, int headNode, @NotNull Function1<? super Integer, Boolean> isHead) {
        Intrinsics.checkNotNullParameter((Object)$this$exclusiveNodes, (String)"<this>");
        Intrinsics.checkNotNullParameter(isHead, (String)"isHead");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph($this$exclusiveNodes);
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        return GraphUtilKt.exclusiveNodes(liteLinearGraph, headNode, isHead);
    }

    public static /* synthetic */ IntSet exclusiveNodes$default(LinearGraph linearGraph, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = GraphUtilKt::exclusiveNodes$lambda$2;
        }
        return GraphUtilKt.exclusiveNodes(linearGraph, n, (Function1<? super Integer, Boolean>)function1);
    }

    private static final boolean getReachableMatchingNodes$lambda$0(Set $matchedNodes, UnsignedBitSet $visibility, int node) {
        if ($matchedNodes == null || $matchedNodes.contains(node)) {
            $visibility.set(node, true);
        }
        return true;
    }

    private static final int isAncestor$lambda$0(BitSetFlags $visited, int $upperNode, Ref $result, LiteLinearGraph $this_isAncestor, int currentNode) {
        $visited.set(currentNode, true);
        if (currentNode == $upperNode) {
            $result.set((Object)true);
            return -10;
        }
        if (currentNode > $upperNode) {
            for (Integer nextNode : $this_isAncestor.getNodes(currentNode, LiteLinearGraph.NodeFilter.UP)) {
                Intrinsics.checkNotNull((Object)nextNode);
                if ($visited.get(nextNode)) continue;
                return nextNode;
            }
        }
        return -1;
    }

    private static final boolean getCorrespondingParent$lambda$1(BfsWalk it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFinished();
    }

    private static final boolean getCorrespondingParent$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean exclusiveNodes$lambda$0(int it) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean exclusiveNodes$lambda$1(LiteLinearGraph $this_exclusiveNodes, int $headNode, Function1 $isHead, IntOpenHashSet $result, int it) {
        List<Integer> list = $this_exclusiveNodes.getNodes(it, LiteLinearGraph.NodeFilter.UP);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNodes(...)");
        List<Integer> upNodes = list;
        if (!upNodes.isEmpty()) {
            boolean bl;
            Iterable $this$all$iv = upNodes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Integer it2 = (Integer)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    if ($result.contains(it2.intValue())) continue;
                    return false;
                }
                bl = true;
            }
            if (!bl) return false;
        }
        if (it != $headNode) {
            if ((Boolean)$isHead.invoke((Object)it) != false) return false;
        }
        $result.add(it);
        return true;
    }

    private static final boolean exclusiveNodes$lambda$2(int it) {
        return false;
    }
}

