/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JumpsAndSwitches
implements CoverageData {
    private List<JumpData> myJumps;
    private JumpData[] myJumpsArray;
    private List<SwitchData> mySwitches;
    private SwitchData[] mySwitchesArray;

    public JumpData[] getJumps() {
        return this.myJumpsArray;
    }

    public SwitchData[] getSwitches() {
        return this.mySwitchesArray;
    }

    /*
     * WARNING - void declaration
     */
    public JumpData addJump(int jump) {
        void var1_1;
        if (this.myJumps == null) {
            this.myJumps = new ArrayList<JumpData>();
        }
        if (this.myJumps.size() <= jump) {
            for (int i = this.myJumps.size(); i <= jump; ++i) {
                this.myJumps.add(new JumpData());
            }
        }
        return this.myJumps.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JumpData getJumpData(int jump) {
        void var1_1;
        if (this.myJumpsArray == null) {
            if (this.myJumps == null) {
                return null;
            }
            return this.myJumps.get(jump);
        }
        return this.myJumpsArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public SwitchData addSwitch(int switchNumber, int[] keys) {
        void var1_1;
        if (this.mySwitches == null) {
            this.mySwitches = new ArrayList<SwitchData>();
        }
        SwitchData switchData = new SwitchData(keys);
        if (this.mySwitches.size() <= switchNumber) {
            for (int i = this.mySwitches.size(); i < switchNumber; ++i) {
                this.mySwitches.add(new SwitchData(new int[0]));
            }
            if (this.mySwitches.size() == switchNumber) {
                void var2_2;
                this.mySwitches.add((SwitchData)var2_2);
            }
        }
        return this.mySwitches.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeSwitch(int switchNumber) {
        void var1_1;
        if (switchNumber >= 0 && switchNumber < this.mySwitches.size()) {
            this.mySwitches.remove(switchNumber);
            return;
        }
        ErrorReporter.warn("Remove switch", new ArrayIndexOutOfBoundsException((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public SwitchData getSwitchData(int switchNumber) {
        void var1_1;
        if (this.mySwitchesArray == null) {
            if (this.mySwitches == null) {
                return null;
            }
            return this.mySwitches.get(switchNumber);
        }
        return this.mySwitchesArray[var1_1];
    }

    public void save(DataOutputStream os) throws IOException {
        CoverageData coverageData;
        int n;
        int n2;
        CoverageData[] coverageDataArray;
        CoverageIOUtil.writeINT(os, this.myJumpsArray != null ? this.myJumpsArray.length : 0);
        if (this.myJumpsArray != null) {
            coverageDataArray = this.myJumpsArray;
            n2 = this.myJumpsArray.length;
            for (n = 0; n < n2; ++n) {
                coverageData = coverageDataArray[n];
                coverageData.save(os);
            }
        }
        CoverageIOUtil.writeINT(os, this.mySwitchesArray != null ? this.mySwitchesArray.length : 0);
        if (this.mySwitchesArray != null) {
            coverageDataArray = this.mySwitchesArray;
            n2 = this.mySwitchesArray.length;
            for (n = 0; n < n2; ++n) {
                coverageData = coverageDataArray[n];
                ((SwitchData)coverageData).save(os);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeJump(int jump) {
        void var1_1;
        if (jump >= 0 && jump < this.myJumps.size()) {
            this.myJumps.remove(jump);
            return;
        }
        ErrorReporter.warn("Remove jump", new ArrayIndexOutOfBoundsException((int)var1_1));
    }

    public void fillArrays() {
        int i;
        if (this.myJumps != null) {
            this.myJumpsArray = new JumpData[this.myJumps.size()];
            for (i = 0; i < this.myJumps.size(); ++i) {
                this.myJumpsArray[i] = this.myJumps.get(i);
            }
            this.myJumps = null;
        }
        if (this.mySwitches != null) {
            this.mySwitchesArray = new SwitchData[this.mySwitches.size()];
            for (i = 0; i < this.mySwitches.size(); ++i) {
                this.mySwitchesArray[i] = this.mySwitches.get(i);
            }
            this.mySwitches = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void merge(CoverageData data) {
        CoverageData[] extJumpsArray;
        JumpsAndSwitches jumpsData = (JumpsAndSwitches)data;
        if (jumpsData.myJumpsArray != null) {
            if (this.myJumpsArray == null) {
                this.myJumpsArray = new JumpData[jumpsData.myJumpsArray.length];
            } else if (this.myJumpsArray.length < jumpsData.myJumpsArray.length) {
                extJumpsArray = new JumpData[jumpsData.myJumpsArray.length];
                System.arraycopy(this.myJumpsArray, 0, extJumpsArray, 0, this.myJumpsArray.length);
                this.myJumpsArray = extJumpsArray;
            }
            JumpsAndSwitches.mergeJumps(this.myJumpsArray, jumpsData.myJumpsArray);
        }
        if (jumpsData.mySwitchesArray != null) {
            void var1_1;
            if (this.mySwitchesArray == null) {
                this.mySwitchesArray = new SwitchData[jumpsData.mySwitchesArray.length];
            } else if (this.mySwitchesArray.length < jumpsData.mySwitchesArray.length) {
                void var2_2;
                extJumpsArray = new SwitchData[jumpsData.mySwitchesArray.length];
                System.arraycopy(this.mySwitchesArray, 0, extJumpsArray, 0, this.mySwitchesArray.length);
                this.mySwitchesArray = var2_2;
            }
            JumpsAndSwitches.mergeSwitches(this.mySwitchesArray, var1_1.mySwitchesArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mergeSwitches(SwitchData[] myArray, SwitchData[] array) {
        for (int i = 0; i < array.length; ++i) {
            void var3_3;
            SwitchData switchData = myArray[i];
            if (switchData == null) {
                if (array[i] == null) continue;
                myArray[i] = switchData = new SwitchData(array[i].getKeys());
            }
            var3_3.merge(array[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void mergeJumps(JumpData[] myArray, JumpData[] array) {
        for (int i = 0; i < array.length; ++i) {
            void var3_3;
            JumpData switchData = myArray[i];
            if (switchData == null) {
                if (array[i] == null) continue;
                myArray[i] = switchData = new JumpData();
            }
            var3_3.merge(array[i]);
        }
    }

    public int jumpsCount() {
        if (this.myJumps != null) {
            return this.myJumps.size();
        }
        if (this.myJumpsArray != null) {
            return this.myJumpsArray.length;
        }
        return 0;
    }

    public int switchesCount() {
        if (this.mySwitches != null) {
            return this.mySwitches.size();
        }
        if (this.mySwitchesArray != null) {
            return this.mySwitchesArray.length;
        }
        return 0;
    }
}

