/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream32;
import com.dynatrace.hash4j.hashing.AbstractHasher32;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream32;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.Hasher32;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;

final class Murmur3_32
implements AbstractHasher32 {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private static final Hasher32 DEFAULT_HASHER_INSTANCE = Murmur3_32.create(0);

    static Hasher32 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher32 create(int seed) {
        return new Murmur3_32(seed);
    }

    private Murmur3_32(int seed) {
        this.seed = seed;
    }

    @Override
    public HashStream32 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public int hashBytesToInt(byte[] input, int off, int len) {
        int nblocks = len >>> 2;
        int h1 = this.seed;
        int i = 0;
        while (i < nblocks) {
            int k1 = ByteArrayUtil.getInt(input, off);
            k1 = Murmur3_32.mixK1(k1);
            h1 = Murmur3_32.mixH1(h1, k1);
            ++i;
            off += 4;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (input[off + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 ^= (input[off + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 ^= input[off] & 0xFF;
                k1 = Murmur3_32.mixK1(k1);
                h1 ^= k1;
            }
        }
        return Murmur3_32.fmix32(h1 ^= len);
    }

    @Override
    public <T> int hashBytesToInt(T input, long off, long len, ByteAccess<T> access) {
        long nblocks = len >>> 2;
        int h1 = this.seed;
        int i = 0;
        while ((long)i < nblocks) {
            int k1 = access.getInt(input, off);
            k1 = Murmur3_32.mixK1(k1);
            h1 = Murmur3_32.mixH1(h1, k1);
            ++i;
            off += 4L;
        }
        int k1 = 0;
        switch ((int)(len & 3L)) {
            case 3: {
                k1 = access.getByteAsUnsignedInt(input, off + 2L) << 16;
            }
            case 2: {
                k1 ^= access.getByteAsUnsignedInt(input, off + 1L) << 8;
            }
            case 1: {
                k1 ^= access.getByteAsUnsignedInt(input, off);
                k1 = Murmur3_32.mixK1(k1);
                h1 ^= k1;
            }
        }
        return Murmur3_32.fmix32(h1 ^= (int)len);
    }

    @Override
    public int hashCharsToInt(CharSequence input) {
        int len = input.length();
        int nblocks = len >>> 1;
        int h1 = this.seed;
        for (int i = 0; i < nblocks; ++i) {
            int k1 = ByteArrayUtil.getInt(input, i << 1);
            k1 = Murmur3_32.mixK1(k1);
            h1 = Murmur3_32.mixH1(h1, k1);
        }
        if ((len & 1) != 0) {
            int k1 = input.charAt(len - 1);
            k1 = Murmur3_32.mixK1(k1);
            h1 ^= k1;
        }
        return Murmur3_32.fmix32(h1 ^= len << 1);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix32(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    @Override
    public int hashIntToInt(int v) {
        int h1 = this.seed;
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1(v));
        return Murmur3_32.fmix32(h1 ^= 4);
    }

    @Override
    public int hashIntIntToInt(int v1, int v2) {
        int h1 = this.seed;
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1(v1));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1(v2));
        return Murmur3_32.fmix32(h1 ^= 8);
    }

    @Override
    public int hashIntIntIntToInt(int v1, int v2, int v3) {
        int h1 = this.seed;
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1(v1));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1(v2));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1(v3));
        return Murmur3_32.fmix32(h1 ^= 0xC);
    }

    @Override
    public int hashIntLongToInt(int v1, long v2) {
        return this.hashIntIntIntToInt(v1, (int)v2, (int)(v2 >>> 32));
    }

    @Override
    public int hashLongToInt(long v) {
        return this.hashIntIntToInt((int)v, (int)(v >>> 32));
    }

    @Override
    public int hashLongLongToInt(long v1, long v2) {
        int h1 = this.seed;
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)v1));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)(v1 >>> 32)));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)v2));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)(v2 >>> 32)));
        return Murmur3_32.fmix32(h1 ^= 0x10);
    }

    @Override
    public int hashLongLongLongToInt(long v1, long v2, long v3) {
        int h1 = this.seed;
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)v1));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)(v1 >>> 32)));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)v2));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)(v2 >>> 32)));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)v3));
        h1 = Murmur3_32.mixH1(h1, Murmur3_32.mixK1((int)(v3 >>> 32)));
        return Murmur3_32.fmix32(h1 ^= 0x18);
    }

    @Override
    public int hashLongIntToInt(long v1, int v2) {
        return this.hashIntIntIntToInt((int)v1, (int)(v1 >>> 32), v2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Murmur3_32)) {
            return false;
        }
        Murmur3_32 that = (Murmur3_32)obj;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return Integer.hashCode(this.seed);
    }

    private class HashStreamImpl
    implements AbstractHashStream32 {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private static final byte SERIAL_VERSION_V0 = 0;

        private HashStreamImpl() {
            this.h1 = Murmur3_32.this.seed;
            this.buffer = 0L;
            this.shift = 0;
            this.length = 0;
        }

        public int hashCode() {
            return this.getAsInt();
        }

        public boolean equals(Object obj) {
            return HashUtil.equalsHelper(this, obj);
        }

        @Override
        public HashStream32 reset() {
            this.h1 = Murmur3_32.this.seed;
            this.buffer = 0L;
            this.shift = 0;
            this.length = 0;
            return this;
        }

        @Override
        public Hasher32 getHasher() {
            return Murmur3_32.this;
        }

        @Override
        public byte[] getState() {
            int numBufferBytes = this.length & 3;
            byte[] state = new byte[9 + numBufferBytes];
            state[0] = 0;
            int off = 1;
            ByteArrayUtil.setInt(state, off, this.length);
            ByteArrayUtil.setInt(state, off += 4, this.h1);
            off += 4;
            for (int i = 0; i < numBufferBytes; ++i) {
                state[off++] = (byte)(this.buffer >>> (i << 3));
            }
            return state;
        }

        @Override
        public HashStream32 setState(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 9);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            this.length = ByteArrayUtil.getInt(state, off);
            this.h1 = ByteArrayUtil.getInt(state, off += 4);
            off += 4;
            int numBufferBytes = this.length & 3;
            Preconditions.checkArgument(state.length == 9 + numBufferBytes);
            this.buffer = 0L;
            for (int i = 0; i < numBufferBytes; ++i) {
                this.buffer |= (long)((state[off++] & 0xFF) << (i << 3));
            }
            this.shift = numBufferBytes << 3;
            return this;
        }

        @Override
        public HashStream32 putByte(byte b) {
            this.buffer |= ((long)b & 0xFFL) << this.shift;
            this.shift += 8;
            ++this.length;
            if (this.shift >= 32) {
                this.processBuffer((int)this.buffer);
                this.buffer >>>= 32;
                this.shift -= 32;
            }
            return this;
        }

        @Override
        public HashStream32 putShort(short v) {
            return this.putTwoBytes((long)v & 0xFFFFL);
        }

        @Override
        public HashStream32 putChar(char v) {
            return this.putTwoBytes(v);
        }

        private HashStream32 putTwoBytes(long v) {
            this.buffer |= v << this.shift;
            this.shift += 16;
            this.length += 2;
            if (this.shift >= 32) {
                this.processBuffer((int)this.buffer);
                this.buffer >>>= 32;
                this.shift -= 32;
            }
            return this;
        }

        @Override
        public HashStream32 putInt(int v) {
            this.buffer |= ((long)v & 0xFFFFFFFFL) << this.shift;
            this.length += 4;
            this.processBuffer((int)this.buffer);
            this.buffer >>>= 32;
            return this;
        }

        @Override
        public HashStream32 putLong(long l) {
            this.processBuffer((int)(this.buffer | l << this.shift));
            this.buffer = l >>> 32 - this.shift;
            this.processBuffer((int)this.buffer);
            this.buffer >>>= 32;
            this.length += 8;
            return this;
        }

        @Override
        public HashStream32 putBytes(byte[] b, int off, int len) {
            int regularBlockStartIdx = -this.length & 3;
            int regularBlockEndIdx = len - (len + this.length & 3);
            this.length += len;
            if (regularBlockEndIdx < regularBlockStartIdx) {
                if (len != 0) {
                    this.buffer |= (long)((b[off] & 0xFF) << this.shift);
                    this.shift += 8;
                    if (len != 1) {
                        this.buffer |= (long)((b[off + 1] & 0xFF) << this.shift);
                        this.shift += 8;
                    }
                }
                return this;
            }
            if (regularBlockStartIdx != 0) {
                int x = (int)this.buffer;
                if (regularBlockStartIdx != 1) {
                    if (regularBlockStartIdx != 2) {
                        x |= (b[off + regularBlockStartIdx - 3] & 0xFF) << 8;
                    }
                    x |= (b[off + regularBlockStartIdx - 2] & 0xFF) << 16;
                }
                this.processBuffer(x |= b[off + regularBlockStartIdx - 1] << 24);
                this.buffer = 0L;
            }
            for (int i = regularBlockStartIdx; i < regularBlockEndIdx; i += 4) {
                this.processBuffer(ByteArrayUtil.getInt(b, off + i));
            }
            int remainingBytes = len - regularBlockEndIdx;
            this.shift = remainingBytes << 3;
            if (remainingBytes != 0) {
                this.buffer = b[off + regularBlockEndIdx] & 0xFF;
                if (remainingBytes != 1) {
                    this.buffer |= (long)((b[off + regularBlockEndIdx + 1] & 0xFF) << 8);
                    if (remainingBytes != 2) {
                        this.buffer |= (long)((b[off + regularBlockEndIdx + 2] & 0xFF) << 16);
                    }
                }
            }
            return this;
        }

        @Override
        public <T> HashStream32 putBytes(T b, long off, long len, ByteAccess<T> access) {
            int regularBlockStartIdx = -this.length & 3;
            long regularBlockEndIdx = len - (len + (long)this.length & 3L);
            this.length += (int)len;
            if (regularBlockEndIdx < (long)regularBlockStartIdx) {
                if (len != 0L) {
                    this.buffer |= (long)(access.getByteAsUnsignedInt(b, off) << this.shift);
                    this.shift += 8;
                    if (len != 1L) {
                        this.buffer |= (long)(access.getByteAsUnsignedInt(b, off + 1L) << this.shift);
                        this.shift += 8;
                    }
                }
                return this;
            }
            if (regularBlockStartIdx != 0) {
                int x = (int)this.buffer;
                if (regularBlockStartIdx != 1) {
                    if (regularBlockStartIdx != 2) {
                        x |= access.getByteAsUnsignedInt(b, off + (long)regularBlockStartIdx - 3L) << 8;
                    }
                    x |= access.getByteAsUnsignedInt(b, off + (long)regularBlockStartIdx - 2L) << 16;
                }
                this.processBuffer(x |= access.getByte(b, off + (long)regularBlockStartIdx - 1L) << 24);
                this.buffer = 0L;
            }
            for (long i = (long)regularBlockStartIdx; i < regularBlockEndIdx; i += 4L) {
                this.processBuffer(access.getInt(b, off + i));
            }
            int remainingBytes = (int)(len - regularBlockEndIdx);
            this.shift = remainingBytes << 3;
            if (remainingBytes != 0) {
                this.buffer = access.getByteAsUnsignedInt(b, off + regularBlockEndIdx);
                if (remainingBytes != 1) {
                    this.buffer |= (long)(access.getByteAsUnsignedInt(b, off + regularBlockEndIdx + 1L) << 8);
                    if (remainingBytes != 2) {
                        this.buffer |= (long)(access.getByteAsUnsignedInt(b, off + regularBlockEndIdx + 2L) << 16);
                    }
                }
            }
            return this;
        }

        @Override
        public int getAsInt() {
            return Murmur3_32.fmix32(this.h1 ^ Murmur3_32.mixK1((int)this.buffer) ^ this.length);
        }

        private void processBuffer(int x) {
            this.h1 = Murmur3_32.mixH1(this.h1, Murmur3_32.mixK1(x));
        }

        @Override
        public HashStream32 putChars(CharSequence s) {
            int len = s.length();
            if (len == 0) {
                return this;
            }
            int regularBlockStartIdx = this.length >>> 1 & 1;
            int regularBlockEndIdx = len - (len & 1 ^ regularBlockStartIdx);
            this.length += len << 1;
            if ((this.length & 1) == 0) {
                if (regularBlockStartIdx > 0) {
                    this.processBuffer((int)this.buffer | s.charAt(0) << 16);
                    this.buffer = 0L;
                    this.shift = 0;
                }
                for (int i = regularBlockStartIdx; i < regularBlockEndIdx; i += 2) {
                    this.processBuffer(s.charAt(i) | s.charAt(i + 1) << 16);
                }
                if (regularBlockEndIdx < len) {
                    this.buffer = s.charAt(regularBlockEndIdx);
                    this.shift = 16;
                }
            } else {
                if (regularBlockStartIdx > 0) {
                    this.buffer |= (long)s.charAt(0) << 24;
                    this.processBuffer((int)this.buffer);
                    this.buffer >>= 32;
                    this.shift = 8;
                }
                for (int i = regularBlockStartIdx; i < regularBlockEndIdx; i += 2) {
                    this.buffer |= (long)(s.charAt(i) << 8) | (long)s.charAt(i + 1) << 24;
                    this.processBuffer((int)this.buffer);
                    this.buffer >>= 32;
                }
                if (regularBlockEndIdx < len) {
                    this.buffer |= (long)(s.charAt(regularBlockEndIdx) << 8);
                    this.shift = 24;
                }
            }
            return this;
        }
    }
}

