/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KotlinValueClassRepresentation;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtClassElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinClassStubImpl;", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "psi-impl"})
public final class KtClassElementType
extends KtStubElementType<KotlinClassStubImpl, KtClass> {
    @NotNull
    public static final KtClassElementType INSTANCE = new KtClassElementType();

    private KtClassElementType() {
        super("CLASS", KtClass.class, KotlinClassStub.class);
    }

    @NotNull
    public KotlinClassStubImpl createStub(@NotNull KtClass psi, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        FqName fqName = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        String fqName2 = fqName != null ? fqName.asString() : null;
        ClassId classId = StubUtils.createNestedClassId(parentStub, psi);
        String name2 = psi.getName();
        List<String> superNames = KtPsiUtilKt.getSuperNames((StubBasedPsiElementBase<? extends KotlinClassOrObjectStub<? extends KtClassOrObject>>)((StubBasedPsiElementBase)psi));
        boolean isInterface = psi.isInterface();
        boolean isLocal = psi.isLocal();
        boolean isTopLevel = psi.isTopLevel();
        return new KotlinClassStubImpl(parentStub, StringRef.fromString((String)fqName2), classId, StringRef.fromString((String)name2), Utils.INSTANCE.wrapStrings(superNames), isInterface, false, isLocal, isTopLevel, null);
    }

    public void serialize(@NotNull KotlinClassStubImpl stub, @NotNull StubOutputStream dataStream) {
        KotlinValueClassRepresentation representation;
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.asString() : null);
        StubUtils.serializeClassId(dataStream, stub.getClassId());
        dataStream.writeBoolean(stub.isInterface());
        dataStream.writeBoolean(stub.isClsStubCompiledToJvmDefaultImplementation());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isTopLevel());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name2 : superNames) {
            dataStream.writeName(name2);
        }
        KotlinValueClassRepresentation kotlinValueClassRepresentation = representation = stub.getValueClassRepresentation();
        dataStream.writeVarInt(kotlinValueClassRepresentation == null ? 0 : kotlinValueClassRepresentation.ordinal() + 1);
    }

    @NotNull
    public KotlinClassStubImpl deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name2 = dataStream.readName();
        StringRef qualifiedName = dataStream.readName();
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isInterface = dataStream.readBoolean();
        boolean isClsStubCompiledToJvmDefaultImplementation = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] stringRefArray = StringRef.createArray((int)superCount);
        Intrinsics.checkNotNullExpressionValue((Object)stringRefArray, (String)"createArray(...)");
        StringRef[] superNames = stringRefArray;
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        int representationOrdinal = dataStream.readVarInt();
        KotlinValueClassRepresentation representation = representationOrdinal == 0 ? null : (KotlinValueClassRepresentation)((Object)KotlinValueClassRepresentation.getEntries().get(representationOrdinal - 1));
        return new KotlinClassStubImpl(parentStub, qualifiedName, classId, name2, superNames, isInterface, isClsStubCompiledToJvmDefaultImplementation, isLocal, isTopLevel, representation);
    }

    @Override
    public void indexStub(@NotNull KotlinClassStubImpl stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        StubIndexService.Companion.getInstance().indexClass(stub, sink);
    }
}

