/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Distance;
import tim.prune.data.NumberUtils;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.MethodPanelContainer;
import tim.prune.function.compress.ParameterValues;
import tim.prune.function.compress.methods.CompressionMethod;
import tim.prune.function.compress.methods.DouglasPeuckerMethod;
import tim.prune.function.compress.methods.DuplicatesMethod;
import tim.prune.function.compress.methods.NearbyDistMethod;
import tim.prune.function.compress.methods.NearbyFactorMethod;
import tim.prune.function.compress.methods.SingletonsMethod;
import tim.prune.function.compress.methods.SkiLiftsMethod;
import tim.prune.function.compress.methods.TooFastMethod;
import tim.prune.function.compress.methods.TooSlowMethod;
import tim.prune.function.compress.methods.TooSoonMethod;
import tim.prune.function.compress.methods.WackyPointsMethod;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.WholeNumberField;

public class MethodPanel
extends JPanel {
    private int _index;
    private final MethodPanelContainer _parent;
    private final Config _config;
    private final JCheckBox _activeCheckbox;
    private final JComboBox<String> _methodCombo;
    private final WholeNumberField _nearbySpanField = new WholeNumberField(5);
    private final WholeNumberField _douglasSpanField = new WholeNumberField(5);
    private final DecimalNumberField _wackyFactorField = new DecimalNumberField();
    private final DecimalNumberField _singletonFactorField = new DecimalNumberField();
    private final DecimalNumberField _speedLowLimitField = new DecimalNumberField();
    private final DecimalNumberField _speedHighLimitField = new DecimalNumberField();
    private final DecimalNumberField _distanceLimitField = new DecimalNumberField();
    private final WholeNumberField _timeLimitField = new WholeNumberField(5);
    private final JPanel _cardPanel = new JPanel();
    private final CardLayout _cards = new CardLayout();
    private final JLabel _numToDeleteLabel;
    private JButton _actionButton = null;
    private CompressionMethod _compressionMethod = null;

    public MethodPanel(int n, MethodPanelContainer methodPanelContainer, ParameterValues parameterValues, Config config) {
        this._index = n;
        this._parent = methodPanelContainer;
        this._config = config;
        this._activeCheckbox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
        this.add((Component)this._activeCheckbox, "West");
        this._actionButton = new JButton("...");
        this._actionButton.addActionListener(actionEvent -> this.showPopup());
        this.add((Component)MethodPanel.makeButtonHolder(this._actionButton), "East");
        this._methodCombo = new JComboBox<String>(MethodPanel.getMethodNames());
        this._numToDeleteLabel = new JLabel("text to go here");
        this._cardPanel.setLayout(this._cards);
        this.populateCards(parameterValues);
        this.setupListeners();
        this.add((Component)MethodPanel.combineIntoPanel(this._methodCombo, this._cardPanel, this._numToDeleteLabel), "Center");
        this.showNumDeleted(0);
    }

    private void showPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Move up");
        jMenuItem.addActionListener(actionEvent -> this._parent.movePanelUp(this._index));
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Move down");
        jMenuItem2.addActionListener(actionEvent -> this._parent.movePanelDown(this._index));
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Delete");
        jMenuItem3.addActionListener(actionEvent -> this._parent.deletePanel(this._index));
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.show(this._actionButton, 20, 15);
    }

    private void populateCards(ParameterValues parameterValues) {
        this._cardPanel.add((Component)new JPanel(), CompressionMethodType.NONE.toString());
        this._cardPanel.add((Component)new JPanel(), CompressionMethodType.DUPLICATES.toString());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(MethodPanel.makeParamLabel("closepoints"));
        jPanel.add(this._nearbySpanField);
        this._nearbySpanField.setValue(this.getIntValue(parameterValues, CompressionMethodType.NEARBY_WITH_FACTOR));
        this._cardPanel.add((Component)jPanel, CompressionMethodType.NEARBY_WITH_FACTOR.toString());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(MethodPanel.makeParamLabel("wackypoints"));
        jPanel2.add(this._wackyFactorField);
        this._wackyFactorField.setValue(this.getDoubleValue(parameterValues, CompressionMethodType.WACKY_POINTS));
        this._cardPanel.add((Component)jPanel2, CompressionMethodType.WACKY_POINTS.toString());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(MethodPanel.makeParamLabel("singletons"));
        jPanel3.add(this._singletonFactorField);
        this._singletonFactorField.setValue(this.getDoubleValue(parameterValues, CompressionMethodType.SINGLETONS));
        this._cardPanel.add((Component)jPanel3, CompressionMethodType.SINGLETONS.toString());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.add(MethodPanel.makeParamLabel("douglaspeucker"));
        jPanel4.add(this._douglasSpanField);
        this._douglasSpanField.setValue(this.getIntValue(parameterValues, CompressionMethodType.DOUGLAS_PEUCKER));
        this._cardPanel.add((Component)jPanel4, CompressionMethodType.DOUGLAS_PEUCKER.toString());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        String string = I18nManager.getText(this.getSpeedLimitUnits().getShortnameKey());
        jPanel5.add(MethodPanel.makeParamUnitsLabel("speedlimit", string));
        jPanel5.add(this._speedLowLimitField);
        double d = this.getDoubleValue(parameterValues, CompressionMethodType.TOO_SLOW);
        this._speedLowLimitField.setValue(this.convertSpeedToLocal(d));
        this._cardPanel.add((Component)jPanel5, CompressionMethodType.TOO_SLOW.toString());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        jPanel6.add(MethodPanel.makeParamUnitsLabel("speedlimit", string));
        jPanel6.add(this._speedHighLimitField);
        d = this.getDoubleValue(parameterValues, CompressionMethodType.TOO_FAST);
        this._speedHighLimitField.setValue(this.convertSpeedToLocal(d));
        this._cardPanel.add((Component)jPanel6, CompressionMethodType.TOO_FAST.toString());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        jPanel7.add(MethodPanel.makeParamLabel("timedifference"));
        jPanel7.add(this._timeLimitField);
        this._timeLimitField.setValue(this.getIntValue(parameterValues, CompressionMethodType.TIME_DIFFERENCE));
        this._cardPanel.add((Component)jPanel7, CompressionMethodType.TIME_DIFFERENCE.toString());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        String string2 = I18nManager.getText(this.getDistanceLimitUnits().getShortnameKey());
        jPanel8.add(MethodPanel.makeParamUnitsLabel("distancelimit", string2));
        jPanel8.add(this._distanceLimitField);
        double d2 = this.getDoubleValue(parameterValues, CompressionMethodType.NEARBY_WITH_DISTANCE);
        this._distanceLimitField.setValue(this.convertDistanceToLocal(d2));
        this._cardPanel.add((Component)jPanel8, CompressionMethodType.NEARBY_WITH_DISTANCE.toString());
        this._cardPanel.add((Component)new JPanel(), CompressionMethodType.SKI_LIFTS.toString());
    }

    private static JLabel makeParamLabel(String string) {
        return new JLabel(String.valueOf(I18nManager.getText("dialog.compress." + string + ".paramdesc")) + ":");
    }

    private static JLabel makeParamUnitsLabel(String string, String string2) {
        return new JLabel(String.valueOf(I18nManager.getText("dialog.compress." + string + ".paramdesc")) + " (" + string2 + "):");
    }

    private Unit getDistanceLimitUnits() {
        return this.isSystemMetric() ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
    }

    private Unit getSpeedLimitUnits() {
        return this.isSystemMetric() ? UnitSetLibrary.SPEED_UNITS_KMPERHOUR : UnitSetLibrary.SPEED_UNITS_MILESPERHOUR;
    }

    private int getIntValue(ParameterValues parameterValues, CompressionMethodType compressionMethodType) {
        int n = parameterValues == null ? 0 : NumberUtils.getIntOrZero(parameterValues.getValue(compressionMethodType));
        return n == 0 ? (int)this.getDoubleValue(parameterValues, compressionMethodType) : n;
    }

    private double getDoubleValue(ParameterValues parameterValues, CompressionMethodType compressionMethodType) {
        return parameterValues == null ? 0.0 : NumberUtils.getDoubleOrZero(parameterValues.getValue(compressionMethodType));
    }

    private void setupListeners() {
        this._methodCombo.addActionListener(actionEvent -> this.showCard());
        this._activeCheckbox.addItemListener(itemEvent -> this.showLabel());
        JTextField[] jTextFieldArray = new JTextField[]{this._nearbySpanField, this._douglasSpanField, this._wackyFactorField, this._singletonFactorField, this._speedLowLimitField, this._speedHighLimitField, this._distanceLimitField, this._timeLimitField};
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MethodPanel.this.triggerRefresh();
            }
        };
        JTextField[] jTextFieldArray2 = jTextFieldArray;
        int n = jTextFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            JTextField jTextField = jTextFieldArray2[n2];
            jTextField.addKeyListener(keyListener);
            ++n2;
        }
    }

    private static JPanel combineIntoPanel(JComboBox<String> jComboBox, JPanel jPanel, JLabel jLabel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(jComboBox, "West");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jLabel, "South");
        return jPanel2;
    }

    private static String[] getMethodNames() {
        String[] stringArray = new String[]{"none", "duplicates", "closepoints", "wacky", "singletons", "douglaspeucker", "distancelimit", "timelimit", "tooslow", "toofast", "skilifts"};
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = I18nManager.getText("dialog.compress.method." + stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    private static JPanel makeButtonHolder(JButton jButton) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private CompressionMethodType getSelectedMethod() {
        CompressionMethodType[] compressionMethodTypeArray = new CompressionMethodType[]{CompressionMethodType.NONE, CompressionMethodType.DUPLICATES, CompressionMethodType.NEARBY_WITH_FACTOR, CompressionMethodType.WACKY_POINTS, CompressionMethodType.SINGLETONS, CompressionMethodType.DOUGLAS_PEUCKER, CompressionMethodType.NEARBY_WITH_DISTANCE, CompressionMethodType.TIME_DIFFERENCE, CompressionMethodType.TOO_SLOW, CompressionMethodType.TOO_FAST, CompressionMethodType.SKI_LIFTS};
        return compressionMethodTypeArray[this._methodCombo.getSelectedIndex()];
    }

    private ValueExchanger getValues() {
        CompressionMethodType compressionMethodType = this.getSelectedMethod();
        boolean bl = this._activeCheckbox.isSelected();
        switch (compressionMethodType) {
            case DUPLICATES: {
                return new ValueExchanger(bl, 1, compressionMethodType, 0);
            }
            case NEARBY_WITH_FACTOR: {
                return new ValueExchanger(bl, 2, compressionMethodType, this._nearbySpanField.getValue());
            }
            case WACKY_POINTS: {
                return new ValueExchanger(bl, 3, compressionMethodType, this._wackyFactorField.getValue());
            }
            case SINGLETONS: {
                return new ValueExchanger(bl, 4, compressionMethodType, this._singletonFactorField.getValue());
            }
            case DOUGLAS_PEUCKER: {
                return new ValueExchanger(bl, 5, compressionMethodType, this._douglasSpanField.getValue());
            }
            case NEARBY_WITH_DISTANCE: {
                return new ValueExchanger(bl, 6, compressionMethodType, this._distanceLimitField.getValue());
            }
            case TIME_DIFFERENCE: {
                return new ValueExchanger(bl, 7, compressionMethodType, this._timeLimitField.getValue());
            }
            case TOO_SLOW: {
                return new ValueExchanger(bl, 8, compressionMethodType, this._speedLowLimitField.getValue());
            }
            case TOO_FAST: {
                return new ValueExchanger(bl, 9, compressionMethodType, this._speedHighLimitField.getValue());
            }
            case SKI_LIFTS: {
                return new ValueExchanger(bl, 10, compressionMethodType, 0);
            }
        }
        return new ValueExchanger();
    }

    private void applyValues(ValueExchanger valueExchanger) {
        switch (valueExchanger._type) {
            case NEARBY_WITH_FACTOR: {
                this._nearbySpanField.setValue(valueExchanger._intFactor);
                break;
            }
            case DOUGLAS_PEUCKER: {
                this._douglasSpanField.setValue(valueExchanger._intFactor);
                break;
            }
            case WACKY_POINTS: {
                this._wackyFactorField.setValue(valueExchanger._doubleFactor);
                break;
            }
            case SINGLETONS: {
                this._singletonFactorField.setValue(valueExchanger._doubleFactor);
                break;
            }
            case NEARBY_WITH_DISTANCE: {
                this._distanceLimitField.setValue(valueExchanger._doubleFactor);
                break;
            }
            case TIME_DIFFERENCE: {
                this._timeLimitField.setValue(valueExchanger._intFactor);
                break;
            }
            case TOO_SLOW: {
                this._speedLowLimitField.setValue(valueExchanger._doubleFactor);
                break;
            }
            case TOO_FAST: {
                this._speedHighLimitField.setValue(valueExchanger._doubleFactor);
                break;
            }
        }
        this._activeCheckbox.setSelected(valueExchanger._active);
        this._methodCombo.setSelectedIndex(valueExchanger._comboIndex);
        this.showCard();
    }

    public void setMethod(CompressionMethod compressionMethod) {
        int n = 0;
        switch (compressionMethod.getType()) {
            case DUPLICATES: {
                n = 1;
                break;
            }
            case NEARBY_WITH_FACTOR: {
                n = 2;
                this._nearbySpanField.setValue(NumberUtils.getIntOrZero(compressionMethod.getParam()));
                break;
            }
            case WACKY_POINTS: {
                n = 3;
                this._wackyFactorField.setValue(NumberUtils.getDoubleOrZero(compressionMethod.getParam()));
                break;
            }
            case SINGLETONS: {
                n = 4;
                this._singletonFactorField.setValue(NumberUtils.getDoubleOrZero(compressionMethod.getParam()));
                break;
            }
            case DOUGLAS_PEUCKER: {
                n = 5;
                this._douglasSpanField.setValue(NumberUtils.getIntOrZero(compressionMethod.getParam()));
                break;
            }
            case NEARBY_WITH_DISTANCE: {
                n = 6;
                double d = this.convertDistanceToLocal(NumberUtils.getDoubleOrZero(compressionMethod.getParam()));
                this._distanceLimitField.setValue(d);
                break;
            }
            case TIME_DIFFERENCE: {
                n = 7;
                this._timeLimitField.setValue(NumberUtils.getIntOrZero(compressionMethod.getParam()));
                break;
            }
            case TOO_SLOW: {
                n = 8;
                double d = this.convertSpeedToLocal(NumberUtils.getDoubleOrZero(compressionMethod.getParam()));
                this._speedLowLimitField.setValue(d);
                break;
            }
            case TOO_FAST: {
                n = 9;
                double d = this.convertSpeedToLocal(NumberUtils.getDoubleOrZero(compressionMethod.getParam()));
                this._speedHighLimitField.setValue(d);
                break;
            }
            case SKI_LIFTS: {
                n = 10;
                break;
            }
        }
        this._activeCheckbox.setSelected(compressionMethod.isActive());
        this._methodCombo.setSelectedIndex(n);
        this._numToDeleteLabel.setVisible(false);
        this.showCard();
    }

    private double convertDistanceToLocal(double d) {
        double d2 = Math.abs(d);
        if (this.isSystemMetric()) {
            return d2;
        }
        return Distance.convertBetweenUnits(d2, UnitSetLibrary.UNITS_METRES, UnitSetLibrary.UNITS_FEET);
    }

    private double convertSpeedToLocal(double d) {
        double d2 = Math.abs(d);
        if (this.isSystemMetric()) {
            return d2;
        }
        return Distance.convertBetweenUnits(d2, UnitSetLibrary.UNITS_KILOMETRES, UnitSetLibrary.UNITS_MILES);
    }

    private void showCard() {
        CompressionMethodType compressionMethodType = this.getSelectedMethod();
        this._cards.show(this._cardPanel, compressionMethodType.toString());
        this.triggerRefresh();
    }

    private void showLabel() {
        this._numToDeleteLabel.setVisible(this._activeCheckbox.isSelected());
        this.triggerRefresh();
    }

    void refresh() {
        this.showLabel();
    }

    private void triggerRefresh() {
        this._compressionMethod = null;
        if (this._parent != null) {
            this._parent.recalculateAll();
        }
    }

    boolean hasMethodSelected() {
        return this._methodCombo.getSelectedIndex() > 0;
    }

    public static void swapPanels(MethodPanel methodPanel, MethodPanel methodPanel2) {
        if (methodPanel == null || methodPanel2 == null || methodPanel == methodPanel2) {
            return;
        }
        ValueExchanger valueExchanger = methodPanel.getValues();
        ValueExchanger valueExchanger2 = methodPanel2.getValues();
        methodPanel.applyValues(valueExchanger2);
        methodPanel2.applyValues(valueExchanger);
    }

    CompressionMethod getCompressionMethod() {
        if (this._compressionMethod == null) {
            this._compressionMethod = this.createCompressionMethodFromGui();
        }
        if (this._compressionMethod != null) {
            this._compressionMethod.setActive(this._activeCheckbox.isSelected());
        }
        return this._compressionMethod;
    }

    private CompressionMethod createCompressionMethodFromGui() {
        switch (this.getSelectedMethod()) {
            case DUPLICATES: {
                return new DuplicatesMethod();
            }
            case NEARBY_WITH_FACTOR: {
                return new NearbyFactorMethod(this._nearbySpanField.getValue());
            }
            case DOUGLAS_PEUCKER: {
                return new DouglasPeuckerMethod(this._douglasSpanField.getValue());
            }
            case WACKY_POINTS: {
                return new WackyPointsMethod(this._wackyFactorField.getValue());
            }
            case SINGLETONS: {
                return new SingletonsMethod(this._singletonFactorField.getValue());
            }
            case NEARBY_WITH_DISTANCE: {
                return new NearbyDistMethod(this.getDistanceInMetres());
            }
            case TIME_DIFFERENCE: {
                return new TooSoonMethod(this._timeLimitField.getValue());
            }
            case TOO_SLOW: {
                return new TooSlowMethod(this.getSpeedLimitMetric(this._speedLowLimitField.getValue()));
            }
            case TOO_FAST: {
                return new TooFastMethod(this.getSpeedLimitMetric(this._speedHighLimitField.getValue()));
            }
            case SKI_LIFTS: {
                return new SkiLiftsMethod();
            }
        }
        return null;
    }

    private double getDistanceInMetres() {
        double d = Math.abs(this._distanceLimitField.getValue());
        if (this.isSystemMetric()) {
            return d;
        }
        return Distance.convertBetweenUnits(d, UnitSetLibrary.UNITS_FEET, UnitSetLibrary.UNITS_METRES);
    }

    private double getSpeedLimitMetric(double d) {
        if (this.isSystemMetric()) {
            return d;
        }
        return Distance.convertBetweenUnits(d, UnitSetLibrary.UNITS_MILES, UnitSetLibrary.UNITS_KILOMETRES);
    }

    public void showNumDeleted(int n) {
        this._numToDeleteLabel.setText(String.valueOf(I18nManager.getText("dialog.compress.panel.deletes")) + ": " + n);
    }

    private boolean isSystemMetric() {
        return this._config == null || this._config.getUnitSet().isMetric();
    }

    private static class ValueExchanger {
        private final boolean _active;
        private final int _comboIndex;
        private final int _intFactor;
        private final double _doubleFactor;
        private final CompressionMethodType _type;

        private ValueExchanger() {
            this(true, 0, CompressionMethodType.NONE, 0);
        }

        private ValueExchanger(boolean bl, int n, CompressionMethodType compressionMethodType, int n2) {
            this._active = bl;
            this._comboIndex = n;
            this._type = compressionMethodType;
            this._intFactor = n2;
            this._doubleFactor = 0.0;
        }

        private ValueExchanger(boolean bl, int n, CompressionMethodType compressionMethodType, double d) {
            this._active = bl;
            this._comboIndex = n;
            this._type = compressionMethodType;
            this._intFactor = 0;
            this._doubleFactor = d;
        }
    }
}

