---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロファイルの設定
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

設定を更新することで、GitLabのルックアンドフィールを変更できます。

## 配色テーマを変更する

GitLab UIの配色テーマを変更できます。これらの色は左側のサイドバーに表示されます。個別の配色テーマを使用すると、異なるGitLabインスタンスを区別しやすくなります。

配色テーマを変更するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **配色テーマ**セクションで、テーマを選択します。

### ダークモード

{{< history >}}

- GitLab 13.1で[実験](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/28252)として[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/28252)されました。

{{< /history >}}

ダークモードでは、GitLab UIの要素が暗い背景の中で目立つようになります。

- ダークモードをオンにするには、**設定＞配色テーマ＞ダークモード**を選択します。

すべての構文のハイライト表示のテーマでダークモードを使用できます。[エピック2092](https://gitlab.com/groups/gitlab-org/-/epics/2902)で、イシューの報告と表示、フィードバックの送信、進捗状況の追跡ができます。

## 構文のハイライト表示のテーマを変更する

{{< history >}}

- GitLab 15.1で、認証済みユーザーおよび未認証のユーザーに対する構文のハイライト表示のデフォルトテーマの変更が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/25129)されました。

{{< /history >}}

構文のハイライト表示は、コードエディタやIDEの機能です。構文ハイライターは、文字列やコメントなど、コードの各タイプに応じて色を割り当てる機能です。

構文のハイライト表示のテーマを変更するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **構文のハイライト表示のテーマ**セクションで、テーマを選択します。
1. **変更の保存**を選択します。

更新された構文のハイライト表示のテーマで表示するには、プロジェクトのページを更新します。

構文のハイライト表示のテーマは、[アプリケーション設定APIを使用](../../api/settings.md#available-settings)してカスタマイズすることもできます。`default_syntax_highlighting_theme`を使用すると、よりきめ細かく構文のハイライト色を変更できます。

これらの手順でうまくいかない場合は、ご使用のプログラミング言語が構文ハイライターでサポートされていない可能性があります。詳細については、[Rouge Rubyライブラリ](https://github.com/rouge-ruby/rouge)のコードファイルとスニペットのガイダンスを参照してください。Web IDEのガイダンスについては、[Monaco Editor](https://microsoft.github.io/monaco-editor/)と[Monarch](https://microsoft.github.io/monaco-editor/monarch.html)を参照してください。

## 差分の表示色を変更する

差分では、コードのバージョン間の変更を、2つの異なる背景色で表示します。デフォルトでは、元のファイルは赤色、変更箇所は緑色で表示されます。

差分の表示色を変更するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **差分の表示色**セクションに移動します。
1. 色を選択するか、カラーコードを入力します。
1. **変更の保存**を選択します。

デフォルトの色に戻すには、**消去された行の色**と**追加された行の色**のテキストボックスをクリアし、**変更の保存**を選択します。

## 動作

**動作**セクションを使用して、システムレイアウトとデフォルトビューの動作をカスタマイズできます。レイアウトの幅の変更、ホームページ、グループ、プロジェクトの概要ページのデフォルトコンテンツの選択が可能です。また、空白のレンダリング、ファイルの表示、テキストの自動化など、外観や機能をカスタマイズするオプションもあります。

### UIにおけるレイアウトの幅を変更する

GitLab UIのコンテンツをページ全体に拡大表示できます。デフォルトでは、ページコンテンツの幅は1280ピクセルに設定されています。

UIのレイアウトの幅を変更するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **レイアウトの幅**で、**固定**または**可変**を選択します。
1. **変更の保存**を選択します。

### デフォルトのテキストエディタを設定する

{{< history >}}

- GitLab 17.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/423104)されました。

{{< /history >}}

GitLabでコンテンツを編集するためのデフォルトのエディタを設定できます。デフォルトのテキストエディタを選択しない場合、最後に使用した選択が保持されます。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **デフォルトテキストエディタ**で、**デフォルトテキストエディタを有効にする**チェックボックスをオンにします。
1. デフォルトとして、**リッチテキストエディタ**または**プレーンテキストエディタ**を選択します。
1. **変更の保存**を選択します。

### メイン組織を選択する

{{< history >}}

- GitLab 16.6で`ui_for_organizations`[フラグ](../../administration/feature_flags.md)とともに[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/419079)。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については履歴を参照してください。GitLab.comとGitLab Dedicatedでは、この機能は使用できません。この機能は本番環境での使用には対応していません。

{{< /alert >}}

2つ以上の[組織](../organization/_index.md)のメンバーである場合は、メイン組織を選択できます。これは、最初にGitLabにサインインするときにデフォルトで所属する組織です。

メイン組織を選択するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **メイン組織**ドロップダウンリストから、メインにする組織を選択します。
1. **変更の保存**を選択します。

### ホームページを選択する

{{< history >}}

- GitLab 17.9で、`your_work_projects_vue`[フラグ](../../administration/feature_flags.md)とともに[ホームページのオプションが変更されました](https://gitlab.com/groups/gitlab-org/-/epics/13066)。デフォルトでは無効になっています。
- GitLab 17.10で、[ホームページのオプションの変更](https://gitlab.com/gitlab-org/gitlab/-/issues/465889)が一般提供になりました。機能フラグ`your_work_projects_vue`は削除されました。

{{< /history >}}

GitLabロゴ（{{< icon name="tanuki" >}}）を選択したときに表示するページを制御できます。ホームページを「コントリビュートしたプロジェクト」（デフォルト）、「グループ」、「アクティビティ」、またはその他のコンテンツに設定できます。

表示するホームページを選択するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **ホームページ**ドロップダウンリストから、ホームページにするページを選択します。
1. **変更の保存**を選択します。

### グループの概要ページのデフォルトコンテンツをカスタマイズする

グループの概要ページのメインコンテンツを変更できます。グループの概要ページは、左側のサイドバーで**グループ**を選択したときに表示されるページです。グループの概要ページのデフォルトコンテンツを次のようにカスタマイズできます。

- 詳細ダッシュボード（デフォルト）。グループのアクティビティとプロジェクトの概要が含まれます。
- セキュリティダッシュボード。グループのセキュリティポリシーやその他のセキュリティトピックが含まれます。

詳細については、[グループ](../group/_index.md)を参照してください。

グループの概要ページのデフォルトコンテンツを変更するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **グループ概要の内容**ドロップダウンリストから、オプションを選択します。
1. **変更の保存**を選択します。

### プロジェクトの概要ページのデフォルトコンテンツをカスタマイズする

プロジェクトの概要ページは、左側のサイドバーで**プロジェクトの概要**を選択したときに表示されるページです。メインプロジェクトの概要ページを「アクティビティ」ページ、READMEファイル、またはその他のコンテンツに設定できます。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **プロジェクト概要の内容**ドロップダウンリストから、オプションを選択します。
1. **変更の保存**を選択します。

### ショートカットボタンを非表示にする

ショートカットボタンは、プロジェクトの概要ページのファイルリストの前に表示されます。これらのボタンは、READMEファイルやライセンス契約など、プロジェクトに関連するコンテンツへのリンクを提供します。

プロジェクトの概要ページでショートカットボタンを非表示にするには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **プロジェクトの概要でファイルの上にショートカットボタンを表示する**チェックボックスをオフにします。
1. **変更の保存**を選択します。

### Web IDEでホワイトスペースを表示する

ホワイトスペースとは、スペースやインデントなど、テキスト内の空白文字のことです。コード内のコンテンツを構造化するために、ホワイトスペースが使用される場合があります。プログラミング言語がホワイトスペースの影響を受ける場合、Web IDEはホワイトスペースに対する変更を検出します。

Web IDEでホワイトスペースをレンダリングするには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **Web IDEでホワイトスペースをレンダリング**チェックボックスをオンにします。
1. **変更の保存**を選択します。

差分でホワイトスペースへの変更を表示できます。

Web IDEで差分を表示するには、次の手順に従います。

1. 左側のサイドバーで、**ソース管理**（{{< icon name="branch" >}}）を選択します。
1. **変更**タブで、ファイルを選択します。

### 差分でホワイトスペースの変更を表示する

差分でホワイトスペースに対する変更を表示できます。ホワイトスペースの詳細については、前のタスクを参照してください。

差分でホワイトスペースに対する変更を表示するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **空白を含めたちがいを表示する**チェックボックスをオンにします。
1. **変更の保存**を選択します。

差分の詳細については、[差分の表示色を変更する](#change-the-diff-colors)を参照してください。

### マージリクエストで1ページに1つのファイルを表示する

**変更**タブでは、マージリクエスト内のすべてのファイルの変更を1つのページで表示できます。あるいは、1ページに1つのファイルを表示することもできます。

**変更**タブに1ページに1つのファイルを表示するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **マージリクエストの変更タブに一度に1つのファイルを表示する**チェックボックスをオンにします。
1. **変更の保存**を選択します。

この場合、**変更**タブ内でファイル間を移動するには、各ファイルの下にある**前ページ**ボタンまたは**次ページ**ボタンを選択します。

### 文字の自動囲み

開始囲み文字を入力すると、対応する終了囲み文字がテキストに自動的に追加されます。たとえば、開始括弧を入力すると、終了括弧が自動的に挿入されます。この設定は、説明ボックスとコメントボックスでのみ有効であり、次の文字に対して有効です: `**"`、`'`、\`\`\`、`(`、`[`、`{`、`<`、`*`、`_**`

説明ボックスとコメントボックスで文字を自動的に囲むには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **引用符または括弧を入力するときにテキスト選択を囲む**チェックボックスをオンにします。
1. **変更の保存**を選択します。

これで、説明ボックスまたはコメントボックスで、単語を入力し、それをハイライト表示して、開始囲み文字を入力できるようになります。テキストを置き換える代わりに、終了囲み文字が末尾に追加されます。

### 新しいリスト項目を自動作成する

説明ボックスとコメントボックスのリストで<kbd>Enter</kbd>キーを押すことで、新しいリスト項目を作成できます。

<kbd>Enter</kbd>キーを押したときに新しいリスト項目を追加するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **新しいリスト項目を自動的に追加する**チェックボックスをオンにします。
1. **変更の保存**を選択します。

### タブの幅を変更する

差分、blob、およびスニペットのタブのデフォルトサイズを変更できます。ただし、Web IDE、ファイルエディタ、およびMarkdownエディタは、この機能をサポートしていません。

デフォルトのタブ幅を調整するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールします。
1. **タブ幅**に値を入力します。
1. **変更の保存**を選択します。

## ローカライゼーション

言語、カレンダーの開始日、時刻設定など、ローカライゼーション設定を変更します。

### GitLab UIで表示言語を変更する

GitLabのUIは複数の言語をサポートしています。翻訳の改善に協力したり、リストにない言語のサポートをリクエストしたりするには、[GitLabの翻訳](../../development/i18n/translation.md)を参照してください。

GitLab UIの言語を選択するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **ローカライズ**セクションに移動します。
1. **言語**で、使用する言語を選択します。
1. **変更の保存**を選択します。

選択した言語で表示するには、ページを更新する必要がある場合があります。

### コントリビューションカレンダーの開始日をカスタマイズする

コントリビューションカレンダーを開始する曜日を選択できます。コントリビューションカレンダーには、過去1年間のプロジェクトへのコントリビューションが表示されます。このカレンダーは、各ユーザーのプロファイルで表示できます。ユーザープロファイルにアクセスするには:

- 左側のサイドバーで、自分のアバターを選択し、名前またはユーザー名を選択します。

コントリビューションカレンダーの開始曜日を変更するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **ローカライズ**セクションに移動します。
1. **週始めの曜日**で、開始曜日を選択します。
1. **変更の保存**を選択します。

カレンダーの開始曜日を変更した後、ユーザープロファイルページを更新します。

### 相対時間の代わりに正確な時刻を表示する

グループ、プロジェクトの概要ページ、およびユーザープロファイルの活動時刻の表示形式をカスタマイズできます。時刻の表示形式は次のいずれかを選択できます。

- 相対形式（例: `30 minutes ago`）。
- 絶対形式（例: `September 3, 2022, 3:57 PM`）。

GitLab UIで正確な時刻を表示するには、次の手順に従います。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **時間設定**セクションに移動します。
1. **相対時間を使用する**チェックボックスをオフにします。
1. **変更の保存**を選択します。

### 時刻形式をカスタマイズする

{{< history >}}

- GitLab 16.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/15206)されました。

{{< /history >}}

グループ、プロジェクトの概要ページ、およびユーザープロファイルの活動時刻の表示形式はカスタマイズできます。時刻は次の形式で表示できます。

- 12時間形式。例: `2:34 PM`
- 24時間形式。例: `14:34`

システムの設定に従うこともできます。

時刻形式をカスタマイズするには、次の手順に従います。

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **時間設定**セクションに移動します。
1. **時間フォーマット**で、**システム**、**12時間**、または**24時間**オプションを選択します。
1. **変更の保存**を選択します。

## 完全一致コードの検索を無効にする

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed
- ステータス: ベータ

{{< /details >}}

{{< history >}}

- GitLab 15.9で、`index_code_with_zoekt`と`search_code_with_zoekt`という[フラグ](../../administration/feature_flags.md)とともに[ベータ](../../policy/development_stages_support.md#beta)として[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105049)されました。デフォルトでは無効になっています。
- GitLab 16.6の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/388519)になりました。
- GitLab 17.1で、機能フラグ`index_code_with_zoekt`、`search_code_with_zoekt`は[削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148378)されました。

{{< /history >}}

{{< alert type="warning" >}}

この機能は[ベータ](../../policy/development_stages_support.md#beta)版であり、予告なく変更される場合があります。詳細については、[エピック9404](https://gitlab.com/groups/gitlab-org/-/epics/9404)を参照してください。

{{< /alert >}}

前提要件:

- [GitLab Self-Managed](../../subscriptions/self_managed/_index.md)の場合、[管理者](../../integration/exact_code_search/zoekt.md#enable-exact-code-search)が完全一致コードの検索を有効にする必要があります。

ユーザー設定で[完全一致コードの検索](../search/exact_code_search.md)を無効にするには：

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **完全一致コードの検索**セクションに移動します。
1. **完全一致コード検索を有効にする**チェックボックスをオフにします。
1. **変更の保存**を選択します。

## CIジョブのJSON Web TokenにおけるユーザーID

{{< history >}}

- GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/387537)されました。

{{< /history >}}

CI/CDジョブは、JSON Web Tokenを生成します。これには外部IDのリストを含めることができます。個々のアカウントを取得するために個別のAPIコールを行う代わりに、1つの認証トークンでユーザーIDを確認できます。

デフォルトでは、外部IDは含まれていません。外部IDを含めるようにするには、[トークンのペイロード](../../ci/secrets/id_token_authentication.md#token-payload)を参照してください。

## フォロワーのエンゲージメントを制御する

{{< history >}}

- GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/325558)されました。

{{< /history >}}

他のGitLabユーザーをフォローしたり、フォローされたりする機能をオフにします。デフォルトでは、名前とプロファイル写真を含むユーザープロファイルは、他のユーザーの**フォロー**タブで公開されています。この設定を無効にすると：

- GitLabは、すべてのフォロワーとフォローされている接続を削除します。
- GitLabは、各接続のページからユーザープロファイルを自動的に削除します。

他のユーザーにフォローされたり、フォローしたりする機能を削除するには：

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **ユーザーのフォローを有効にする**チェックボックスをオフにします。
1. **変更の保存**を選択します。

**フォロワー**タブと**フォロー**タブにアクセスするには：

- 左側のサイドバーで、自分のアバターを選択し、名前またはユーザー名を選択します。
- **フォロワー**または**フォロー**を選択します。

## GitLabインスタンスをサードパーティサービスと統合する

サードパーティサービスにアクセス権を付与して、GitLabエクスペリエンスを向上させることができます。

### GitLabインスタンスをGitpodと統合する

GitLabブラウザから直接コードを起動および管理したい場合は、GitLabインスタンスをGitpodで設定します。Gitpodは、プロジェクトの開発環境を自動的に準備し、構築します。

Gitpodと統合するには：

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **インテグレーション**セクションを見つけます。
1. **Gitpod統合を有効にする**チェックボックスをオンにします。
1. **変更の保存**を選択します。

### GitLabインスタンスをSourcegraphと統合する

GitLabは、GitLab上のすべての公開プロジェクトに対してSourcegraph統合をサポートしています。

Sourcegraphと統合するには：

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **インテグレーション**セクションを見つけます。
1. **コードビューでコードインテリジェンスを有効にする**チェックボックスをオンにします。
1. **変更の保存**を選択します。

Sourcegraphとの統合のためにGitLabを設定するには、GitLabインスタンスの管理者である必要があります。

### 拡張機能マーケットプレースと連携する

{{< details >}}

- 提供形態: GitLab.com

{{< /details >}}

{{< history >}}

- GitLab 17.0で、`web_ide_oauth`と`web_ide_extensions_marketplace`という[フラグ](../../administration/feature_flags.md)とともに[ベータ](../../policy/development_stages_support.md#beta)として[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161819)されました。デフォルトでは無効になっています。
- `web_ide_oauth`は、GitLab 17.4の[GitLab.com、GitLab Self-Managed、GitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163181)になりました。
- `web_ide_extensions_marketplace`は、GitLab 17.4の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/459028)になりました。
- `web_ide_oauth`は、GitLab 17.5で[削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167464)されました。
- GitLab 17.6で、[ワークスペース](../workspace/_index.md)に対してデフォルトで有効になりました。ワークスペースでは、拡張機能マーケットプレースを利用するために機能フラグは必要ありません。
- GitLab 17.10で`vscode_extension_marketplace_settings`[機能フラグ](../../administration/feature_flags.md)を[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/508996)しました。デフォルトでは無効になっています。
- `web_ide_extensions_marketplace`と`vscode_extension_marketplace_settings`は、GitLab 17.11の[GitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/459028)になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

[拡張機能マーケットプレース](../project/web_ide/_index.md#extension-marketplace)を使用して、[Web IDE](../project/web_ide/_index.md)および[ワークスペース](../workspace/_index.md)の拡張機能を検索および管理できます。サードパーティの拡張機能については、ユーザー設定でマーケットプレースを有効にする必要があります。

前提要件:

- **管理者**エリアで、GitLab管理者が[拡張機能マーケットプレースを有効にする](../../administration/settings/vscode_extension_marketplace.md)必要があります。

Web IDEおよびワークスペースの拡張機能マーケットプレースを有効にするには：

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **インテグレーション**セクションに移動します。
1. **拡張機能マーケットプレースを有効にする**チェックボックスをオンにします。
1. サードパーティの拡張機能の使用許諾契約で、**わかりました**を選択します。
1. **変更の保存**を選択します。

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, for example `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
