/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.app.events.CloseProgramPluginEvent;
import ghidra.app.events.OpenProgramPluginEvent;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramPostActivatedPluginEvent;
import ghidra.app.events.ProgramVisibilityChangePluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.progmgr.ProgramLocator;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.app.plugin.core.progmgr.TransactionMonitor;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Component;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;

class MultiProgramManager
implements TransactionListener {
    private ProgramManagerPlugin plugin;
    private PluginTool tool;
    private ProgramInfo currentInfo;
    private TransactionMonitor txMonitor;
    private Runnable programChangedRunnable;
    private boolean hasUnsavedPrograms;
    private String pluginName;
    private Map<Program, ProgramInfo> programMap = new ConcurrentHashMap<Program, ProgramInfo>();
    private DomainObjectListener domainObjectListener = this.createDomainObjectListener();

    MultiProgramManager(ProgramManagerPlugin programManagerPlugin) {
        this.plugin = programManagerPlugin;
        this.tool = programManagerPlugin.getTool();
        this.pluginName = this.plugin.getName();
        this.txMonitor = new TransactionMonitor();
        this.txMonitor.setName("Transaction Open (Program being modified)");
        this.tool.addStatusComponent((JComponent)this.txMonitor, true, true);
        this.programChangedRunnable = () -> {
            if (this.tool == null) {
                return;
            }
            this.hasUnsavedPrograms = this.checkForUnsavedPrograms();
            this.plugin.contextChanged();
        };
    }

    void addProgram(Program p, ProgramLocator locator, int state) {
        this.addProgram(new ProgramInfo(p, locator, state != 0), state);
    }

    private void addProgram(ProgramInfo programInfo, int state) {
        Program p = programInfo.program;
        ProgramInfo oldInfo = this.getInfo(p);
        if (oldInfo == null) {
            oldInfo = programInfo;
            p.addConsumer((Object)this.tool);
            this.programMap.put(p, oldInfo);
            this.fireOpenEvents(p);
            p.addListener(this.domainObjectListener);
            p.addTransactionListener((TransactionListener)this);
        } else if (!oldInfo.visible && state != 0) {
            oldInfo.setVisible(true);
        }
        if (state == 1) {
            this.saveLocation();
            this.setCurrentProgram(p);
        }
    }

    void dispose() {
        this.fireActivatedEvent(null);
        for (Program p : this.programMap.keySet()) {
            p.removeListener(this.domainObjectListener);
            p.removeTransactionListener((TransactionListener)this);
            this.fireCloseEvents(p);
            p.release((Object)this.tool);
        }
        this.programMap.clear();
        this.tool.setSubTitle("");
        this.tool.removeStatusComponent((JComponent)this.txMonitor);
        this.tool = null;
        this.plugin = null;
    }

    void removeProgram(Program p) {
        ProgramInfo info = this.getInfo(p);
        if (info == null) {
            return;
        }
        if (info.owner != null) {
            info.setVisible(false);
            if (info == this.currentInfo) {
                ProgramInfo newCurrent = this.findNextCurrent();
                this.setCurrentProgram(newCurrent);
            }
        } else {
            p.removeTransactionListener((TransactionListener)this);
            this.programMap.remove(p);
            p.removeListener(this.domainObjectListener);
            if (info == this.currentInfo) {
                ProgramInfo newCurrent = this.findNextCurrent();
                this.setCurrentProgram(newCurrent);
            }
            this.fireCloseEvents(p);
            p.release((Object)this.tool);
            if (this.programMap.isEmpty()) {
                this.plugin.getTool().clearLastEvents();
            }
        }
    }

    private ProgramInfo findNextCurrent() {
        for (ProgramInfo pi : this.getSortedProgramInfos()) {
            if (!pi.visible) continue;
            return pi;
        }
        return null;
    }

    List<Program> getOtherPrograms() {
        ArrayList<Program> otherPrograms = new ArrayList<Program>(this.programMap.keySet());
        otherPrograms.remove(this.getCurrentProgram());
        return otherPrograms;
    }

    List<Program> getAllPrograms() {
        List<ProgramInfo> sorted = this.getSortedProgramInfos();
        return sorted.stream().map(info -> info.program).collect(Collectors.toList());
    }

    Program getCurrentProgram() {
        if (this.currentInfo != null) {
            return this.currentInfo.program;
        }
        return null;
    }

    void setCurrentProgram(Program p) {
        if (this.currentInfo != null && this.currentInfo.program.equals((Object)p)) {
            return;
        }
        if (p == null) {
            return;
        }
        ProgramInfo info = this.getInfo(p);
        if (info != null) {
            this.setCurrentProgram(info);
        }
    }

    Program getProgram(Address addr) {
        for (ProgramInfo pi : this.getSortedProgramInfos()) {
            if (!pi.program.getMemory().contains(addr)) continue;
            return pi.program;
        }
        return null;
    }

    void saveLocation() {
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (historyService == null) {
            return;
        }
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService == null) {
            return;
        }
        Navigatable defaultNavigatable = gotoService.getDefaultNavigatable();
        if (defaultNavigatable == null || defaultNavigatable.getProgram() == null) {
            return;
        }
        historyService.addNewLocation(defaultNavigatable);
    }

    private List<ProgramInfo> getSortedProgramInfos() {
        ArrayList<ProgramInfo> list = new ArrayList<ProgramInfo>(this.programMap.values());
        Collections.sort(list);
        return list;
    }

    private void setCurrentProgram(ProgramInfo info) {
        Program newProgram;
        if (this.currentInfo == info) {
            return;
        }
        Program program = newProgram = info == null ? null : info.program;
        if (this.currentInfo != null) {
            this.currentInfo.lastState = this.tool.getTransientState();
            this.tool.setSubTitle("");
            this.txMonitor.setProgram(null);
        }
        this.currentInfo = info;
        TransientToolState toolState = null;
        if (this.currentInfo != null) {
            this.currentInfo.setVisible(true);
            this.tool.setSubTitle(this.currentInfo.toString());
            this.txMonitor.setProgram(this.currentInfo.program);
            if (this.currentInfo.lastState != null) {
                toolState = this.currentInfo.lastState;
            }
        }
        this.fireActivatedEvent(newProgram);
        if (toolState != null) {
            toolState.restoreTool();
        }
        if (newProgram != null) {
            this.firePostActivatedEvent(newProgram);
        }
    }

    private void fireOpenEvents(Program program) {
        this.plugin.firePluginEvent(new ProgramOpenedPluginEvent(this.pluginName, program));
        this.plugin.firePluginEvent(new OpenProgramPluginEvent(this.pluginName, program));
    }

    private void fireCloseEvents(Program program) {
        this.plugin.firePluginEvent(new ProgramClosedPluginEvent(this.pluginName, program));
        this.plugin.firePluginEvent(new CloseProgramPluginEvent(this.pluginName, program, true));
    }

    private void fireActivatedEvent(Program newProgram) {
        this.plugin.firePluginEvent(new ProgramActivatedPluginEvent(this.pluginName, newProgram));
    }

    private void firePostActivatedEvent(Program newProgram) {
        this.plugin.firePluginEvent(new ProgramPostActivatedPluginEvent(this.pluginName, newProgram));
    }

    private void fireVisibilityChangeEvent(Program program, boolean isVisible) {
        this.plugin.firePluginEvent(new ProgramVisibilityChangePluginEvent(this.pluginName, program, isVisible));
    }

    DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).any(new EventType[]{DomainObjectEvent.ERROR}).terminate(this::handleError)).each(new EventType[]{DomainObjectEvent.FILE_CHANGED}).call(this::handleFileChanged)).build();
    }

    private void handleError(DomainObjectChangedEvent event) {
        DomainObjectChangeRecord rec = event.findFirst((EventType)DomainObjectEvent.ERROR);
        Object object = event.getSource();
        if (object instanceof Program) {
            Program program = (Program)object;
            String msg = this.getErrorMessage(program, (Throwable)rec.getNewValue());
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Severe Error Condition", (Object)msg);
            this.removeProgram(program);
        }
    }

    private void handleFileChanged(DomainObjectChangedEvent event, DomainObjectChangeRecord rec) {
        Object object = event.getSource();
        if (object instanceof Program) {
            Program program = (Program)object;
            ProgramInfo info = this.getInfo(program);
            if (info != null) {
                info.programSavedAs();
            }
            if (this.currentInfo != null && this.currentInfo.program == program) {
                String name = program.getDomainFile().toString();
                this.tool.setSubTitle(name);
            }
        }
    }

    private String getErrorMessage(Program program, Throwable t) {
        if (t instanceof NoSuchObjectException) {
            return program.getName() + " was closed due to an unrecoverable error!\nThis error could be the result of your computer becoming suspended\nor sleeping allowing the network connection with the Ghidra Server\nto fail.";
        }
        return program.getName() + " was closed due to an unrecoverable error!\n \nSuch failures are generally due to an IO Error caused\nby the local filesystem or server.";
    }

    public boolean isEmpty() {
        return this.programMap.isEmpty();
    }

    public boolean contains(Program p) {
        if (p == null) {
            return false;
        }
        return this.programMap.containsKey(p);
    }

    boolean isVisible(Program p) {
        ProgramInfo info = this.getInfo(p);
        return info != null ? info.visible : false;
    }

    void releaseProgram(Program program, Object owner) {
        ProgramInfo info = this.getInfo(program);
        if (info != null && info.owner == owner) {
            info.owner = null;
            if (!info.visible) {
                if (program.isChanged()) {
                    info.setVisible(true);
                }
                this.plugin.closeProgram(program, false);
            } else if (program.isTemporary()) {
                this.plugin.closeProgram(program, false);
            }
        }
    }

    boolean setPersistentOwner(Program program, Object owner) {
        ProgramInfo info = this.getInfo(program);
        if (info != null && info.owner == null) {
            info.owner = owner;
            return true;
        }
        return false;
    }

    boolean isPersistent(Program p) {
        ProgramInfo info = this.getInfo(p);
        return info != null && info.owner != null;
    }

    ProgramInfo getInfo(Program p) {
        if (p == null) {
            return null;
        }
        return this.programMap.get(p);
    }

    Program getOpenProgram(ProgramLocator programLocator) {
        for (ProgramInfo info : this.programMap.values()) {
            if (!info.getProgramLocator().equals(programLocator)) continue;
            return info.program;
        }
        return null;
    }

    boolean hasUnsavedPrograms() {
        return this.hasUnsavedPrograms;
    }

    private boolean checkForUnsavedPrograms() {
        Program currentProgram = this.getCurrentProgram();
        if (currentProgram != null && currentProgram.isChanged()) {
            return true;
        }
        for (ProgramInfo programInfo : this.programMap.values()) {
            if (!programInfo.program.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void transactionEnded(DomainObjectAdapterDB domainObj) {
    }

    public void transactionStarted(DomainObjectAdapterDB domainObj, TransactionInfo tx) {
    }

    public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
    }

    public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        Swing.runLater((Runnable)this.programChangedRunnable);
    }

    class ProgramInfo
    implements Comparable<ProgramInfo> {
        private static final AtomicInteger nextAvailableId = new AtomicInteger();
        public final Program program;
        public ProgramLocator programLocator;
        private TransientToolState lastState;
        private int instance;
        private boolean visible = false;
        private Object owner;
        private String displayName;

        ProgramInfo(Program p, ProgramLocator programLocator, boolean visible) {
            this.program = p;
            this.programLocator = programLocator;
            this.visible = visible;
            this.instance = nextAvailableId.incrementAndGet();
        }

        ProgramLocator getProgramLocator() {
            return this.programLocator;
        }

        void programSavedAs() {
            this.programLocator = new ProgramLocator(this.program.getDomainFile());
            this.displayName = null;
        }

        public void setVisible(boolean state) {
            this.visible = state;
            MultiProgramManager.this.fireVisibilityChangeEvent(this.program, this.visible);
        }

        @Override
        public int compareTo(ProgramInfo info) {
            return this.instance - info.instance;
        }

        public String toString() {
            if (this.displayName != null) {
                return this.displayName;
            }
            StringBuilder buf = new StringBuilder();
            DomainFile df = this.program.getDomainFile();
            buf.append(this.program.getDomainFile().toString());
            if (df.isReadOnly()) {
                buf.append(" [Read-Only]");
            }
            this.displayName = buf.toString();
            return this.displayName;
        }

        public boolean canReopen() {
            return this.programLocator.canReopen();
        }
    }
}

