/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.plugin.core.reloc.ElfRelocationFixupHandler;
import ghidra.app.util.bin.format.elf.relocation.X86_64_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class Elfx86_64bitRelocationFixupHandler
extends ElfRelocationFixupHandler {
    public Elfx86_64bitRelocationFixupHandler() {
        super(X86_64_ElfRelocationType.class);
    }

    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        if (relocation.getStatus() != Relocation.Status.APPLIED) {
            return false;
        }
        X86_64_ElfRelocationType type = (X86_64_ElfRelocationType)this.getRelocationType(relocation.getType());
        if (type == null) {
            return false;
        }
        switch (type) {
            case R_X86_64_COPY: 
            case R_X86_64_64: 
            case R_X86_64_RELATIVE: 
            case R_X86_64_RELATIVE64: 
            case R_X86_64_GLOB_DAT: 
            case R_X86_64_JUMP_SLOT: 
            case R_X86_64_GOTPCREL64: 
            case R_X86_64_IRELATIVE: {
                return this.process64BitRelocation(program, relocation, oldImageBase, newImageBase);
            }
        }
        return false;
    }

    public boolean handlesProgram(Program program) {
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 64) {
            return false;
        }
        Processor processor = language.getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"));
    }
}

