/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.builder.GraphTypeBuilder;

public class DFSCycleRemoval<V, E> {
    private Graph<V, E> graph;
    Collection<E> edges;
    Set<V> marked = new HashSet<V>();
    Stack<V> stack = new Stack();
    Set<E> feedbackArcs = new HashSet();
    Predicate<E> edgePredicate;
    Comparator<V> comparator;

    public DFSCycleRemoval(Graph<V, E> graph) {
        this(graph, (v1, v2) -> 0);
    }

    public DFSCycleRemoval(Graph<V, E> graph, Comparator<V> comparator) {
        this.graph = GraphTypeBuilder.forGraph(graph).buildGraph();
        Graphs.addGraph(this.graph, graph);
        this.edges = graph.edgeSet();
        this.comparator = comparator;
        this.removeCycles();
    }

    public void removeCycles() {
        List vertices = this.graph.vertexSet().stream().sorted(this.comparator).collect(Collectors.toList());
        for (Object vertex : vertices) {
            this.dfsRemove(vertex);
        }
    }

    public void setEdgePredicate(Predicate<E> edgePredicate) {
        this.edgePredicate = edgePredicate;
    }

    private void dfsRemove(V vertex) {
        if (this.marked.contains(vertex)) {
            return;
        }
        this.marked.add(vertex);
        this.stack.add(vertex);
        List outgoingEdges = this.graph.outgoingEdgesOf(vertex).stream().collect(Collectors.toList());
        for (Object edge : outgoingEdges) {
            Object target = this.graph.getEdgeTarget(edge);
            if (this.stack.contains(target)) {
                this.graph.removeEdge(edge);
                this.feedbackArcs.add(edge);
                continue;
            }
            if (this.marked.contains(target)) continue;
            this.dfsRemove(target);
        }
        this.stack.remove(vertex);
    }

    public Collection<E> getFeedbackArcs() {
        return this.feedbackArcs;
    }
}

