/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.address;

import ghidra.pcodeCPort.address.AddressUtils;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.utils.AddrSpaceToIdSymmetryMap;
import java.io.PrintStream;

public class Address
implements Comparable<Address> {
    private AddrSpace base;
    private long offset;

    public Address() {
        this.base = AddrSpace.MIN_SPACE;
    }

    public Address(AddrSpace id, long off) {
        this.base = id;
        this.offset = off;
    }

    public Address(Address addr) {
        this.base = addr.base;
        this.offset = addr.offset;
    }

    public boolean isInvalid() {
        return this.base == AddrSpace.MIN_SPACE || this.base == AddrSpace.MAX_SPACE;
    }

    void setOffset(long o) {
        this.offset = o;
    }

    public int getAddrSize() {
        return this.base.getAddrSize();
    }

    public boolean isBigEndian() {
        return this.base.isBigEndian();
    }

    void printOffset(PrintStream s) {
        this.base.printOffset(s, this.offset);
    }

    public int printRaw(PrintStream s) {
        return this.base.printRaw(s, this.offset);
    }

    public void toPhysical() {
        AddrSpace phys = this.base.getContain();
        if (phys != null && this.base.getType() == spacetype.IPTR_SPACEBASE) {
            this.base = phys;
        }
    }

    public String toString() {
        return this.base.getName() + ":0x" + this.base.toString(this.offset);
    }

    public String toString(boolean showAddressSpace) {
        if (showAddressSpace) {
            return this.base.getName() + ":0x" + this.base.toString(this.offset);
        }
        return "0x" + this.base.toString(this.offset);
    }

    public AddrSpace getSpace() {
        return this.base;
    }

    public long getOffset() {
        return this.offset;
    }

    public char getShortcut() {
        return this.base.getShortCut();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Address)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Address other = (Address)obj;
        return this.base == other.base && this.offset == other.offset;
    }

    @Override
    public int compareTo(Address other) {
        int result = this.base.compareTo(other.base);
        if (result != 0) {
            return result;
        }
        return AddressUtils.unsignedCompare(this.offset, other.offset);
    }

    public Address add(long off) {
        return new Address(this.base, this.offset + off & this.base.getMask());
    }

    public Address subtract(long off) {
        return this.sub(off);
    }

    public Address sub(long off) {
        return new Address(this.base, this.offset - off & this.base.getMask());
    }

    public boolean isConstant() {
        return this.base.getType() == spacetype.IPTR_CONSTANT;
    }

    public static AddrSpace getSpaceFromConst(Address addr) {
        return AddrSpaceToIdSymmetryMap.getSpace(addr.offset);
    }

    public Address(mach_extreme ex) {
        if (ex == mach_extreme.m_minimal) {
            this.base = AddrSpace.MIN_SPACE;
            this.offset = 0L;
        } else {
            this.base = AddrSpace.MAX_SPACE;
            this.offset = -1L;
        }
    }

    public boolean endianContain(int sz, Address op2, int sz2) {
        if (this.base != op2.base) {
            return false;
        }
        if (op2.offset < this.offset) {
            return false;
        }
        if (this.base.isBigEndian()) {
            long off1 = this.offset + (long)(sz - 1);
            long off2 = op2.offset + (long)(sz2 - 1);
            return off1 == off2;
        }
        if (op2.offset != this.offset) {
            return false;
        }
        return sz2 <= sz;
    }

    public int overlap(int skip, Address op, int size) {
        if (this.base != op.base) {
            return -1;
        }
        if (this.base.getType() == spacetype.IPTR_CONSTANT) {
            return -1;
        }
        long dist = this.offset + (long)skip - op.offset;
        if ((dist &= this.base.getMask()) >= (long)size) {
            return -1;
        }
        return (int)dist;
    }

    public static enum mach_extreme {
        m_minimal,
        m_maximal;

    }
}

