/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.NativeLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jogamp.common.os.DynamicLinkerImpl;

public final class WindowsDynamicLinkerImpl
extends DynamicLinkerImpl {
    public static final int DONT_RESOLVE_DLL_REFERENCES = 1;
    public static final int LOAD_LIBRARY_AS_DATAFILE = 2;
    public static final int LOAD_WITH_ALTERED_SEARCH_PATH = 8;
    public static final int LOAD_IGNORE_CODE_AUTHZ_LEVEL = 16;
    public static final int LOAD_LIBRARY_AS_IMAGE_RESOURCE = 32;
    public static final int LOAD_LIBRARY_AS_DATAFILE_EXCLUSIVE = 64;
    public static final int LOAD_LIBRARY_REQUIRE_SIGNED_TARGET = 128;
    public static final int LOAD_LIBRARY_SEARCH_DLL_LOAD_DIR = 256;
    public static final int LOAD_LIBRARY_SEARCH_APPLICATION_DIR = 512;
    public static final int LOAD_LIBRARY_SEARCH_USER_DIRS = 1024;
    public static final int LOAD_LIBRARY_SEARCH_SYSTEM32 = 2048;
    public static final int LOAD_LIBRARY_SEARCH_DEFAULT_DIRS = 4096;
    public static final int LOAD_LIBRARY_SAFE_CURRENT_DIRS = 8192;
    private static final boolean TRACE = false;
    private static final int symbolArgAlignment = 4;
    private static final int symbolMaxArguments = 12;

    private static native int FreeLibrary(long var0);

    private static native int GetLastError();

    private static native long GetProcAddressA(long var0, String var2);

    private static native long LoadLibraryW(String var0);

    private static native long LoadLibraryExW(String var0, int var1);

    private static native long AddDllDirectory(String var0);

    private static native boolean RemoveDllDirectory(long var0);

    private static native String GetModuleFileNameA(long var0);

    @Override
    protected final long openLibraryLocalImpl(NativeLibrary.LibPath libPath) throws SecurityException {
        return this.openLibraryImpl(libPath);
    }

    @Override
    protected final long openLibraryGlobalImpl(NativeLibrary.LibPath libPath) throws SecurityException {
        return this.openLibraryImpl(libPath);
    }

    private final long openLibraryImpl(NativeLibrary.LibPath libPath) throws SecurityException {
        int n = 0;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (null != libPath.searchPathPrepend && !libPath.searchPathPrepend.isEmpty()) {
            StringTokenizer stringTokenizer = new StringTokenizer(libPath.searchPathPrepend, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                long l = WindowsDynamicLinkerImpl.AddDllDirectory(string);
                if (0L == l) continue;
                arrayList.add(l);
            }
        }
        if (libPath.addToSearchPath && libPath.isAbsolute) {
            n |= 0x1100;
        }
        long l = WindowsDynamicLinkerImpl.LoadLibraryExW(libPath.path, n);
        for (Long l2 : arrayList) {
            boolean bl = WindowsDynamicLinkerImpl.RemoveDllDirectory(l2);
        }
        return l;
    }

    @Override
    protected final String lookupLibraryPathnameImpl(long l, String string) throws SecurityException {
        return 0L != l ? WindowsDynamicLinkerImpl.GetModuleFileNameA(l) : null;
    }

    @Override
    protected final long lookupSymbolGlobalImpl(String string) throws SecurityException {
        if (DEBUG_LOOKUP) {
            System.err.println("lookupSymbolGlobal: Not supported on Windows");
        }
        return 0L;
    }

    @Override
    protected final long lookupSymbolLocalImpl(long l, String string) throws IllegalArgumentException {
        String string2 = string;
        long l2 = WindowsDynamicLinkerImpl.GetProcAddressA(l, string2);
        if (0L == l2) {
            for (int i = 0; 0L == l2 && i <= 12; ++i) {
                string2 = string + "@" + i * 4;
                l2 = WindowsDynamicLinkerImpl.GetProcAddressA(l, string2);
            }
        }
        return l2;
    }

    @Override
    protected final void closeLibraryImpl(long l) throws IllegalArgumentException {
        WindowsDynamicLinkerImpl.FreeLibrary(l);
    }

    @Override
    public final String getLastError() {
        int n = WindowsDynamicLinkerImpl.GetLastError();
        return "Last error: 0x" + Integer.toHexString(n) + " (" + n + ")";
    }
}

