/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.importer.HasRawCodeUnitOrigin;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;

class RawTryCatchBlock
implements HasRawCodeUnitOrigin {
    private final Set<JavaClassDescriptor> caughtThrowables;
    private final int lineNumber;
    private final Set<RawAccessRecord> accessesInTryBlock;
    private final RawAccessRecord.CodeUnit declaringCodeUnit;
    private final boolean declaredInLambda;

    private RawTryCatchBlock(Builder builder) {
        this.caughtThrowables = ImmutableSet.copyOf(builder.caughtThrowables);
        this.lineNumber = builder.lineNumber;
        this.accessesInTryBlock = ImmutableSet.copyOf(builder.rawAccessesContainedInTryBlock);
        this.declaringCodeUnit = Preconditions.checkNotNull(builder.declaringCodeUnit);
        this.declaredInLambda = builder.declaredInLambda;
    }

    Set<JavaClassDescriptor> getCaughtThrowables() {
        return this.caughtThrowables;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    Set<RawAccessRecord> getAccessesInTryBlock() {
        return this.accessesInTryBlock;
    }

    RawAccessRecord.CodeUnit getDeclaringCodeUnit() {
        return this.declaringCodeUnit;
    }

    @Override
    public RawAccessRecord.CodeUnit getOrigin() {
        return this.getDeclaringCodeUnit();
    }

    @Override
    public boolean isDeclaredInLambda() {
        return this.declaredInLambda;
    }

    static class Builder
    implements HasRawCodeUnitOrigin.Builder<RawTryCatchBlock> {
        private Set<JavaClassDescriptor> caughtThrowables = new HashSet<JavaClassDescriptor>();
        private int lineNumber;
        private Set<RawAccessRecord> rawAccessesContainedInTryBlock = new HashSet<RawAccessRecord>();
        private RawAccessRecord.CodeUnit declaringCodeUnit;
        private boolean declaredInLambda = false;

        Builder() {
        }

        Builder withCaughtThrowables(Set<JavaClassDescriptor> caughtThrowables) {
            this.caughtThrowables = caughtThrowables;
            return this;
        }

        Builder addCaughtThrowable(JavaClassDescriptor throwableType) {
            this.caughtThrowables.add(throwableType);
            return this;
        }

        Builder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        Builder withRawAccessesContainedInTryBlock(Set<RawAccessRecord> accessRecords) {
            this.rawAccessesContainedInTryBlock = accessRecords;
            return this;
        }

        Builder addRawAccessContainedInTryBlock(RawAccessRecord accessRecord) {
            this.rawAccessesContainedInTryBlock.add(accessRecord);
            return this;
        }

        Builder withDeclaringCodeUnit(RawAccessRecord.CodeUnit declaringCodeUnit) {
            this.declaringCodeUnit = declaringCodeUnit;
            return this;
        }

        public Builder withOrigin(RawAccessRecord.CodeUnit origin) {
            return this.withDeclaringCodeUnit(origin);
        }

        public Builder withDeclaredInLambda(boolean declaredInLambda) {
            this.declaredInLambda = declaredInLambda;
            return this;
        }

        @Override
        public RawTryCatchBlock build() {
            return new RawTryCatchBlock(this);
        }

        static Builder from(RawTryCatchBlock tryCatchBlock) {
            return new Builder().withCaughtThrowables(tryCatchBlock.getCaughtThrowables()).withLineNumber(tryCatchBlock.getLineNumber()).withRawAccessesContainedInTryBlock(tryCatchBlock.getAccessesInTryBlock()).withDeclaringCodeUnit(tryCatchBlock.getOrigin()).withDeclaredInLambda(tryCatchBlock.isDeclaredInLambda());
        }
    }
}

