/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassPath;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.WeavingHooks;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;

public final class BundleClassLoader
extends ClassLoader
implements BundleReference {
    static final int ONLY_FIRST = 1;
    static final int LIST = 2;
    static final int ONLY_RECURSE = 4;
    static final int RECURSE = 256;
    static final int LOCAL = 512;
    final FrameworkContext fwCtx;
    final PermissionOps secure;
    final ProtectionDomain protectionDomain;
    BundleArchive archive;
    BundlePackages bpkgs;
    private final BundleClassPath classPath;
    private static ThreadLocal<ArrayList<BundleImpl>> tlBundlesToActivate = new ThreadLocal();
    Debug debug;
    protected static SecurityManagerExposer smex = new SecurityManagerExposer();
    static final SearchAction classSearch = new SearchAction(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(Vector<FileArchive> items, String path, String name, String pkg, int options, BundleClassLoader requestor, BundleClassLoader cl) throws IOException {
            byte[] bytes = items.get(0).getClassBytes(path);
            if (bytes != null) {
                if (cl.debug.classLoader) {
                    cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - load class: " + name);
                }
                BundleClassLoader bundleClassLoader = cl;
                synchronized (bundleClassLoader) {
                    Class c = cl.findLoadedClass(name);
                    if (c == null) {
                        if (pkg != null && cl.getPackage(pkg) == null) {
                            cl.definePackage(pkg, null, null, null, null, null, null, null);
                        }
                        WeavingHooks.WovenClassImpl wc = null;
                        if (cl != null && cl.bpkgs != null && cl.bpkgs.bg != null && cl.bpkgs.bg.bundle != null) {
                            wc = new WeavingHooks.WovenClassImpl(cl.bpkgs.bg.bundle, name, bytes);
                            try {
                                cl.fwCtx.weavingHooks.callHooks(wc);
                                if (wc.hasAdditionalDynamicImports()) {
                                    cl.bpkgs.parseDynamicImports(wc.getDynamicImportsAsString());
                                }
                                bytes = wc.getBytes();
                            }
                            catch (ClassFormatError cfe) {
                                throw cfe;
                            }
                            catch (Throwable t) {
                                ClassFormatError cfe = new ClassFormatError("Failed to call WeavingHooks for " + name);
                                cfe.initCause(t);
                                throw cfe;
                            }
                        }
                        try {
                            c = cl.protectionDomain == null ? cl.defineClass(name, bytes, 0, bytes.length) : cl.defineClass(name, bytes, 0, bytes.length, cl.protectionDomain);
                        }
                        finally {
                            if (wc != null) {
                                wc.setDefinedClass(c);
                            }
                        }
                    }
                    return c;
                }
            }
            return items.get(0).loadClassBytes(name, cl);
        }
    };
    static final SearchAction resourceSearch = new SearchAction(){

        @Override
        public Object get(Vector<FileArchive> items, String path, String name, String pkg, int options, BundleClassLoader requestor, BundleClassLoader cl) throws IOException {
            Vector<URL> answer = new Vector<URL>();
            for (int i = 0; i < items.size(); ++i) {
                FileArchive fa = items.elementAt(i);
                URL url = fa.getBundleGeneration().getURL(fa.getSubId(), path);
                if (url != null) {
                    if (cl.debug.classLoader) {
                        cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - found: " + path + " -> " + url);
                    }
                } else {
                    return null;
                }
                answer.addElement(url);
            }
            return answer.elements();
        }
    };
    static final SearchAction listSearch = new SearchAction(){

        @Override
        public Object get(Vector<FileArchive> items, String path, String name, String pkg, int options, BundleClassLoader requestor, BundleClassLoader cl) throws IOException {
            HashSet<String> answer = new HashSet<String>();
            boolean onlyRecurse = (options & 4) != 0;
            HashSet<String> scanned = new HashSet<String>();
            for (String subPkg : cl.bpkgs.getSubProvider(pkg)) {
                String next;
                Set subAnswer;
                if ((options & 0x100) != 0 && (subAnswer = (Set)cl.searchFor(name, (next = path.length() > 0 ? path + "/" + subPkg : subPkg).replace('/', '.'), next, listSearch, options & 0xFFFFFFFB, requestor, null)) != null) {
                    answer.addAll(subAnswer);
                }
                if (!onlyRecurse && (name == null || Util.filterMatch(name, subPkg))) {
                    answer.add(path + "/" + subPkg);
                }
                scanned.add(subPkg + "/");
            }
            if (items != null) {
                for (FileArchive fa : items) {
                    for (String e : fa.listDir(path)) {
                        if (scanned.contains(e)) {
                            if (!cl.debug.classLoader) continue;
                            cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - list search skip: " + e);
                            continue;
                        }
                        if (cl.debug.classLoader) {
                            cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - list search check: " + e + (onlyRecurse ? " (scan)" : ""));
                        }
                        if (e.endsWith("/")) {
                            String next;
                            Set subAnswer;
                            e = e.substring(0, e.length() - 1);
                            if ((options & 0x100) != 0 && (subAnswer = (Set)cl.searchFor(name, (next = path.length() > 0 ? path + "/" + e : e).replace('/', '.'), next, listSearch, options & 0xFFFFFFFB, requestor, null)) != null) {
                                answer.addAll(subAnswer);
                            }
                        }
                        if (onlyRecurse || name != null && !Util.filterMatch(name, e)) continue;
                        answer.add(path + "/" + e);
                        if (!cl.debug.classLoader) continue;
                        cl.debug.println("classLoader(#" + cl.bpkgs.bg.bundle.id + ") - list search match: " + e);
                    }
                }
            }
            return answer;
        }
    };

    BundleClassLoader(BundleGeneration gen) throws BundleException {
        super(gen.bundle.fwCtx.parentClassLoader);
        this.fwCtx = gen.bundle.fwCtx;
        this.debug = this.fwCtx.debug;
        this.secure = this.fwCtx.perm;
        this.protectionDomain = gen.getProtectionDomain();
        this.bpkgs = gen.bpkgs;
        this.archive = gen.archive;
        this.classPath = new BundleClassPath(this.archive, gen);
        if (this.debug.classLoader) {
            this.debug.println(this + " Created new classloader");
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String pkg;
        String path;
        int pos;
        if (name.startsWith("java.")) {
            return this.fwCtx.parentClassLoader.loadClass(name);
        }
        if (this.fwCtx.isBootDelegated(name)) {
            try {
                Class<?> bootDelegationCls = this.fwCtx.parentClassLoader.loadClass(name);
                if (this.debug.classLoader && bootDelegationCls != null) {
                    this.debug.println(this + " findClass: " + name + " boot delegation: " + bootDelegationCls);
                }
                return bootDelegationCls;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((pos = name.lastIndexOf(46)) != -1) {
            path = name.replace('.', '/');
            pkg = name.substring(0, pos);
        } else {
            path = name;
            pkg = null;
        }
        Class<?> res = (Class<?>)this.secure.callSearchFor(this, name, pkg, path + ".class", classSearch, 1, this, null);
        if (res != null) {
            return res;
        }
        if (!this.fwCtx.props.STRICTBOOTCLASSLOADING && this.isBootClassContext(name)) {
            if (this.debug.classLoader) {
                this.debug.println(this + " trying parent loader for class=" + name + ", since it was loaded on the system loader itself");
            }
            if ((res = this.fwCtx.parentClassLoader.loadClass(name)) != null && this.debug.classLoader) {
                this.debug.println(this + " loaded " + name + " from " + this.fwCtx.parentClassLoader);
            }
            return res;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected String findLibrary(String name) {
        String res = this.secure.callFindLibrary0(this, name);
        if (this.debug.classLoader) {
            this.debug.println(this + " Find library: " + name + (res != null ? " OK" : " FAIL"));
        }
        return res;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return this.getBundleResources(name, false);
    }

    @Override
    protected URL findResource(String name) {
        Enumeration<URL> res = this.getBundleResources(name, true);
        if (res != null && res.hasMoreElements()) {
            return res.nextElement();
        }
        return null;
    }

    private boolean isNonBundleClass(Class<?> cls) {
        return this.getClass().getClassLoader() != cls.getClassLoader() && !ClassLoader.class.isAssignableFrom(cls) && !Class.class.equals(cls) && !Proxy.class.equals(cls);
    }

    public boolean isBootClassContext(String name) {
        Class<?>[] classStack = smex.getClassContext();
        if (classStack == null) {
            try {
                StackTraceElement[] classNames = new Throwable().getStackTrace();
                classStack = new Class[classNames.length];
                for (int i = 1; i < classNames.length; ++i) {
                    classStack[i] = Class.forName(classNames[i].getClassName());
                }
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        for (int i = 1; i < classStack.length; ++i) {
            ClassLoader currentCL;
            Class<?> currentCls = classStack[i];
            if (!this.isNonBundleClass(currentCls)) continue;
            ClassLoader cl = currentCL = currentCls.getClassLoader();
            while (cl != null && cl != cl.getClass().getClassLoader()) {
                if (BundleClassLoader.class.isInstance(cl)) {
                    return false;
                }
                cl = cl.getClass().getClassLoader();
            }
            return !Bundle.class.isInstance(classStack[i - 1]);
        }
        return false;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        BundleImpl b;
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        } else if (this.secure.getClassLoaderOf(c) == this && (b = (BundleImpl)this.getBundle()).triggersActivationCls(name)) {
            ArrayList<BundleImpl> bundlesToActivate;
            if (this.debug.lazy_activation) {
                this.debug.println(this + " lazy activation of #" + b.id + " triggered by loadClass(" + name + ")");
            }
            if (null == (bundlesToActivate = tlBundlesToActivate.get())) {
                if (this.debug.lazy_activation) {
                    this.debug.println(this + " requesting lazy activation of #" + b.id);
                }
                try {
                    this.secure.callFinalizeActivation(b);
                }
                catch (BundleException e) {
                    this.fwCtx.frameworkError(b, (Throwable)e, new FrameworkListener[0]);
                }
            } else {
                boolean bundlePresent = false;
                int size = bundlesToActivate.size();
                for (int i = 0; i < size; ++i) {
                    BundleImpl tmp = bundlesToActivate.get(i);
                    if (tmp.id != b.id) continue;
                    bundlePresent = true;
                    break;
                }
                if (!bundlePresent) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " added #" + b.id + " to list of bundles to be activated.");
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (this.debug.classLoader) {
            this.debug.println(this + " getResource: " + name);
        }
        URL res = null;
        if (name.startsWith("java/")) {
            res = this.fwCtx.parentClassLoader.getResource(name);
            if (this.debug.classLoader) {
                this.debug.println(this + " getResource: " + name + " file in java pkg: " + res);
            }
            return res;
        }
        if (this.fwCtx.isBootDelegatedResource(name) && (res = this.fwCtx.parentClassLoader.getResource(name)) != null) {
            if (this.debug.classLoader) {
                this.debug.println(this + " getResource: " + name + " boot delegation: " + res);
            }
            return res;
        }
        res = this.findResource(name);
        if (this.debug.classLoader) {
            this.debug.println(this + " getResource: " + name + " bundle space: " + res);
        }
        return res;
    }

    public Enumeration<URL> getResourcesOSGi(String name) throws IOException {
        int start;
        if (this.debug.classLoader) {
            this.debug.println(this + " getResources: " + name);
        }
        int n = start = name.startsWith("/") ? 1 : 0;
        if (name.substring(start).startsWith("java/")) {
            return this.fwCtx.parentClassLoader.getResources(name);
        }
        Enumeration<URL> res = null;
        if (this.fwCtx.isBootDelegatedResource(name)) {
            res = this.fwCtx.parentClassLoader.getResources(name);
        }
        if (res == null || !res.hasMoreElements()) {
            res = this.findResources(name);
        }
        return res;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "BundleClassLoader(id=" + this.bpkgs.bg.bundle.id + ",gen=" + this.bpkgs.bg.generation + ")";
    }

    @Override
    public Bundle getBundle() {
        return this.bpkgs.bg.bundle;
    }

    void close() {
        this.archive = null;
        if (this.debug.classLoader) {
            this.debug.println(this + " Cleared archives");
        }
    }

    Enumeration<URL> getBundleResources(String name, boolean onlyFirst) {
        if (this.debug.classLoader) {
            this.debug.println(this + " Find bundle resource" + (onlyFirst ? "" : "s") + ": " + name);
        }
        String pkg = null;
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            int start = name.startsWith("/") ? 1 : 0;
            pkg = name.substring(start, pos).replace('/', '.');
        } else {
            pkg = null;
        }
        Enumeration res = (Enumeration)this.secure.callSearchFor(this, null, pkg, name, resourceSearch, onlyFirst ? 1 : 0, this, null);
        return res;
    }

    BundlePackages getBpkgs() {
        return this.bpkgs;
    }

    void attachFragment(BundleGeneration gen) throws BundleException {
        if (this.debug.classLoader) {
            this.debug.println(this + " fragment attached update classpath");
        }
        this.classPath.attachFragment(gen);
    }

    Collection<String> listResources(String path, String filePattern, int options) {
        if (this.debug.classLoader) {
            this.debug.println(this + " List bundle resources: " + path + ", pattern=" + filePattern);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String pkg = path.replace('/', '.');
        Set res = (Set)this.secure.callSearchFor(this, filePattern, pkg, path, listSearch, options << 8 | 2, this, null);
        return res;
    }

    Object searchFor(String name, String pkg, String path, SearchAction action, int options, BundleClassLoader requestor, HashSet<BundleClassLoader> visited) {
        try {
            BundleImpl b = (BundleImpl)this.getBundle();
            boolean initiator = false;
            ArrayList<BundleImpl> bundlesToActivate = null;
            if (action == classSearch) {
                boolean bundlePresent = false;
                bundlesToActivate = tlBundlesToActivate.get();
                boolean bl = initiator = bundlesToActivate == null;
                if (initiator) {
                    bundlesToActivate = new ArrayList();
                    tlBundlesToActivate.set(bundlesToActivate);
                } else {
                    bundlePresent = bundlesToActivate.contains(b);
                }
                if (!bundlePresent && b.triggersActivationPkg(pkg)) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " lazy activation of #" + b.id + " triggered by searchFor(" + name + ")");
                    }
                }
            }
            Object res = this.searchFor0(name, pkg, path, action, options, requestor, visited);
            if (initiator) {
                tlBundlesToActivate.set(null);
                for (int i = bundlesToActivate.size() - 1; i >= 0; --i) {
                    BundleImpl tmp = bundlesToActivate.get(i);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " requesting lazy activation of #" + tmp.id);
                    }
                    try {
                        tmp.finalizeActivation();
                        continue;
                    }
                    catch (BundleException e) {
                        this.fwCtx.frameworkError(tmp, (Throwable)e, new FrameworkListener[0]);
                    }
                }
            }
            return res;
        }
        catch (Error te) {
            tlBundlesToActivate.set(null);
            throw te;
        }
    }

    Object searchFor0(String name, String pkg, String path, SearchAction action, int options, BundleClassLoader requestor, HashSet<BundleClassLoader> visited) {
        Vector<FileArchive> av;
        Iterator<ExportPkg> ep;
        BundlePackages pbp;
        Class<?> c;
        if (action == classSearch && requestor != this && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        boolean list = (options & 2) != 0;
        boolean local = (options & 0x200) != 0;
        boolean recurse = (options & 0x100) != 0;
        Object answer = null;
        if (this.debug.classLoader) {
            this.debug.println(this + " Search for: " + path);
        }
        if (pkg != null) {
            ArrayList<BundleGeneration> pl;
            pbp = this.bpkgs.getProviderBundlePackages(pkg);
            if (pbp != null) {
                ClassLoader cl = pbp.getClassLoader();
                if (!local || cl == this) {
                    if (BundleClassLoader.isSystemBundle(pbp.bg.bundle)) {
                        answer = this.frameworkSearchFor(cl, name, path, action);
                        if (!recurse) {
                            return answer;
                        }
                    } else {
                        BundleClassLoader bcl = (BundleClassLoader)cl;
                        if (bcl != this && (visited == null || bcl != null && !visited.contains(bcl))) {
                            if (bcl != null) {
                                if (this.debug.classLoader) {
                                    this.debug.println(this + " Import search: " + path + " from #" + pbp.bg.bundle.id);
                                }
                                answer = this.secure.callSearchFor(bcl, name, pkg, path, action, options & 0xFFFFFEFF, requestor, visited);
                            } else if (this.debug.classLoader) {
                                this.debug.println(this + " No import found: " + path);
                            }
                            if (!recurse) {
                                return answer;
                            }
                        }
                    }
                }
                if (cl != this) {
                    options |= 4;
                }
            } else if (!local && (pl = this.bpkgs.getRequiredBundleGenerations(pkg)) != null) {
                if (visited == null) {
                    visited = new HashSet();
                }
                visited.add(this);
                for (BundleGeneration pbg : pl) {
                    ClassLoader cl = pbg.getClassLoader();
                    if (cl instanceof BundleClassLoader) {
                        BundleClassLoader bcl = (BundleClassLoader)cl;
                        if (bcl != null && !visited.contains(bcl)) {
                            if (this.debug.classLoader) {
                                this.debug.println(this + " Required bundle search: " + path + " from #" + pbg.bundle.id);
                            }
                            answer = this.secure.callSearchFor(bcl, name, pkg, path, action, options, requestor, visited);
                        }
                    } else {
                        answer = this.frameworkSearchFor(cl, name, path, action);
                    }
                    if (answer == null) continue;
                    if (list || recurse) break;
                    return answer;
                }
                if (this.debug.classLoader && answer == null) {
                    this.debug.println(this + " Required bundle search: " + "Not found, continuing with local search.");
                }
            }
            ep = this.bpkgs.getExports(pkg);
        } else {
            ep = null;
        }
        if (this != requestor && ep != null && action == classSearch) {
            boolean blocked = true;
            while (ep.hasNext()) {
                if (!ep.next().checkFilter(name)) continue;
                blocked = false;
                break;
            }
            if (blocked) {
                if (this.debug.classLoader) {
                    this.debug.println(this + " Filter check blocked search for: " + name);
                }
                return null;
            }
        }
        if ((av = this.classPath.componentExists(path, (options & 1) != 0, (options & 2) != 0)) != null || recurse) {
            try {
                Object res = action.get(av, path, name, pkg, options, requestor, this);
                if (answer != null) {
                    if (res != null) {
                        Collection ca = (Collection)answer;
                        Collection cr = (Collection)res;
                        ca.addAll(cr);
                    }
                } else {
                    answer = res;
                }
                return answer;
            }
            catch (ClassFormatError cfe) {
                throw cfe;
            }
            catch (IOException ioe) {
                this.fwCtx.frameworkError(this.bpkgs.bg.bundle, (Throwable)ioe, new FrameworkListener[0]);
                return null;
            }
        }
        if (ep != null || (options & 2) != 0) {
            return null;
        }
        if (pkg != null) {
            pbp = this.bpkgs.getDynamicProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bg.bundle)) {
                    try {
                        return this.fwCtx.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != null) {
                        if (this.debug.classLoader) {
                            this.debug.println(this + " Dynamic import search: " + path + " from #" + pbp.bg.bundle.id);
                        }
                        return this.secure.callSearchFor(cl, name, pkg, path, action, options, requestor, visited);
                    }
                }
            }
            if (this.debug.classLoader) {
                this.debug.println(this + " No dynamic import: " + path);
            }
        }
        return null;
    }

    private Object frameworkSearchFor(ClassLoader cl, String name, String path, SearchAction action) {
        if (action == classSearch) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        } else if (action == resourceSearch) {
            try {
                return cl.getResources(path);
            }
            catch (IOException e) {
            }
        } else if (action == listSearch) {
            throw new UnsupportedOperationException("listResources not available on system bundle");
        }
        return null;
    }

    private static boolean isSystemBundle(BundleImpl bundle) {
        return bundle == bundle.fwCtx.systemBundle;
    }

    String findLibrary0(String name) {
        return this.classPath.getNativeLibrary(name);
    }

    Set<BundleGeneration> hasNativeRequirements() {
        return this.classPath.hasNativeRequirements();
    }

    static interface SearchAction {
        public Object get(Vector<FileArchive> var1, String var2, String var3, String var4, int var5, BundleClassLoader var6, BundleClassLoader var7) throws IOException;
    }

    static class SecurityManagerExposer
    extends SecurityManager {
        SecurityManagerExposer() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

