/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.svg.ExportVectorGraphic;
import org.freeplane.view.swing.map.MapView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ExportPdf
extends ExportVectorGraphic {
    private static final String PDF_CONVERT_TEXT_TO_SHAPES = "org.freeplane.plugin.svg.export.pdf.convert_text_to_shapes";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(List<NodeModel> branches, File chosenFile) {
        MapModel map = branches.get(0).getMap();
        if (!ExportController.getContoller().checkCurrentMap(map)) {
            return;
        }
        try {
            MapView view = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
            if (view == null) {
                return;
            }
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            SVGGraphics2D svgGraphics2D = this.createSVGGraphics2D(view);
            new Thread(() -> this.transcodeSvgToPdfFile(chosenFile, svgGraphics2D)).start();
        }
        catch (Exception ex) {
            LogUtils.warn((Throwable)ex);
            UITools.errorMessage((Object)ex.getLocalizedMessage());
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private void transcodeSvgToPdfFile(File chosenFile, SVGGraphics2D g2d) {
        Document doc = g2d.getDOMFactory();
        Element rootE = doc.getDocumentElement();
        g2d.getRoot(rootE);
        TranscoderInput input = new TranscoderInput(doc);
        try {
            try (FileOutputStream ostream = new FileOutputStream(chosenFile);){
                BufferedOutputStream bufStream = new BufferedOutputStream(ostream);
                TranscoderOutput output = new TranscoderOutput((OutputStream)bufStream);
                PDFTranscoder transcoder = this.createPdfTranscoder();
                transcoder.transcode(input, output);
            }
            LinkController.getController().loadHyperlink(new Hyperlink(chosenFile.toURI()));
        }
        catch (IOException | TranscoderException e) {
            LogUtils.warn((Throwable)e);
            UITools.errorMessage((Object)e.getLocalizedMessage());
        }
    }

    private PDFTranscoder createPdfTranscoder() {
        PDFTranscoder pdfTranscoder = new PDFTranscoder();
        pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, (Object)Float.valueOf(19200.0f));
        pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, (Object)Float.valueOf(19200.0f));
        pdfTranscoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(0.35277778f / UITools.FONT_SCALE_FACTOR));
        if (ResourceController.getResourceController().getBooleanProperty(PDF_CONVERT_TEXT_TO_SHAPES)) {
            pdfTranscoder.addTranscodingHint(AbstractFOPTranscoder.KEY_AUTO_FONTS, (Object)Boolean.FALSE);
        } else {
            DefaultConfiguration c = ExportPdf.createFontConfiguration();
            try {
                pdfTranscoder.configure((Configuration)c);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return pdfTranscoder;
    }

    private static DefaultConfiguration createFontConfiguration() {
        DefaultConfiguration c = new DefaultConfiguration("cfg");
        DefaultConfiguration fonts = new DefaultConfiguration("fonts");
        DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
        fonts.addChild(autodetect);
        c.addChild(fonts);
        return c;
    }

    @Override
    protected SVGGeneratorContext createGeneratorContext(Document domFactory) {
        SVGGeneratorContext ctx = super.createGeneratorContext(domFactory);
        if (ResourceController.getResourceController().getBooleanProperty(PDF_CONVERT_TEXT_TO_SHAPES)) {
            ctx.setEmbeddedFontsOn(true);
        }
        return ctx;
    }
}

