/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import javax.swing.JOptionPane;
import org.freeplane.core.ui.components.EnterPasswordDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.encrypt.PasswordStrategy;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class SwingPasswordStrategy
implements PasswordStrategy {
    private boolean isCancelled;

    @Override
    public StringBuilder getPassword(NodeModel node) {
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(UITools.getCurrentFrame(), false);
        return this.getPassword(pwdDialog, node);
    }

    @Override
    public StringBuilder getPasswordWithConfirmation(NodeModel node) {
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(UITools.getCurrentFrame(), true);
        return this.getPassword(pwdDialog, node);
    }

    private StringBuilder getPassword(EnterPasswordDialog pwdDialog, NodeModel node) {
        UITools.setDialogLocationUnder(pwdDialog, node);
        pwdDialog.setVisible(true);
        if (pwdDialog.getResult() == -1) {
            this.isCancelled = true;
            return null;
        }
        return pwdDialog.getPassword();
    }

    @Override
    public void onWrongPassword() {
        Controller controller = Controller.getCurrentController();
        JOptionPane.showMessageDialog(controller.getViewController().getCurrentRootComponent(), TextUtils.getText("accessories/plugins/EncryptNode.properties_wrong_password"), "Freeplane", 0);
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }
}

