/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.cycle_detection;

import com.tngtech.archunit.library.cycle_detection.PrimitiveDataTypes;
import com.tngtech.archunit.library.cycle_detection.PrimitiveGraph;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class JohnsonComponent {
    private final PrimitiveGraph graph;
    private int[] stronglyConnectedComponent = new int[0];
    private final Set<Integer> blocked = new HashSet<Integer>();
    private final Multimap<Integer, Integer> dependentlyBlocked = HashMultimap.create();
    private final PrimitiveDataTypes.IntStack nodeStack;
    private final int[] tempAdjacentNodesInComponent;

    private JohnsonComponent(PrimitiveGraph graph) {
        this.graph = graph;
        this.nodeStack = new PrimitiveDataTypes.IntStack(graph.getSize());
        this.tempAdjacentNodesInComponent = new int[graph.getSize()];
    }

    void init(int[] sortedStronglyConnectedComponent) {
        this.stronglyConnectedComponent = sortedStronglyConnectedComponent;
        this.blocked.clear();
        this.dependentlyBlocked.clear();
    }

    int[] getAdjacentNodesOf(int nodeIndex) {
        int index = 0;
        for (int candidate : this.graph.getAdjacentNodesOf(nodeIndex)) {
            if (!this.componentContains(candidate)) continue;
            this.tempAdjacentNodesInComponent[index++] = candidate;
        }
        return Arrays.copyOf(this.tempAdjacentNodesInComponent, index);
    }

    private boolean componentContains(int nodeIndex) {
        return Arrays.binarySearch(this.stronglyConnectedComponent, nodeIndex) >= 0;
    }

    boolean isStartNodeIndex(int nodeIndex) {
        return this.getStartNodeIndex() == nodeIndex;
    }

    int getStartNodeIndex() {
        return this.stronglyConnectedComponent[0];
    }

    boolean isNotBlocked(int nodeIndex) {
        return !this.blocked.contains(nodeIndex);
    }

    void block(int nodeIndex) {
        this.blocked.add(nodeIndex);
    }

    void unblock(int nodeIndex) {
        if (!this.blocked.remove(nodeIndex)) {
            return;
        }
        for (Integer dependentlyBlockedIndex : this.dependentlyBlocked.get(nodeIndex)) {
            this.unblock(dependentlyBlockedIndex);
        }
        this.dependentlyBlocked.get(nodeIndex).clear();
    }

    void markDependentlyBlocked(int indexOfNodeDependentlyBlocked, int indexOfNode) {
        this.dependentlyBlocked.put(indexOfNode, indexOfNodeDependentlyBlocked);
    }

    void pushOnStack(int nodeIndex) {
        this.nodeStack.push(nodeIndex);
    }

    void popFromStack() {
        this.nodeStack.pop();
    }

    int[] getStack() {
        return this.nodeStack.asArray();
    }

    static JohnsonComponent within(PrimitiveGraph graph) {
        return new JohnsonComponent(graph);
    }
}

