/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class StackLayout
extends AbstractHintLayout {
    @Override
    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        for (IFigure iFigure : figure.getChildren()) {
            if (this.isObservingVisibility() && !iFigure.isVisible()) continue;
            d.union(iFigure.getMinimumSize(wHint, hHint));
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    @Override
    protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        for (IFigure iFigure : figure.getChildren()) {
            if (this.isObservingVisibility() && !iFigure.isVisible()) continue;
            d.union(iFigure.getPreferredSize(wHint, hHint));
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    @Override
    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        figure.getChildren().forEach(child -> child.setBounds(r));
    }
}

