/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.datagrip.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.config.migration.datagrip.api.DataGripDataSourceConfigXmlService;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConfigurationException;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataGripDataSourceConfigXmlServiceImpl
implements DataGripDataSourceConfigXmlService {
    public static final DataGripDataSourceConfigXmlServiceImpl INSTANCE = new DataGripDataSourceConfigXmlServiceImpl();
    private static final Log log = Log.getLog(DataGripDataSourceConfigXmlServiceImpl.class);

    private DataGripDataSourceConfigXmlServiceImpl() {
    }

    @Override
    @NotNull
    public Map<String, Map<String, String>> buildIdeaConfigProps(@NotNull String pathToIdeaFolder) throws Exception {
        Map<String, Map<String, String>> uuidToDataSourceProps = new HashMap<String, Map<String, String>>();
        Path pathToDataSource = Path.of(pathToIdeaFolder, ".idea", "dataSources.xml");
        Path pathToDataSourceLocal = Path.of(pathToIdeaFolder, ".idea", "dataSources.local.xml");
        uuidToDataSourceProps.putAll(this.importXML(pathToDataSource));
        Map<String, Map<String, String>> uuidToDataSourceFromDifferentXml = this.importXML(pathToDataSourceLocal);
        uuidToDataSourceProps = this.mergeTwoMapProps(uuidToDataSourceProps, uuidToDataSourceFromDifferentXml);
        Map<String, Map<String, String>> sshIdToSshConfigMap = this.tryReadIdeaSshConfig(this.getJetBrainsDirectory());
        uuidToDataSourceProps = this.mergeSshConfigToIdeaConfigMap(uuidToDataSourceProps, sshIdToSshConfigMap);
        return uuidToDataSourceProps;
    }

    @Override
    @NotNull
    public List<Path> tryExtractRecentProjectPath() {
        try {
            Path pathSuffixToFile = Path.of("options", "recentProjects.xml");
            List<Path> pathToRecentProjectXmlList = this.getAllExistingPathsToFileFromFolder(this.getJetBrainsDirectory(), pathSuffixToFile);
            ArrayList<Path> result = new ArrayList<Path>();
            for (Path projectFile : pathToRecentProjectXmlList) {
                Path projectPath;
                String projectConfigPath = this.getRecentProjectPathFromXml(projectFile);
                if (CommonUtils.isEmpty((String)projectConfigPath) || !Files.exists(projectPath = Path.of(this.replaceUserHomePath(projectConfigPath), new String[0]), new LinkOption[0])) continue;
                result.add(projectPath);
            }
            return result;
        }
        catch (Exception e) {
            log.warn((Object)"Can't extract recent project path for DataGrip", (Throwable)e);
            return List.of();
        }
    }

    private String replaceUserHomePath(String path) {
        String[] split = path.split("\\$/");
        if (split.length < 2) {
            return path;
        }
        String pathFromUserHome = split[1];
        String osDependencePath = CommonUtils.makeOsDependencePath((String)pathFromUserHome);
        return System.getProperty("user.home") + File.separator + osDependencePath;
    }

    @Override
    @NotNull
    public ImportConnectionInfo buildIdeaConnectionFromProps(@NotNull Map<String, String> conProps) {
        ImportDriverInfo driverInfo = this.buildDriverInfo(conProps);
        String url = conProps.get("jdbc-url");
        ImportConnectionInfo connectionInfo = new ImportConnectionInfo(driverInfo, conProps.get("data-source.uuid"), conProps.get("data-source.name"), url, null, null, "", conProps.get("user-name"), "");
        this.configureDriverProperties(connectionInfo, conProps);
        this.configureSshConfig(connectionInfo, conProps);
        log.debug((Object)("load connection: " + String.valueOf(connectionInfo)));
        return connectionInfo;
    }

    private void configureDriverProperties(ImportConnectionInfo connectionInfo, Map<String, String> conProps) {
        for (Map.Entry<String, String> conPropEntry : conProps.entrySet()) {
            if (!conPropEntry.getKey().startsWith("property$")) continue;
            connectionInfo.setProperty(conPropEntry.getKey().substring("property".length() + 1), conPropEntry.getValue());
        }
    }

    private List<Path> getAllExistingPathsToFileFromFolder(String pathToIdeaFolder, Path pathSuffixToFile) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> paths = Files.list(Paths.get(pathToIdeaFolder, new String[0]));){
            List<Path> ideaFolders = paths.filter(path -> Files.isDirectory(path, new LinkOption[0])).toList();
            ArrayList<Path> result = new ArrayList<Path>();
            for (Path ideaFolder : ideaFolders) {
                Path pathToFile = ideaFolder.resolve(pathSuffixToFile);
                if (!Files.exists(pathToFile, new LinkOption[0])) continue;
                result.add(pathToFile);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getJetBrainsDirectory() {
        Path defaultWorkingDirectory = Path.of("JetBrains", new String[0]);
        if (RuntimeUtils.isMacOS()) {
            defaultWorkingDirectory = Path.of("Application Support", "JetBrains");
        } else if (RuntimeUtils.isLinux()) {
            Path path = Path.of(System.getProperty("user.home"), ".config", "JetBrains");
            log.info((Object)("Using linux path for import config home directory: " + String.valueOf(path)));
            return path.toString();
        }
        return RuntimeUtils.getWorkingDirectory((String)defaultWorkingDirectory.toString());
    }

    private Path getMostRecentFile(List<Path> pathToRecentProjectXmlList) throws IOException {
        Path lastModifiedPath = null;
        long maxMilis = Long.MIN_VALUE;
        for (Path path : pathToRecentProjectXmlList) {
            long lastModifiedMilis = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            if (lastModifiedMilis <= maxMilis) continue;
            maxMilis = lastModifiedMilis;
            lastModifiedPath = path;
        }
        return lastModifiedPath;
    }

    private String getRecentProjectPathFromXml(Path filePath) throws IOException, XMLException {
        Document document = XMLUtils.parseDocument((String)filePath.toAbsolutePath().toString());
        NodeList optionList = document.getElementsByTagName("option");
        if (optionList.getLength() == 0) {
            return "";
        }
        int i = 0;
        while (i < optionList.getLength()) {
            Node item = optionList.item(i);
            NamedNodeMap attributes = item.getAttributes();
            Node nameAttr = attributes.getNamedItem("name");
            if (nameAttr != null && "lastOpenedProject".equals(nameAttr.getNodeValue())) {
                return attributes.getNamedItem("value").getNodeValue();
            }
            ++i;
        }
        return "";
    }

    private void configureSshConfig(ImportConnectionInfo connectionInfo, Map<String, String> conProps) {
        NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("ssh_tunnel");
        DBWHandlerConfiguration sshHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, null);
        sshHandler.setUserName(conProps.get("sshConfig.username"));
        sshHandler.setSavePassword(true);
        sshHandler.setProperty("host", (Object)conProps.get("sshConfig.host"));
        sshHandler.setProperty("port", (Object)conProps.get("sshConfig.port"));
        if (!CommonUtils.isEmpty((String)conProps.get("sshConfig.keyPath"))) {
            sshHandler.setProperty("authType", (Object)"PUBLIC_KEY");
            sshHandler.setProperty("keyPath", (Object)conProps.get("sshConfig.keyPath"));
        } else if ("OPEN_SSH".equals(conProps.get("sshConfig.authType"))) {
            sshHandler.setProperty("authType", (Object)"AGENT");
        } else {
            sshHandler.setProperty("authType", (Object)"PASSWORD");
        }
        sshHandler.setProperty("implementation", (Object)"sshj");
        sshHandler.setEnabled(true);
        connectionInfo.addNetworkHandler(sshHandler);
    }

    private Map<String, Map<String, String>> mergeSshConfigToIdeaConfigMap(Map<String, Map<String, String>> uuidToDataSourceProps, Map<String, Map<String, String>> sshIdToSshConfigMap) {
        for (Map.Entry<String, Map<String, String>> configEntry : uuidToDataSourceProps.entrySet()) {
            Map<String, String> config = configEntry.getValue();
            String sshUuid = config.get("ssh-properties.ssh-config-id");
            Map<String, String> sshConfig = sshIdToSshConfigMap.get(sshUuid);
            if (sshConfig == null) continue;
            config.putAll(sshConfig);
        }
        return uuidToDataSourceProps;
    }

    private Map<String, Map<String, String>> tryReadIdeaSshConfig(String pathToJetBrainsHomeDirectory) {
        try {
            return this.readIdeaSshConfig(pathToJetBrainsHomeDirectory);
        }
        catch (Exception e) {
            log.warn((Object)"Could not read Idea ssh config", (Throwable)e);
            return new HashMap<String, Map<String, String>>();
        }
    }

    private Map<String, Map<String, String>> mergeTwoMapProps(Map<String, Map<String, String>> uuidToDataSourceProps, Map<String, Map<String, String>> uuidToDataSourceFromDifferentXml) {
        for (Map.Entry<String, Map<String, String>> uuidToDataSourceEntry : uuidToDataSourceProps.entrySet()) {
            Map<String, String> mergeValue;
            Map<String, String> dataSourceProps = uuidToDataSourceProps.get(uuidToDataSourceEntry.getKey());
            if (dataSourceProps == null) {
                log.warn((Object)("Unexpectedly haven't found data source properties for " + uuidToDataSourceEntry.getKey()));
                dataSourceProps = new HashMap<String, String>();
            }
            if ((mergeValue = uuidToDataSourceFromDifferentXml.get(uuidToDataSourceEntry.getKey())) == null) continue;
            dataSourceProps.putAll(mergeValue);
        }
        return uuidToDataSourceProps;
    }

    private Map<String, Map<String, String>> readIdeaSshConfig(String pathToIdeaFolder) throws Exception {
        Path pathToSshFile = Path.of("options", "sshConfigs.xml");
        HashMap<String, Map<String, String>> sshConfig = new HashMap<String, Map<String, String>>();
        List<Path> allPossiblePathToFileFromFolder = this.getAllExistingPathsToFileFromFolder(pathToIdeaFolder, pathToSshFile);
        for (Path path : allPossiblePathToFileFromFolder) {
            sshConfig.putAll(this.importXML(path));
        }
        return sshConfig;
    }

    private Map<String, Map<String, String>> importXML(Path filePath) throws XMLException {
        Document document = XMLUtils.parseDocument((String)filePath.toAbsolutePath().toString());
        Map<String, String> conProps = new HashMap();
        HashMap<String, Map<String, String>> uuidToDatasourceProps = new HashMap<String, Map<String, String>>();
        NodeList allElements = document.getElementsByTagName("*");
        if (allElements.getLength() == 0) {
            throw new ImportConfigurationException("No elements found");
        }
        String uuid = null;
        int i = 0;
        while (i < allElements.getLength()) {
            block14: {
                NamedNodeMap attrs;
                Node element;
                block13: {
                    element = allElements.item(i);
                    attrs = element.getAttributes();
                    if ("data-source".equals(element.getNodeName())) {
                        if (uuid != null) {
                            uuidToDatasourceProps.put(uuid, conProps);
                        }
                        String uuidOfNewDataSource = attrs.getNamedItem("uuid").getNodeValue();
                        conProps = uuidToDatasourceProps.getOrDefault(uuidOfNewDataSource, new HashMap());
                        uuid = uuidOfNewDataSource;
                    }
                    if (!"property".equals(element.getNodeName())) break block13;
                    Node value = attrs.getNamedItem("value");
                    String name = attrs.getNamedItem("name").getNodeValue();
                    if (name.startsWith("com.intellij")) break block14;
                    conProps.put("property$" + name, value == null ? "" : value.getNodeValue());
                }
                if ("sshConfig".equals(element.getNodeName())) {
                    uuid = attrs.getNamedItem("id").getNodeValue();
                    conProps = uuidToDatasourceProps.computeIfAbsent(uuid, key -> new HashMap());
                }
                if ("ssh-properties".equals(element.getNodeName())) {
                    Node sshEnabled = allElements.item(++i);
                    conProps.put("ssh-properties.enable", sshEnabled.getFirstChild().getNodeValue());
                    Node sshUuid = allElements.item(++i);
                    conProps.put("ssh-properties.ssh-config-id", sshUuid.getFirstChild().getNodeValue());
                } else {
                    int j = 0;
                    while (j < attrs.getLength()) {
                        Attr attr = (Attr)attrs.item(j);
                        if (attr != null) {
                            String key2 = String.format("%s.%s", element.getNodeName(), attr.getName());
                            conProps.put(key2, attr.getValue());
                        }
                        ++j;
                    }
                    if (DataGripDataSourceConfigXmlServiceImpl.isNodeHasTextValue(element)) {
                        conProps.put(element.getNodeName(), element.getFirstChild().getNodeValue());
                    }
                }
            }
            ++i;
        }
        uuidToDatasourceProps.put(uuid, conProps);
        return uuidToDatasourceProps;
    }

    private URI parseURL(String url) {
        String jdbcString = "jdbc:";
        int indexOf = url.indexOf(jdbcString);
        String cleanURI = indexOf == -1 ? url : url.substring(indexOf + jdbcString.length());
        return URI.create(cleanURI);
    }

    private static boolean isNodeHasTextValue(Node element) {
        return element.hasChildNodes() && element.getChildNodes().getLength() > 0 && !element.getFirstChild().getNodeValue().isBlank();
    }

    private ImportDriverInfo buildDriverInfo(Map<String, String> conProps) {
        String refDriverName;
        String name = conProps.get("database-info.dbms");
        DBPDriver driver = this.findDriver(name, refDriverName = conProps.get("driver-ref"));
        if (driver == null && (driver = this.tryFindDriverByToken(name)) == null) {
            driver = this.tryExtractDriverByUrl(conProps.get("jdbc-url"));
        }
        return new ImportDriverInfo(driver);
    }

    private DBPDriver tryExtractDriverByUrl(String url) {
        URI uri = this.parseURL(url);
        String scheme = uri.getScheme();
        return this.findDriver(scheme, null);
    }

    private DBPDriver tryFindDriverByToken(String name) {
        if (name == null) {
            return null;
        }
        List<String> nameTokens = Arrays.stream(name.split("_")).toList();
        if (nameTokens.size() > 1) {
            for (String nameToken : nameTokens) {
                DBPDriver driver = this.findDriver(nameToken, null);
                if (driver == null) continue;
                return driver;
            }
        }
        return null;
    }

    private DBPDriver findDriver(@NotNull String name, @Nullable String refDriverName) {
        DataSourceProviderRegistry dataSourceProviderRegistry = DataSourceProviderRegistry.getInstance();
        List dataSourceProviders = dataSourceProviderRegistry.getDataSourceProviders();
        for (DataSourceProviderDescriptor dataSourceProvider : dataSourceProviders) {
            List drivers = dataSourceProvider.getDrivers();
            for (DriverDescriptor driver : drivers) {
                if (!driver.getName().equalsIgnoreCase(name) && !driver.getId().equalsIgnoreCase(name) && !driver.getName().equalsIgnoreCase(refDriverName) && !driver.getId().equalsIgnoreCase(refDriverName)) continue;
                while (driver.getReplacedBy() != null) {
                    driver = driver.getReplacedBy();
                }
                return driver;
            }
            if (!dataSourceProvider.getId().equalsIgnoreCase(name) && !dataSourceProvider.getName().equalsIgnoreCase(name) && !dataSourceProvider.getId().equalsIgnoreCase(refDriverName) && !dataSourceProvider.getName().equalsIgnoreCase(refDriverName) || drivers.isEmpty()) continue;
            DriverDescriptor driverDescriptor = (DriverDescriptor)drivers.get(0);
            while (driverDescriptor.getReplacedBy() != null) {
                driverDescriptor = driverDescriptor.getReplacedBy();
            }
            return driverDescriptor;
        }
        return null;
    }
}

