﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/s3/S3_EXPORTS.h>
#include <aws/s3/model/CORSRule.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace S3 {
namespace Model {
class GetBucketCorsResult {
 public:
  AWS_S3_API GetBucketCorsResult() = default;
  AWS_S3_API GetBucketCorsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_S3_API GetBucketCorsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A set of origins and methods (cross-origin access that you want to allow).
   * You can add up to 100 rules to the configuration.</p>
   */
  inline const Aws::Vector<CORSRule>& GetCORSRules() const { return m_cORSRules; }
  template <typename CORSRulesT = Aws::Vector<CORSRule>>
  void SetCORSRules(CORSRulesT&& value) {
    m_cORSRulesHasBeenSet = true;
    m_cORSRules = std::forward<CORSRulesT>(value);
  }
  template <typename CORSRulesT = Aws::Vector<CORSRule>>
  GetBucketCorsResult& WithCORSRules(CORSRulesT&& value) {
    SetCORSRules(std::forward<CORSRulesT>(value));
    return *this;
  }
  template <typename CORSRulesT = CORSRule>
  GetBucketCorsResult& AddCORSRules(CORSRulesT&& value) {
    m_cORSRulesHasBeenSet = true;
    m_cORSRules.emplace_back(std::forward<CORSRulesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetBucketCorsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<CORSRule> m_cORSRules;
  bool m_cORSRulesHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace S3
}  // namespace Aws
