﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class AssociateNetworkSettingsResult {
 public:
  AWS_WORKSPACESWEB_API AssociateNetworkSettingsResult() = default;
  AWS_WORKSPACESWEB_API AssociateNetworkSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API AssociateNetworkSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the web portal.</p>
   */
  inline const Aws::String& GetPortalArn() const { return m_portalArn; }
  template <typename PortalArnT = Aws::String>
  void SetPortalArn(PortalArnT&& value) {
    m_portalArnHasBeenSet = true;
    m_portalArn = std::forward<PortalArnT>(value);
  }
  template <typename PortalArnT = Aws::String>
  AssociateNetworkSettingsResult& WithPortalArn(PortalArnT&& value) {
    SetPortalArn(std::forward<PortalArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the network settings.</p>
   */
  inline const Aws::String& GetNetworkSettingsArn() const { return m_networkSettingsArn; }
  template <typename NetworkSettingsArnT = Aws::String>
  void SetNetworkSettingsArn(NetworkSettingsArnT&& value) {
    m_networkSettingsArnHasBeenSet = true;
    m_networkSettingsArn = std::forward<NetworkSettingsArnT>(value);
  }
  template <typename NetworkSettingsArnT = Aws::String>
  AssociateNetworkSettingsResult& WithNetworkSettingsArn(NetworkSettingsArnT&& value) {
    SetNetworkSettingsArn(std::forward<NetworkSettingsArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AssociateNetworkSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_portalArn;

  Aws::String m_networkSettingsArn;

  Aws::String m_requestId;
  bool m_portalArnHasBeenSet = false;
  bool m_networkSettingsArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
